/*
 * Decompiled with CFR 0.152.
 */
package padl.pattern.repository;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import padl.kernel.IAssociation;
import padl.kernel.IClass;
import padl.kernel.IDelegatingMethod;
import padl.kernel.IMethod;
import padl.kernel.IPatternModel;
import padl.kernel.ModelDeclarationException;
import padl.kernel.impl.v2.Factory;
import padl.pattern.StructuralPatternModel;
import padl.visitor.PtidejSolver2AC4DomainGenerator;
import padl.visitor.PtidejSolverAC4ConstraintGenerator;
import util.io.OutputManager;

public class Proxy
extends StructuralPatternModel
implements Cloneable {
    public Proxy() throws CloneNotSupportedException, ModelDeclarationException {
        super("Proxy");
        this.setFactory(Factory.getUniqueInstance());
        IClass aSubject = this.getFactory().createClass("Subject");
        IMethod aSubjectMethod = this.getFactory().createMethod("request");
        aSubject.addActor(aSubjectMethod);
        IClass aRealSubject = this.getFactory().createClass("RealSubject");
        aRealSubject.addInheritedActor(aSubject);
        IMethod aRealSubjectMethod = this.getFactory().createMethod("request");
        aRealSubject.addActor(aRealSubjectMethod);
        IClass aProxy = this.getFactory().createClass("Proxy");
        aProxy.addInheritedActor(aSubject);
        IAssociation associationProxyRealSubject = this.getFactory().createAssociationRelationship("realSubject", aRealSubject, 1);
        aProxy.addActor(associationProxyRealSubject);
        IMethod aProxyMethod = this.getFactory().createMethod("request");
        IDelegatingMethod aPDelegatingMethod = this.getFactory().createDelegatingMethod("request", associationProxyRealSubject);
        aPDelegatingMethod.attachTo(aProxyMethod);
        aProxy.addActor(aPDelegatingMethod);
        aRealSubjectMethod.attachTo(aSubjectMethod);
        aProxyMethod.attachTo(aSubjectMethod);
        this.addActor(aSubject);
        this.addActor(aRealSubject);
        this.addActor(aProxy);
    }

    public List compare(IPatternModel aPattern) {
        List solutions = super.compare(aPattern);
        if (solutions.size() != 1) {
            return solutions;
        }
        HashMap matched = (HashMap)solutions.get(0);
        solutions.clear();
        Iterator iterator = ((List)matched.get("Subject")).iterator();
        while (iterator.hasNext()) {
            IClass tempCurrentClass;
            IClass currentClass = (IClass)iterator.next();
            ArrayList<IClass> tmpVector = new ArrayList<IClass>();
            ArrayList<IClass> tmpVector2 = new ArrayList<IClass>();
            tmpVector2.add(currentClass);
            HashMap<String, ArrayList<IClass>> currentSolution = new HashMap<String, ArrayList<IClass>>();
            currentSolution.put("Subject", tmpVector2);
            Iterator iterator2 = ((List)matched.get("Proxy")).iterator();
            while (iterator2.hasNext()) {
                tempCurrentClass = (IClass)iterator2.next();
                if (!tempCurrentClass.listOfInheritedActors().contains(currentClass)) continue;
                tmpVector.add(tempCurrentClass);
            }
            if (tmpVector.size() > 0) {
                currentSolution.put("Proxy", tmpVector);
            }
            tmpVector.clear();
            iterator2 = ((List)matched.get("RealSubject")).iterator();
            while (iterator2.hasNext()) {
                tempCurrentClass = (IClass)iterator2.next();
                if (!tempCurrentClass.listOfInheritedActors().contains(currentClass)) continue;
                tmpVector.add(tempCurrentClass);
            }
            if (tmpVector.size() > 0) {
                currentSolution.put("RealSubject", tmpVector);
            }
            if (currentSolution.size() != this.listOfActors().size()) continue;
            solutions.add(currentSolution);
        }
        return solutions;
    }

    public String getIdiom() {
        return "None";
    }

    public String getIntent() {
        return "Provide a surrogate or placeholder\nfor another object to control access to it.";
    }

    public String getName() {
        return "Proxy";
    }

    public static void main(String[] args) throws CloneNotSupportedException, ModelDeclarationException {
        Proxy proxy = new Proxy();
        PtidejSolverAC4ConstraintGenerator constraintGenerator = new PtidejSolverAC4ConstraintGenerator();
        PtidejSolver2AC4DomainGenerator domainGenerator = new PtidejSolver2AC4DomainGenerator();
        proxy.generate(constraintGenerator);
        OutputManager.getCurrentOutputManager().getNormalOutput().println(constraintGenerator.getCode());
        OutputManager.getCurrentOutputManager().getNormalOutput().println("----");
        proxy.walk(domainGenerator);
        OutputManager.getCurrentOutputManager().getNormalOutput().println(domainGenerator.getResult());
    }
}

