/*
 * Decompiled with CFR 0.152.
 */
package padl.pattern.repository;

import padl.event.IListener;
import padl.kernel.IAssociation;
import padl.kernel.IClass;
import padl.kernel.IEntity;
import padl.kernel.IInterface;
import padl.kernel.IMethod;
import padl.kernel.ListenerManager;
import padl.kernel.ModelDeclarationException;
import padl.kernel.impl.v2.Factory;
import padl.pattern.StructuralPatternModel;
import padl.util.ModelStatistics;
import padl.visitor.JavaGenerator;
import padl.visitor.PtidejSolver2AC4DomainGenerator;
import padl.visitor.PtidejSolverAC4ConstraintGenerator;
import padl.visitor.PtidejSolverCustomConstraintGenerator;
import util.io.OutputManager;

public class Visitor
extends StructuralPatternModel
implements Cloneable {
    public Visitor() throws CloneNotSupportedException, ModelDeclarationException {
        this((IListener)null);
    }

    public Visitor(IListener patternListener) throws CloneNotSupportedException, ModelDeclarationException {
        super("Visitor");
        this.setFactory(Factory.getUniqueInstance());
        ListenerManager.getCurrentListenerManager().addModelListener(patternListener);
        IInterface nodeHierarchyRootInterface = this.getFactory().createInterface("NodeHierarchyRoot");
        this.addActor(nodeHierarchyRootInterface);
        IInterface visitorRootInterface = this.getFactory().createInterface("VisitorHierarchyRoot");
        this.addActor(visitorRootInterface);
        IMethod acceptMethod = this.getFactory().createMethod("accept");
        acceptMethod.addActor(this.getFactory().createParameter(0, "visitor", visitorRootInterface.getName()));
        nodeHierarchyRootInterface.addActor(acceptMethod);
        IMethod visitMethod = this.getFactory().createMethod("visit");
        visitMethod.addActor(this.getFactory().createParameter(0, "entity", nodeHierarchyRootInterface.getName()));
        visitorRootInterface.addActor(visitMethod);
        IAssociation acceptVisitorAssociation = this.getFactory().createAssociationRelationship("acceptVisitor", visitorRootInterface, 1);
        nodeHierarchyRootInterface.addActor(acceptVisitorAssociation);
        IAssociation visitEntityAssociation = this.getFactory().createAssociationRelationship("visitEntity", nodeHierarchyRootInterface, 1);
        visitorRootInterface.addActor(visitEntityAssociation);
        this.addNode("Node");
    }

    public void addNode(String nodeName) throws ModelDeclarationException {
        IClass node = this.getFactory().createClass(nodeName, (IEntity)this.getActorFromName("NodeHierarchyRoot"));
        this.addActor(node);
        IClass visitor = this.getFactory().createClass(String.valueOf(nodeName) + "Visitor", (IEntity)this.getActorFromName("VisitorHierarchyRoot"));
        this.addActor(visitor);
        IMethod acceptMethod = this.getFactory().createMethod("accept");
        acceptMethod.addActor(this.getFactory().createParameter(0, "visitor", visitor.getName()));
        node.addActor(acceptMethod);
        IMethod visitMethod = this.getFactory().createMethod("visit");
        visitMethod.addActor(this.getFactory().createParameter(0, "entity", node.getName()));
        visitor.addActor(visitMethod);
        IAssociation acceptVisitorAssociation = this.getFactory().createAssociationRelationship("acceptVisitor", visitor, 1);
        node.addActor(acceptVisitorAssociation);
        IAssociation visitEntityAssociation = this.getFactory().createAssociationRelationship("visitEntity", node, 1);
        visitor.addActor(visitEntityAssociation);
    }

    public String getIdiom() {
        return "None";
    }

    public String getIntent() {
        return "(See the GoF's book.)";
    }

    public String getName() {
        return "Visitor";
    }

    public static void main(String[] args) throws CloneNotSupportedException, ModelDeclarationException {
        ModelStatistics patternListener = new ModelStatistics();
        Visitor visitor = new Visitor(patternListener);
        JavaGenerator javaGenerator = new JavaGenerator();
        PtidejSolverAC4ConstraintGenerator ac4ConstraintGenerator = new PtidejSolverAC4ConstraintGenerator();
        PtidejSolverCustomConstraintGenerator constraintGenerator = new PtidejSolverCustomConstraintGenerator();
        PtidejSolver2AC4DomainGenerator domainGenerator = new PtidejSolver2AC4DomainGenerator();
        OutputManager.getCurrentOutputManager().getNormalOutput().println(visitor);
        OutputManager.getCurrentOutputManager().getNormalOutput().println("----");
        visitor.generate(javaGenerator);
        OutputManager.getCurrentOutputManager().getNormalOutput().println(javaGenerator.getCode());
        OutputManager.getCurrentOutputManager().getNormalOutput().println("----");
        visitor.generate(ac4ConstraintGenerator);
        OutputManager.getCurrentOutputManager().getNormalOutput().println(ac4ConstraintGenerator.getCode());
        OutputManager.getCurrentOutputManager().getNormalOutput().println("----");
        visitor.generate(constraintGenerator);
        OutputManager.getCurrentOutputManager().getNormalOutput().println(constraintGenerator.getCode());
        OutputManager.getCurrentOutputManager().getNormalOutput().println("----");
        visitor.walk(domainGenerator);
        OutputManager.getCurrentOutputManager().getNormalOutput().println(domainGenerator.getResult());
        OutputManager.getCurrentOutputManager().getNormalOutput().println("----");
    }
}

