/*
 * Decompiled with CFR 0.152.
 */
package padl.util;

import com.ibm.toad.cfparse.ClassFile;
import java.util.ArrayList;
import padl.IFileRepository;
import padl.kernel.IAbstractLevelModel;
import util.PropertyManager;
import util.io.OutputManager;
import util.io.SubtypeLoader;

public class AbstractLevelRepository {
    private static AbstractLevelRepository UniqueInstance;
    private final IAbstractLevelModel[] listOfAbstractLevels;

    public static AbstractLevelRepository getCurrentAbstractLevelRepository(IFileRepository fileRepository) {
        if (UniqueInstance == null) {
            UniqueInstance = new AbstractLevelRepository(fileRepository);
        }
        return UniqueInstance;
    }

    private AbstractLevelRepository(IFileRepository fileRepository) {
        ClassFile[] classFiles = SubtypeLoader.loadSubtypesFromStream(null, fileRepository.getFiles(), PropertyManager.getAbstractLevelsPackage(), PropertyManager.getAbstractLevelsExtension());
        ArrayList<IAbstractLevelModel> listOfAbstractLevels = new ArrayList<IAbstractLevelModel>(classFiles.length);
        int i = 0;
        while (i < classFiles.length) {
            try {
                listOfAbstractLevels.add((IAbstractLevelModel)Class.forName(classFiles[i].getName()).newInstance());
            }
            catch (ClassNotFoundException cnfe) {
                cnfe.printStackTrace(OutputManager.getCurrentOutputManager().getErrorOutput());
            }
            catch (InstantiationException ie) {
                ie.printStackTrace(OutputManager.getCurrentOutputManager().getErrorOutput());
            }
            catch (IllegalAccessException iae) {
                iae.printStackTrace(OutputManager.getCurrentOutputManager().getErrorOutput());
            }
            ++i;
        }
        this.listOfAbstractLevels = new IAbstractLevelModel[classFiles.length];
        listOfAbstractLevels.toArray(this.listOfAbstractLevels);
    }

    public IAbstractLevelModel[] listOfAbstractLevels() {
        return this.listOfAbstractLevels;
    }

    public void resetAbstractModel(int modelIndex) {
        try {
            this.listOfAbstractLevels[modelIndex] = (IAbstractLevelModel)this.listOfAbstractLevels[modelIndex].getClass().getConstructor(null).newInstance(null);
        }
        catch (Exception e) {
            e.printStackTrace(OutputManager.getCurrentOutputManager().getErrorOutput());
        }
    }

    public void resetAbstractModel(String aName) {
        int x = 0;
        while (x < this.listOfAbstractLevels.length) {
            if (this.listOfAbstractLevels[x].getName().equals(aName)) {
                this.resetAbstractModel(x);
                return;
            }
            ++x;
        }
    }

    public void resetModels() {
        int x = 0;
        while (x < this.listOfAbstractLevels.length) {
            this.resetAbstractModel(x++);
        }
    }

    public String toString() {
        StringBuffer stringEq = new StringBuffer();
        stringEq.append("AbstractLevels Repository:\n");
        int x = 0;
        while (x < this.listOfAbstractLevels.length) {
            stringEq.append('\t');
            stringEq.append(this.listOfAbstractLevels[x].getName());
            stringEq.append('\n');
            ++x;
        }
        return stringEq.toString();
    }
}

