/*
 * Decompiled with CFR 0.152.
 */
package padl.util;

import com.ibm.toad.cfparse.ClassFile;
import padl.IFileRepository;
import util.PropertyManager;
import util.io.SubtypeLoader;

public class ConstituentRepository {
    private static ConstituentRepository UniqueInstance;
    private final ClassFile[] entities;
    private final ClassFile[] elements;

    public static ConstituentRepository getCurrentConstituentRepository(IFileRepository fileRepository) {
        if (UniqueInstance == null) {
            UniqueInstance = new ConstituentRepository(fileRepository);
        }
        return UniqueInstance;
    }

    private ConstituentRepository(IFileRepository fileRepository) {
        this.entities = SubtypeLoader.loadSubtypesFromStream("padl.kernel.IEntityMarker", fileRepository.getFiles(), PropertyManager.getKernelPackage(), PropertyManager.getKernelExtension());
        this.elements = SubtypeLoader.loadSubtypesFromStream("padl.kernel.IElementMarker", fileRepository.getFiles(), PropertyManager.getKernelPackage(), PropertyManager.getKernelExtension());
    }

    public ClassFile[] getElements() {
        return this.elements;
    }

    public ClassFile[] getEntities() {
        return this.entities;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Type Repository:\n\tEntities\n");
        int x = 0;
        while (x < this.getEntities().length) {
            buffer.append("\t\t");
            buffer.append(this.getEntities()[x].getName());
            buffer.append('\n');
            ++x;
        }
        buffer.append("\tElements\n");
        x = 0;
        while (x < this.getElements().length) {
            buffer.append("\t\t");
            buffer.append(this.getElements()[x].getName());
            buffer.append('\n');
            ++x;
        }
        return buffer.toString();
    }
}

