/*
 * Decompiled with CFR 0.152.
 */
package padl.util;

import com.ibm.toad.cfparse.ClassFile;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import padl.kernel.IEntity;
import util.io.OutputManager;

public class Misc {
    public static void addTabs(int tab, StringBuffer b) {
        int i = 0;
        while (i < tab) {
            b.append("    ");
            ++i;
        }
    }

    public static void assertEquals(int[] aFirstArray, int[] aSecondArray) {
        if (aFirstArray == aSecondArray) {
            OutputManager.getCurrentOutputManager().getNormalOutput().println("Arrays are identical!");
        }
        if (aFirstArray.length != aSecondArray.length) {
            OutputManager.getCurrentOutputManager().getNormalOutput().println("Arrays have different length!");
        }
        int i = 0;
        while (i < aFirstArray.length) {
            if (aFirstArray[i] != aSecondArray[i]) {
                OutputManager.getCurrentOutputManager().getErrorOutput().print("Arrays have different values at index ");
                OutputManager.getCurrentOutputManager().getErrorOutput().print(i);
                OutputManager.getCurrentOutputManager().getErrorOutput().println('!');
            }
            ++i;
        }
    }

    public static String capitalizeFirstLetter(String name) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(name.substring(0, 1).toUpperCase());
        buffer.append(name.substring(1));
        return buffer.toString();
    }

    public static String computeSimpleName(String fullyQualifiedName) {
        int index = fullyQualifiedName.lastIndexOf(46);
        if (index == -1) {
            return fullyQualifiedName;
        }
        return fullyQualifiedName.substring(index + 1);
    }

    private static int displayDirectoryContent(int numberOfFiles, String directory, String fileExtension) {
        File file = new File(directory);
        int n = numberOfFiles;
        String[] list = file.list();
        int i = 0;
        while (i < list.length) {
            file = new File(String.valueOf(directory) + list[i]);
            if (file.isDirectory()) {
                n = Misc.displayDirectoryContent(n++, String.valueOf(file.getAbsolutePath()) + File.separatorChar, fileExtension);
            } else if (file.getName().endsWith(fileExtension)) {
                OutputManager.getCurrentOutputManager().getNormalOutput().print("file");
                OutputManager.getCurrentOutputManager().getNormalOutput().print(n++);
                OutputManager.getCurrentOutputManager().getNormalOutput().print('=');
                OutputManager.getCurrentOutputManager().getNormalOutput().println(file.getAbsoluteFile());
            }
            ++i;
        }
        return n;
    }

    public static void displayDirectoryContent(String directory, String fileExtension) {
        Misc.displayDirectoryContent(4, directory, fileExtension);
    }

    public static Method getDeclaredMethod(ClassFile classFile, String methodName) throws ClassNotFoundException {
        Class<?> classFileClass = Class.forName(classFile.getName());
        Method[] methodList = classFileClass.getMethods();
        int i = 0;
        while (i < methodList.length) {
            Method method = methodList[i];
            if (method.getName().equals(methodName)) {
                return method;
            }
            ++i;
        }
        throw new ClassNotFoundException("Cannot find method " + methodName + " in ClassFile " + classFile.getName());
    }

    public static int getNumberOfArguments(String methodSignature) {
        String args = methodSignature.substring(methodSignature.indexOf(40));
        if (args.equals("()")) {
            return 0;
        }
        int numberOfArguments = 1;
        int index = 0;
        while ((index = args.indexOf(44, index)) > -1) {
            ++index;
            ++numberOfArguments;
        }
        return numberOfArguments;
    }

    public static List getPatternProperties(Class clazz) {
        ArrayList<String> ROProperties = new ArrayList<String>();
        ArrayList<String> RWProperties = new ArrayList<String>();
        ArrayList<String> exProperties = new ArrayList<String>();
        try {
            PropertyDescriptor[] basicProperties = Introspector.getBeanInfo(clazz, null).getPropertyDescriptors();
            int x = 0;
            while (x < basicProperties.length) {
                Method writeMethod = basicProperties[x].getWriteMethod();
                Method readMethod = basicProperties[x].getReadMethod();
                if (readMethod != null) {
                    if (writeMethod != null) {
                        RWProperties.add(basicProperties[x].getName());
                    } else {
                        ROProperties.add(basicProperties[x].getName());
                    }
                }
                ++x;
            }
        }
        catch (Exception basicProperties) {
            // empty catch block
        }
        try {
            HashMap<String, Method> adds = new HashMap<String, Method>();
            HashMap<String, Method> removes = new HashMap<String, Method>();
            Method[] methods = clazz.getMethods();
            int i = 0;
            while (i < methods.length) {
                Method currentMethod = methods[i];
                int mods = currentMethod.getModifiers();
                String currentName = currentMethod.getName();
                Class<?>[] argTypes = currentMethod.getParameterTypes();
                if (!Modifier.isStatic(mods) && Modifier.isPublic(mods) && currentMethod.getReturnType() == Void.TYPE) {
                    if (currentName.startsWith("add") && argTypes.length > 0) {
                        adds.put(new String(String.valueOf(currentName.substring(3)) + ":" + argTypes[0]), currentMethod);
                    } else if (currentName.startsWith("remove") && argTypes.length == 1) {
                        removes.put(new String(String.valueOf(currentName.substring(6)) + ":" + argTypes[0]), currentMethod);
                    }
                }
                ++i;
            }
            Iterator keys = adds.keySet().iterator();
            while (keys.hasNext()) {
                String addKey = (String)keys.next();
                if (removes.get(addKey) == null) continue;
                exProperties.add(addKey.substring(0, addKey.indexOf(":")));
            }
        }
        catch (Exception e) {
            e.printStackTrace(OutputManager.getCurrentOutputManager().getErrorOutput());
        }
        ArrayList<String> props = ROProperties;
        props.addAll(RWProperties);
        props.addAll(exProperties);
        return props;
    }

    public static boolean isArray(String typeName) {
        return typeName.charAt(typeName.length() - 1) == ']';
    }

    public static boolean isArrayOrCollection(String typeName) {
        if (Misc.isArray(typeName)) {
            return true;
        }
        return Misc.isCollection(typeName);
    }

    public static boolean isArrayOrCollection(IEntity anEntity) {
        if (Misc.isArray(anEntity.getName())) {
            return true;
        }
        if (Misc.isCollection(anEntity.getName())) {
            return true;
        }
        boolean result = false;
        Iterator iterator = anEntity.listOfInheritedActors().iterator();
        while (iterator.hasNext() && !result) {
            result = Misc.isArrayOrCollection((IEntity)iterator.next());
        }
        return result;
    }

    public static boolean isCollection(String typeName) {
        return typeName.equals("java.util.Collection") || typeName.equals("java.util.AbstractList") || typeName.equals("java.util.ArrayList") || typeName.equals("java.util.LinkedList") || typeName.equals("java.util.Vector") || typeName.equals("java.util.Stack") || typeName.equals("java.util.AbstractSequentialList") || typeName.equals("java.util.List") || typeName.equals("java.util.Set") || typeName.equals("java.util.AbstractSet") || typeName.equals("java.util.HashSet") || typeName.equals("java.util.LinkedHashSet") || typeName.equals("java.util.TreeSet") || typeName.equals("java.util.SortedSet");
    }

    public static boolean isPrimtiveType(String typeName) {
        return typeName.equals("boolean") || typeName.equals("byte") || typeName.equals("char") || typeName.equals("short") || typeName.equals("double") || typeName.equals("float") || typeName.equals("int") || typeName.equals("long") || typeName.equals("boolean[]") || typeName.equals("byte[]") || typeName.equals("char[]") || typeName.equals("short[]") || typeName.equals("double[]") || typeName.equals("float[]") || typeName.equals("int[]") || typeName.equals("long[]") || typeName.equals("void") || typeName.indexOf(91) > -1;
    }

    public static boolean isSpecialMethod(String methodName) {
        return methodName.startsWith("<init>") || methodName.startsWith("<clint>");
    }

    public static boolean isAnonymousClass(String className) {
        String simpleName = Misc.computeSimpleName(className);
        try {
            Integer.parseInt(simpleName);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static String minimizeFirstLetter(String name) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(name.substring(0, 1).toLowerCase());
        buffer.append(name.substring(1));
        return buffer.toString();
    }

    public static String stripAndCapQualifiedName(String qualifiedName) {
        StringBuffer buffer = new StringBuffer();
        boolean previousCharWhitespace = false;
        int i = 0;
        while (i < qualifiedName.length()) {
            char c = qualifiedName.charAt(i);
            if (c != '.' && c != '$') {
                if (previousCharWhitespace) {
                    buffer.append(Character.toUpperCase(c));
                    previousCharWhitespace = false;
                } else {
                    buffer.append(c);
                }
            } else {
                previousCharWhitespace = true;
            }
            ++i;
        }
        return buffer.toString();
    }
}

