/*
 * Decompiled with CFR 0.152.
 */
package padl.util;

import padl.event.AnalysisEvent;
import padl.event.ElementEvent;
import padl.event.EntityEvent;
import padl.event.IListener;
import padl.event.MessageSendAbilityEvent;
import padl.event.PatternEvent;
import padl.event.RecognitionEvent;
import padl.kernel.IAggregation;
import padl.kernel.IAssociation;
import padl.kernel.IClass;
import padl.kernel.IComposition;
import padl.kernel.IContainerAggregation;
import padl.kernel.IContainerComposition;
import padl.kernel.ICreation;
import padl.kernel.IElement;
import padl.kernel.IField;
import padl.kernel.IGhost;
import padl.kernel.IInterface;
import padl.kernel.IMethod;
import padl.kernel.IUseRelationship;

public final class ModelStatistics
implements IListener {
    private int numberOfClasses;
    private int numberOfGhosts;
    private int numberOfInterfaces;
    private int numberOfAssociations;
    private int numberOfAggregationsMany;
    private int numberOfAggregationsOne;
    private int numberOfCompositions;
    private int numberOfContainerAggregationsMany;
    private int numberOfContainerAggregationsOne;
    private int numberOfContainerCompositions;
    private int numberOfCreationLinks;
    private int numberOfKnowledgeLinks;
    private int numberOfFields;
    private int numberOfMethods;
    private int numberOfMessageSends;
    private int numberOfPatternModels;

    public void elementAdded(ElementEvent elementEvent) {
        IElement pElement = elementEvent.getElement();
        if (pElement instanceof IComposition) {
            ++this.numberOfCompositions;
        } else if (pElement instanceof IContainerComposition) {
            ++this.numberOfContainerCompositions;
        } else if (pElement instanceof IAggregation) {
            if (((IAggregation)pElement).getCardinality() == 1) {
                ++this.numberOfAggregationsOne;
            } else {
                ++this.numberOfAggregationsMany;
            }
        } else if (pElement instanceof IContainerAggregation) {
            if (((IContainerAggregation)pElement).getCardinality() == 1) {
                ++this.numberOfContainerAggregationsOne;
            } else {
                ++this.numberOfContainerAggregationsMany;
            }
        } else if (pElement instanceof IAssociation) {
            ++this.numberOfAssociations;
        } else if (pElement instanceof ICreation) {
            ++this.numberOfCreationLinks;
        } else if (pElement instanceof IUseRelationship) {
            ++this.numberOfKnowledgeLinks;
        } else if (pElement instanceof IField) {
            ++this.numberOfFields;
        } else if (pElement instanceof IMethod) {
            ++this.numberOfMethods;
        }
    }

    public void elementRemoved(ElementEvent elementEvent) {
        IElement pElement = elementEvent.getElement();
        if (pElement instanceof IComposition) {
            --this.numberOfCompositions;
        } else if (pElement instanceof IContainerComposition) {
            --this.numberOfContainerCompositions;
        } else if (pElement instanceof IAggregation) {
            if (((IAggregation)pElement).getCardinality() == 1) {
                --this.numberOfAggregationsOne;
            } else {
                --this.numberOfAggregationsMany;
            }
        } else if (pElement instanceof IContainerAggregation) {
            if (((IContainerAggregation)pElement).getCardinality() == 1) {
                --this.numberOfContainerAggregationsOne;
            } else {
                --this.numberOfContainerAggregationsMany;
            }
        } else if (pElement instanceof IAssociation) {
            --this.numberOfAssociations;
        } else if (pElement instanceof ICreation) {
            --this.numberOfCreationLinks;
        } else if (pElement instanceof IUseRelationship) {
            --this.numberOfKnowledgeLinks;
        } else if (pElement instanceof IField) {
            --this.numberOfFields;
        } else if (pElement instanceof IMethod) {
            --this.numberOfMethods;
        }
    }

    public void entityAnalyzed(AnalysisEvent analysisEvent) {
    }

    public void entityAdded(EntityEvent entityEvent) {
        if (entityEvent.getEntity() instanceof IClass) {
            ++this.numberOfClasses;
        } else if (entityEvent.getEntity() instanceof IGhost) {
            ++this.numberOfGhosts;
        } else if (entityEvent.getEntity() instanceof IInterface) {
            ++this.numberOfInterfaces;
        }
    }

    public void entityRecognized(RecognitionEvent recognitionEvent) {
    }

    public void entityRemoved(EntityEvent entityEvent) {
        if (entityEvent.getEntity() instanceof IClass) {
            --this.numberOfClasses;
        } else if (entityEvent.getEntity() instanceof IGhost) {
            --this.numberOfGhosts;
        } else if (entityEvent.getEntity() instanceof IInterface) {
            --this.numberOfInterfaces;
        }
    }

    public void entitySkipped(AnalysisEvent analysisEvent) {
    }

    public void messageSendRecognized(MessageSendAbilityEvent messageSendAbilityEvent) {
        ++this.numberOfMessageSends;
    }

    public void patternAdded(PatternEvent patternEvent) {
        ++this.numberOfPatternModels;
    }

    public void patternRemoved(PatternEvent patternEvent) {
        --this.numberOfPatternModels;
    }

    public void reset() {
        this.numberOfClasses = 0;
        this.numberOfGhosts = 0;
        this.numberOfInterfaces = 0;
        this.numberOfAssociations = 0;
        this.numberOfAggregationsMany = 0;
        this.numberOfAggregationsOne = 0;
        this.numberOfCompositions = 0;
        this.numberOfContainerAggregationsMany = 0;
        this.numberOfContainerAggregationsOne = 0;
        this.numberOfContainerCompositions = 0;
        this.numberOfCreationLinks = 0;
        this.numberOfKnowledgeLinks = 0;
        this.numberOfFields = 0;
        this.numberOfMethods = 0;
        this.numberOfMessageSends = 0;
        this.numberOfPatternModels = 0;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Number of classes: ");
        buffer.append(this.numberOfClasses);
        buffer.append("\nNumber of ghosts: ");
        buffer.append(this.numberOfGhosts);
        buffer.append("\nNumber of interfaces: ");
        buffer.append(this.numberOfInterfaces);
        buffer.append("\nNumber of association relationships: ");
        buffer.append(this.numberOfAssociations);
        buffer.append("\nNumber of aggregation relationships [1,n]: ");
        buffer.append(this.numberOfAggregationsMany);
        buffer.append("\nNumber of aggregation relationships [1,1]: ");
        buffer.append(this.numberOfAggregationsOne);
        buffer.append("\nNumber of composition relationships: ");
        buffer.append(this.numberOfCompositions);
        buffer.append("\nNumber of container-aggregation relationships [1,n]: ");
        buffer.append(this.numberOfContainerAggregationsMany);
        buffer.append("\nNumber of container-aggregation relationships [1,1]: ");
        buffer.append(this.numberOfContainerAggregationsOne);
        buffer.append("\nNumber of container-composition relationships: ");
        buffer.append(this.numberOfContainerCompositions);
        buffer.append("\nNumber of creation relationships: ");
        buffer.append(this.numberOfCreationLinks);
        buffer.append("\nNumber of knowledge relationships: ");
        buffer.append(this.numberOfKnowledgeLinks);
        buffer.append("\nNumber of fields: ");
        buffer.append(this.numberOfFields);
        buffer.append("\nNumber of methods: ");
        buffer.append(this.numberOfMethods);
        buffer.append("\nNumber of message sends: ");
        buffer.append(this.numberOfMessageSends);
        buffer.append("\nNumber of pattern models: ");
        buffer.append(this.numberOfPatternModels);
        return buffer.toString();
    }
}

