/*
 * Decompiled with CFR 0.152.
 */
package padl.util;

import com.ibm.toad.cfparse.ClassFile;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import padl.IFileRepository;
import padl.kernel.IPatternModel;
import util.PropertyManager;
import util.io.OutputManager;
import util.io.SubtypeLoader;

public class PatternRepository {
    private static PatternRepository UniqueInstance;
    private IPatternModel[] listOfPatterns;

    public static PatternRepository getCurrentPatternRepository(IFileRepository fileRepository) {
        if (UniqueInstance == null) {
            UniqueInstance = new PatternRepository(fileRepository);
        }
        return UniqueInstance;
    }

    private PatternRepository(IFileRepository fileRepository) {
        ClassFile[] classFiles = SubtypeLoader.loadSubtypesFromStream(null, fileRepository.getFiles(), PropertyManager.getPatternsPackage(), PropertyManager.getPatternsExtension());
        if (classFiles.length == 0) {
            ArrayList<IPatternModel> listOfPatterns = new ArrayList<IPatternModel>(classFiles.length);
            int i = 0;
            while (i < classFiles.length) {
                try {
                    listOfPatterns.add((IPatternModel)Class.forName(classFiles[i].getName()).newInstance());
                }
                catch (ClassNotFoundException cnfe) {
                    cnfe.printStackTrace(OutputManager.getCurrentOutputManager().getErrorOutput());
                }
                catch (InstantiationException ie) {
                    ie.printStackTrace(OutputManager.getCurrentOutputManager().getErrorOutput());
                }
                catch (IllegalAccessException iae) {
                    iae.printStackTrace(OutputManager.getCurrentOutputManager().getErrorOutput());
                }
                ++i;
            }
            this.listOfPatterns = new IPatternModel[classFiles.length];
            listOfPatterns.toArray(this.listOfPatterns);
        } else {
            try {
                this.listOfPatterns = new IPatternModel[]{(IPatternModel)Class.forName("padl.pattern.repository.Composite").getConstructor(null).newInstance(null)};
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace(OutputManager.getCurrentOutputManager().getErrorOutput());
            }
            catch (InstantiationException e) {
                e.printStackTrace(OutputManager.getCurrentOutputManager().getErrorOutput());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace(OutputManager.getCurrentOutputManager().getErrorOutput());
            }
            catch (InvocationTargetException e) {
                e.printStackTrace(OutputManager.getCurrentOutputManager().getErrorOutput());
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace(OutputManager.getCurrentOutputManager().getErrorOutput());
            }
        }
    }

    public IPatternModel[] listOfPatterns() {
        return this.listOfPatterns;
    }

    public void resetAbstractModel(int modelIndex) {
        try {
            this.listOfPatterns[modelIndex] = (IPatternModel)this.listOfPatterns[modelIndex].getClass().getConstructor(null).newInstance(null);
        }
        catch (Exception e) {
            e.printStackTrace(OutputManager.getCurrentOutputManager().getErrorOutput());
        }
    }

    public void resetAbstractModel(String aName) {
        int x = 0;
        while (x < this.listOfPatterns.length) {
            if (this.listOfPatterns[x].getName().equals(aName)) {
                this.resetAbstractModel(x);
                return;
            }
            ++x;
        }
    }

    public void resetModels() {
        int x = 0;
        while (x < this.listOfPatterns.length) {
            this.resetAbstractModel(x++);
        }
    }

    public String toString() {
        StringBuffer stringEq = new StringBuffer();
        stringEq.append("Patterns Repository:\n");
        int x = 0;
        while (x < this.listOfPatterns.length) {
            stringEq.append('\t');
            stringEq.append(this.listOfPatterns[x].getName());
            stringEq.append('\n');
            ++x;
        }
        return stringEq.toString();
    }
}

