/*
 * Decompiled with CFR 0.152.
 */
package padl.visitor;

import java.lang.reflect.Modifier;
import java.util.Iterator;
import padl.kernel.IAbstractLevelModel;
import padl.kernel.IAggregation;
import padl.kernel.IAssociation;
import padl.kernel.IClass;
import padl.kernel.IComposition;
import padl.kernel.IConstituent;
import padl.kernel.IConstructor;
import padl.kernel.IContainerAggregation;
import padl.kernel.IContainerComposition;
import padl.kernel.ICreation;
import padl.kernel.IDelegatingMethod;
import padl.kernel.IEntity;
import padl.kernel.IField;
import padl.kernel.IGenerator;
import padl.kernel.IGhost;
import padl.kernel.IInterface;
import padl.kernel.IMethod;
import padl.kernel.IMethodInvocation;
import padl.kernel.IParameter;
import padl.kernel.IPatternModel;
import padl.kernel.IUseRelationship;
import padl.kernel.ModelDeclarationException;
import padl.util.Misc;

public final class JavaGenerator
implements IGenerator {
    private final StringBuffer buffer = new StringBuffer();
    private int indentation = 0;

    public void close(IAbstractLevelModel p) {
    }

    public void close(IClass p) {
        this.buffer.append('\n');
        this.buffer.append('}');
        this.buffer.append('\n');
        --this.indentation;
    }

    public void close(IGhost p) {
    }

    public void close(IInterface p) {
        this.buffer.append('\n');
        this.buffer.append('}');
        this.buffer.append('\n');
        --this.indentation;
    }

    public void close(IPatternModel p) {
    }

    private void commentsAndVisibility(IConstituent p) {
        Misc.addTabs(this.indentation, this.buffer);
        if (p.getComment() != null) {
            this.buffer.append("/* ");
            this.buffer.append(p.getComment());
            this.buffer.append(" */\n");
            Misc.addTabs(this.indentation, this.buffer);
        }
        this.buffer.append(Modifier.toString(p.getVisibility()));
    }

    public String getCode() {
        return this.buffer.toString();
    }

    public String getName() {
        return "Java";
    }

    public Object getResult() {
        return this.buffer.toString();
    }

    private void nameAndParameters(IConstructor p) {
        this.buffer.append(p.getName());
        this.buffer.append('(');
        Iterator iterator = p.listOfActors().iterator();
        while (iterator.hasNext()) {
            this.buffer.append(iterator.next().toString());
            if (!iterator.hasNext()) continue;
            this.buffer.append(", ");
        }
        this.buffer.append(')');
        if (p.isAbstract()) {
            this.buffer.append(';');
            return;
        }
        this.buffer.append(" {\n");
        String[] codeLines = p.getCodeLines();
        if (codeLines != null) {
            int i = 0;
            while (i < codeLines.length) {
                Misc.addTabs(this.indentation + 1, this.buffer);
                this.buffer.append(codeLines[i]);
                this.buffer.append('\n');
                ++i;
            }
        }
        Misc.addTabs(this.indentation, this.buffer);
        this.buffer.append('}');
    }

    public void open(IAbstractLevelModel p) {
        this.reset();
    }

    public void open(IClass p) {
        this.commentsAndVisibility(p);
        this.buffer.append(" class ");
        this.buffer.append(p.getName());
        if (p.listOfInheritedActors().size() > 0) {
            this.buffer.append(" extends ");
            this.buffer.append(((IEntity)p.listOfInheritedActors().get(0)).getName());
        }
        if (p.listOfImplementedEntities().size() > 0) {
            this.buffer.append(" implements ");
            Iterator iterator = p.listOfImplementedEntities().iterator();
            while (iterator.hasNext()) {
                this.buffer.append(((IEntity)iterator.next()).getName());
                if (!iterator.hasNext()) continue;
                this.buffer.append(", ");
            }
        }
        this.buffer.append(' ');
        this.buffer.append('{');
        this.buffer.append('\n');
        ++this.indentation;
    }

    public void open(IGhost p) {
    }

    public void open(IInterface p) {
        this.commentsAndVisibility(p);
        this.buffer.append(" interface ");
        this.buffer.append(p.getName());
        if (p.listOfInheritedActors().size() > 0) {
            this.buffer.append(" extends ");
            Iterator iterator = p.listOfInheritedActors().iterator();
            while (iterator.hasNext()) {
                this.buffer.append(((IEntity)iterator.next()).getName());
                if (!iterator.hasNext()) continue;
                this.buffer.append(", ");
            }
        }
        this.buffer.append(' ');
        this.buffer.append('{');
        this.buffer.append('\n');
        ++this.indentation;
    }

    public void open(IPatternModel p) {
        this.reset();
    }

    public void reset() {
        this.buffer.setLength(0);
        this.indentation = 0;
    }

    public void visit(IAggregation p) {
        Misc.addTabs(this.indentation, this.buffer);
        this.buffer.append("// Aggregation: ");
        this.buffer.append(p.getName());
        this.buffer.append('\n');
    }

    public void visit(IAssociation p) {
        Misc.addTabs(this.indentation, this.buffer);
        this.buffer.append("// Association: ");
        this.buffer.append(p.getName());
        this.buffer.append('\n');
    }

    public void visit(IComposition p) {
        Misc.addTabs(this.indentation, this.buffer);
        this.buffer.append("// Composition: ");
        this.buffer.append(p.getName());
        this.buffer.append('\n');
    }

    public void visit(IConstructor p) {
        this.commentsAndVisibility(p);
        this.buffer.append(' ');
        this.nameAndParameters(p);
    }

    public void visit(IContainerAggregation p) {
        Misc.addTabs(this.indentation, this.buffer);
        this.buffer.append("// Aggregation: ");
        this.buffer.append(p.getName());
        this.buffer.append('\n');
        this.visit((IField)p.getActorFromName("~ID1"));
        this.buffer.append('\n');
        this.visit((IMethod)p.getActorFromName("~ID2"));
        this.buffer.append('\n');
        this.visit((IMethod)p.getActorFromName("~ID3"));
        this.buffer.append('\n');
    }

    public void visit(IContainerComposition p) {
        this.visit((IContainerAggregation)p);
    }

    public void visit(ICreation p) {
    }

    public void visit(IDelegatingMethod p) {
        try {
            if (p.getTargetAssoc().getCardinality() > 1) {
                p.setCodeLines("for (java.util.Enumeration enum = " + p.getTargetAssoc().getName() + ".elements(); enum.hasMoreElements(); ((" + p.getTargetAssoc().getTargetActor().getName() + ") enum.nextElement())." + p.getTargetMethod().getCallDeclaration() + ");");
            } else {
                p.setCodeLines(String.valueOf(p.getTargetAssoc().getName()) + "." + p.getTargetMethod().getCallDeclaration() + ";");
            }
        }
        catch (ModelDeclarationException modelDeclarationException) {
            // empty catch block
        }
        Misc.addTabs(this.indentation, this.buffer);
        this.buffer.append("// Method linked to: ");
        this.buffer.append(p.getTargetAssoc().getName());
        this.buffer.append('\n');
        this.visit((IMethod)p);
    }

    public void visit(IField p) {
        this.commentsAndVisibility(p);
        this.buffer.append(' ');
        this.buffer.append(p.getType());
        this.buffer.append(' ');
        this.buffer.append(p.getName());
        String[] codeLines = p.getCodeLines();
        if (codeLines != null) {
            this.buffer.append(" = ");
            int i = 0;
            while (i < codeLines.length) {
                this.buffer.append('\n');
                Misc.addTabs(this.indentation + 1, this.buffer);
                this.buffer.append(codeLines[i]);
                ++i;
            }
        }
        this.buffer.append(';');
    }

    public void visit(IMethod p) {
        this.commentsAndVisibility(p);
        this.buffer.append(' ');
        this.buffer.append(p.getReturnType());
        this.buffer.append(' ');
        this.nameAndParameters(p);
    }

    public void visit(IMethodInvocation aMethodInvocation) {
    }

    public void visit(IParameter p) {
        this.buffer.append(p.getType());
        this.buffer.append(' ');
        this.buffer.append(p.getName());
    }

    public void visit(IUseRelationship p) {
    }
}

