/*
 * Decompiled with CFR 0.152.
 */
package padl.visitor;

import java.util.ArrayList;
import java.util.List;
import padl.kernel.IAbstractLevelModel;
import padl.kernel.IAbstractModel;
import padl.kernel.IAggregation;
import padl.kernel.IAssociation;
import padl.kernel.IClass;
import padl.kernel.IComposition;
import padl.kernel.IConstructor;
import padl.kernel.IContainerAggregation;
import padl.kernel.IContainerComposition;
import padl.kernel.ICreation;
import padl.kernel.IDelegatingMethod;
import padl.kernel.IEntity;
import padl.kernel.IField;
import padl.kernel.IGhost;
import padl.kernel.IInterface;
import padl.kernel.IMethod;
import padl.kernel.IMethodInvocation;
import padl.kernel.IParameter;
import padl.kernel.IPatternModel;
import padl.kernel.IUseRelationship;
import padl.kernel.IWalker;
import util.io.OutputManager;

public final class MetricsComplexityCalculator
implements IWalker {
    private final List valuesForAllModules = new ArrayList();
    private ValuesForModule valuesForCurrentModule;

    public void close(IAbstractLevelModel p) {
        this.close((IAbstractModel)p);
    }

    private void close(IAbstractModel p) {
        double S = this.computeStructuralComplexity();
        double D2 = this.computeDataComplexity();
        int i = 0;
        while (i < this.valuesForAllModules.size()) {
            OutputManager.getCurrentOutputManager().getNormalOutput().println(this.valuesForAllModules.get(i));
            ++i;
        }
        OutputManager.getCurrentOutputManager().getNormalOutput().print("C = S + D = ");
        OutputManager.getCurrentOutputManager().getNormalOutput().print(S);
        OutputManager.getCurrentOutputManager().getNormalOutput().print(" + ");
        OutputManager.getCurrentOutputManager().getNormalOutput().print(D2);
        OutputManager.getCurrentOutputManager().getNormalOutput().print(" = ");
        OutputManager.getCurrentOutputManager().getNormalOutput().println(S + D2);
        OutputManager.getCurrentOutputManager().getNormalOutput().println("----");
    }

    public void close(IClass p) {
        int hierarchyNestingLevel = this.computeDeeperHierarchyNestingLevel(p);
        this.valuesForCurrentModule.addFanout(hierarchyNestingLevel);
        this.close((IEntity)p);
    }

    private void close(IEntity pEntity) {
        this.valuesForAllModules.add(this.valuesForCurrentModule);
    }

    public void close(IGhost p) {
        this.valuesForCurrentModule.addFanout(1);
        this.close((IEntity)p);
    }

    public void close(IInterface p) {
        int hierarchyNestingLevel = this.computeDeeperHierarchyNestingLevel(p);
        this.valuesForCurrentModule.addFanout(hierarchyNestingLevel);
        this.close((IEntity)p);
    }

    public void close(IPatternModel p) {
        this.close((IAbstractModel)p);
    }

    private double computeDataComplexity() {
        int n = this.valuesForAllModules.size();
        double sum = 0.0;
        int i = 0;
        while (i < n) {
            sum += ((ValuesForModule)this.valuesForAllModules.get(i)).getDataComplexity();
            ++i;
        }
        return sum / (double)n;
    }

    private int computeDeeperHierarchyNestingLevel(IClass pClass) {
        int nestingLevel = 1;
        int i = 0;
        while (i < pClass.listOfInheritedActors().size()) {
            nestingLevel += this.computeDeeperHierarchyNestingLevel((IEntity)pClass.listOfInheritedActors().get(i));
            ++i;
        }
        i = 0;
        while (i < pClass.listOfImplementedEntities().size()) {
            nestingLevel += this.computeDeeperHierarchyNestingLevel((IEntity)pClass.listOfImplementedEntities().get(i));
            ++i;
        }
        return nestingLevel;
    }

    private int computeDeeperHierarchyNestingLevel(IEntity pEntity) {
        if (pEntity instanceof IClass) {
            return this.computeDeeperHierarchyNestingLevel((IClass)pEntity);
        }
        if (pEntity instanceof IInterface) {
            return this.computeDeeperHierarchyNestingLevel((IInterface)pEntity);
        }
        return 1;
    }

    private int computeDeeperHierarchyNestingLevel(IInterface pInterface) {
        int nestingLevel = 1;
        int i = 0;
        while (i < pInterface.listOfInheritedActors().size()) {
            nestingLevel += this.computeDeeperHierarchyNestingLevel((IInterface)pInterface.listOfInheritedActors().get(i));
            ++i;
        }
        return nestingLevel;
    }

    private double computeStructuralComplexity() {
        int n = this.valuesForAllModules.size();
        double sum = 0.0;
        int i = 0;
        while (i < n) {
            sum += ((ValuesForModule)this.valuesForAllModules.get(i)).getStructuralComplexity();
            ++i;
        }
        return sum / (double)n;
    }

    public String getName() {
        return "Complexity metric";
    }

    public Object getResult() {
        double S = this.computeStructuralComplexity();
        double D2 = this.computeDataComplexity();
        return new Double(S + D2);
    }

    public void open(IAbstractLevelModel p) {
        this.reset();
    }

    public void open(IClass p) {
        this.open((IEntity)p);
    }

    private void open(IEntity anEntity) {
        this.valuesForCurrentModule = new ValuesForModule(anEntity.getName());
    }

    public void open(IGhost p) {
        this.open((IEntity)p);
    }

    public void open(IInterface p) {
        this.open((IEntity)p);
    }

    public void open(IPatternModel p) {
        this.reset();
    }

    public void reset() {
        this.valuesForAllModules.clear();
    }

    public void visit(IAggregation p) {
    }

    public void visit(IAssociation p) {
        this.valuesForCurrentModule.addFanout(1);
    }

    public void visit(IComposition p) {
    }

    public void visit(IConstructor p) {
    }

    public void visit(IContainerAggregation p) {
    }

    public void visit(IContainerComposition p) {
    }

    public void visit(ICreation p) {
        this.valuesForCurrentModule.addFanout(1);
    }

    public void visit(IDelegatingMethod p) {
        this.valuesForCurrentModule.addFanout(1);
    }

    public void visit(IField p) {
    }

    public void visit(IMethod p) {
        if (!p.getReturnType().equals("void")) {
            this.valuesForCurrentModule.addIOVariables(1);
        }
    }

    public void visit(IMethodInvocation aMethodInvocation) {
    }

    public void visit(IParameter p) {
        this.valuesForCurrentModule.addIOVariables(1);
    }

    public void visit(IUseRelationship p) {
        this.valuesForCurrentModule.addFanout(1);
    }

    private static class ValuesForModule {
        private int fanout;
        private int ioVariables;
        private final String moduleName;

        public ValuesForModule(String moduleName) {
            this.moduleName = moduleName;
        }

        public void addFanout(int fanout) {
            this.fanout += fanout;
        }

        public void addIOVariables(int ioVariables) {
            this.ioVariables += ioVariables;
        }

        public double getDataComplexity() {
            return (double)this.ioVariables / (double)(this.fanout + 1);
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public double getStructuralComplexity() {
            return Math.pow(this.fanout, 2.0);
        }

        public void setFanout(int fanout) {
            this.fanout = fanout;
        }

        public void setIOVariables(int ioVariables) {
            this.ioVariables = ioVariables;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.moduleName);
            buffer.append(":\n\tFanout = ");
            buffer.append(this.fanout);
            buffer.append(", IO variables = ");
            buffer.append(this.ioVariables);
            buffer.append(",\n\tSt = ");
            buffer.append(this.getStructuralComplexity());
            buffer.append(", Dt = ");
            buffer.append(this.getDataComplexity());
            return buffer.toString();
        }
    }
}

