/*
 * Decompiled with CFR 0.152.
 */
package padl.visitor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import padl.kernel.IAbstractLevelModel;
import padl.kernel.IAbstractModel;
import padl.kernel.IAggregation;
import padl.kernel.IAssociation;
import padl.kernel.IClass;
import padl.kernel.IComposition;
import padl.kernel.IConstructor;
import padl.kernel.IContainerAggregation;
import padl.kernel.IContainerComposition;
import padl.kernel.ICreation;
import padl.kernel.IDelegatingMethod;
import padl.kernel.IEntity;
import padl.kernel.IField;
import padl.kernel.IGhost;
import padl.kernel.IInterface;
import padl.kernel.IMethod;
import padl.kernel.IParameter;
import padl.kernel.IPatternModel;
import padl.kernel.IUseRelationship;
import padl.kernel.IWalker;
import padl.visitor.PtidejSolverDomainGenerator;

public class PtidejSolver2AC4DomainGenerator
extends PtidejSolverDomainGenerator
implements IWalker {
    private static final boolean AGGREGATIONareCOMPOSITION = false;
    private static final boolean AGGREGATIONareCONTAINERAGGREGATION = false;
    private static final String NIL = "nil";
    private final List aggregationCouples = new ArrayList(1);
    private final List associationCouples = new ArrayList(1);
    private final StringBuffer buffer = new StringBuffer();
    private final List compositionCouples = new ArrayList(1);
    private final List containerAggregationCouples = new ArrayList(1);
    private final List containerCompositionCouples = new ArrayList(1);
    private final List creationCouples = new ArrayList(1);
    private IAbstractModel currentModel;
    private IEntity enclosingEntity;
    private final List inheritanceCouples = new ArrayList(1);
    private final List inheritancePathCouples = new ArrayList(1);
    private final List knowledgeCouples = new ArrayList(1);
    private List listOfEntities;
    private final List strictInheritanceCouples = new ArrayList(1);
    private final List strictInheritancePathCouples = new ArrayList(1);

    private void addAC4Constraint(String name, String replacement, List setOfCouples, boolean feasible, StringBuffer buffer) {
        buffer.append('[');
        buffer.append(name);
        buffer.append("(\n\tname:string,\n\tcommand:string,\n\tv1:PtidejVar,\n\tv2:PtidejVar) : PtidejAC4Constraint\n");
        buffer.append("\t->");
        buffer.append("\tmakePtidejAC4Constraint(\n\t\tname,\n\t\tcommand,\n\t\tv1,\n\t\tv2,\n\t\t");
        buffer.append(feasible);
        buffer.append(",\n\t\t");
        buffer.append(this.getCoupleDeclaration());
        Iterator iterator = setOfCouples.iterator();
        int numberOfCouples = 0;
        while (iterator.hasNext()) {
            buffer.append(iterator.next());
            ++numberOfCouples;
            if (iterator.hasNext()) {
                buffer.append(',');
            }
            if (!iterator.hasNext() || numberOfCouples % 5 != 0) continue;
            buffer.append("\n\t\t\t ");
        }
        buffer.append("),\n\t\t");
        buffer.append(name);
        buffer.append(" @ string,\n\t\t");
        buffer.append(replacement);
        if (!replacement.equals(NIL)) {
            buffer.append(" @ string");
        }
        buffer.append(")\n]\n");
    }

    private void addAC4Constraint(String name, String replacement, List setOfCouples, StringBuffer buffer) {
        this.addAC4Constraint(name, replacement, setOfCouples, true, buffer);
    }

    private void addCouple(List listOfEntities, IEntity entity1, IEntity entity2, List set) {
        String couple = this.createCouple(listOfEntities, entity1, entity2);
        if (!set.contains(couple)) {
            set.add(couple);
        }
    }

    private void addInheritanceCouple(IEntity origin, List listOfSuperEntities) {
        this.addCouple(this.listOfEntities, origin, origin, this.inheritanceCouples);
        Iterator iterator = listOfSuperEntities.iterator();
        while (iterator.hasNext()) {
            IEntity entity = (IEntity)iterator.next();
            this.addCouple(this.listOfEntities, origin, entity, this.inheritanceCouples);
            this.addCouple(this.listOfEntities, origin, entity, this.strictInheritanceCouples);
        }
    }

    private void addInheritancePathCouple(IEntity origin, List listOfSuperEntities) {
        this.addCouple(this.listOfEntities, origin, origin, this.inheritancePathCouples);
        Iterator iterator = listOfSuperEntities.iterator();
        while (iterator.hasNext()) {
            IEntity superEntity = (IEntity)iterator.next();
            this.addCouple(this.listOfEntities, origin, superEntity, this.inheritancePathCouples);
            this.addCouple(this.listOfEntities, origin, superEntity, this.strictInheritancePathCouples);
            this.addInheritancePathCouple(origin, superEntity.listOfInheritedActors());
            if (!(superEntity instanceof IClass)) continue;
            this.addInheritancePathCouple(origin, ((IClass)superEntity).listOfImplementedEntities());
        }
    }

    public void close(IAbstractLevelModel p) {
        this.close((IAbstractModel)p);
    }

    private void close(IAbstractModel p) {
        int i = 0;
        while (i < this.listOfEntities.size()) {
            String name = ((IEntity)this.listOfEntities.get(i)).getName();
            String claireIdentifier = PtidejSolverDomainGenerator.convertToClaireIdentifier(name);
            this.buffer.append(claireIdentifier);
            this.buffer.append(":Entity := Entity(name = \"");
            this.buffer.append(name);
            this.buffer.append("\")\n");
            ++i;
        }
        this.buffer.append("\nlistOfEntities: ");
        this.buffer.append(this.getListDeclaration());
        this.buffer.append(" := ");
        this.buffer.append(this.getListPrefix());
        this.buffer.append("\n\t");
        Iterator iterator = p.listOfActors().iterator();
        while (iterator.hasNext()) {
            this.buffer.append(PtidejSolverDomainGenerator.convertToClaireIdentifier(((IEntity)iterator.next()).getName()));
            if (!iterator.hasNext()) continue;
            this.buffer.append(",\n\t");
        }
        this.buffer.append(this.getListSuffix());
        this.buffer.append("\n\n");
        ArrayList<String> awarenessCouples = new ArrayList<String>(1);
        iterator = this.listOfEntities.iterator();
        while (iterator.hasNext()) {
            IEntity entity1 = (IEntity)iterator.next();
            Iterator i2 = this.listOfEntities.iterator();
            while (i2.hasNext()) {
                IEntity entity2 = (IEntity)i2.next();
                String couple = this.createCouple(this.listOfEntities, entity1, entity2);
                if (!this.aggregationCouples.contains(couple) && !this.associationCouples.contains(couple) && !this.compositionCouples.contains(couple) && !this.containerAggregationCouples.contains(couple) && !this.containerCompositionCouples.contains(couple) && !this.creationCouples.contains(couple) && !this.knowledgeCouples.contains(couple)) continue;
                awarenessCouples.add(couple);
            }
        }
        this.addAC4Constraint("makeKnowledgeAC4Constraint", NIL, this.knowledgeCouples, this.buffer);
        this.addAC4Constraint("makeAssociationAC4Constraint", "makeKnowledgeAC4Constraint", this.associationCouples, this.buffer);
        this.addAC4Constraint("makeAggregationAC4Constraint", "makeAssociationAC4Constraint", this.aggregationCouples, this.buffer);
        this.addAC4Constraint("makeCompositionAC4Constraint", "makeAggregationAC4Constraint", this.compositionCouples, this.buffer);
        this.addAC4Constraint("makeContainerAggregationAC4Constraint", "makeAssociationAC4Constraint", this.containerAggregationCouples, this.buffer);
        this.addAC4Constraint("makeContainerCompositionAC4Constraint", "makeContainerAggregationAC4Constraint", this.containerCompositionCouples, this.buffer);
        this.addAC4Constraint("makeCreationAC4Constraint", NIL, this.creationCouples, this.buffer);
        this.addAC4Constraint("makeInheritanceAC4Constraint", NIL, this.inheritanceCouples, this.buffer);
        this.addAC4Constraint("makeInheritancePathAC4Constraint", NIL, this.inheritancePathCouples, this.buffer);
        this.addAC4Constraint("makeStrictInheritanceAC4Constraint", NIL, this.strictInheritanceCouples, this.buffer);
        this.addAC4Constraint("makeStrictInheritancePathAC4Constraint", NIL, this.strictInheritancePathCouples, this.buffer);
        this.addAC4Constraint("makeAwarenessAC4Constraint", NIL, awarenessCouples, this.buffer);
        this.addAC4Constraint("makeIgnoranceAC4Constraint", NIL, awarenessCouples, false, this.buffer);
    }

    public void close(IClass p) {
    }

    public void close(IGhost p) {
    }

    public void close(IInterface p) {
    }

    public void close(IPatternModel p) {
        this.close((IAbstractModel)p);
    }

    private String createCouple(List listOfEntities, IEntity entity1, IEntity entity2) {
        StringBuffer b = new StringBuffer(13);
        b.append(this.getCouplePrefix());
        b.append(listOfEntities.indexOf(entity1) + 1);
        b.append(',');
        b.append(listOfEntities.indexOf(entity2) + 1);
        b.append(')');
        return b.toString();
    }

    protected String getCoupleDeclaration() {
        return "list(";
    }

    protected String getCouplePrefix() {
        return "list(";
    }

    protected String getListDeclaration() {
        return "Entity[]";
    }

    protected String getListPrefix() {
        return "array!(list(";
    }

    protected String getListSuffix() {
        return "), Entity)";
    }

    public String getName() {
        return "PtidejSolver 2 AC4 domain";
    }

    public Object getResult() {
        return this.buffer.toString();
    }

    public void open(IAbstractLevelModel p) {
        this.open((IAbstractModel)p);
    }

    private void open(IAbstractModel p) {
        this.reset();
        this.currentModel = p;
        this.listOfEntities = p.listOfActors();
    }

    public void open(IClass p) {
        this.enclosingEntity = p;
        this.addInheritanceCouple(p, p.listOfInheritedActors());
        this.addInheritancePathCouple(p, p.listOfInheritedActors());
        this.addInheritanceCouple(p, p.listOfImplementedEntities());
        this.addInheritancePathCouple(p, p.listOfImplementedEntities());
    }

    public void open(IGhost p) {
        this.enclosingEntity = p;
        this.addInheritanceCouple(p, p.listOfInheritedActors());
        this.addInheritancePathCouple(p, p.listOfInheritedActors());
    }

    public void open(IInterface p) {
        this.enclosingEntity = p;
        this.addInheritanceCouple(p, p.listOfInheritedActors());
        this.addInheritancePathCouple(p, p.listOfInheritedActors());
    }

    public void open(IPatternModel p) {
        this.open((IAbstractModel)p);
    }

    public void reset() {
        this.buffer.setLength(0);
        this.knowledgeCouples.clear();
        this.associationCouples.clear();
        this.aggregationCouples.clear();
        this.compositionCouples.clear();
        this.containerAggregationCouples.clear();
        this.containerCompositionCouples.clear();
        this.creationCouples.clear();
        this.inheritanceCouples.clear();
        this.inheritancePathCouples.clear();
        this.strictInheritanceCouples.clear();
        this.strictInheritancePathCouples.clear();
    }

    public void visit(IAggregation p) {
        this.addCouple(this.listOfEntities, this.enclosingEntity, p.getTargetActor(), this.aggregationCouples);
    }

    public void visit(IAssociation p) {
        this.addCouple(this.listOfEntities, this.enclosingEntity, p.getTargetActor(), this.associationCouples);
    }

    public void visit(IComposition p) {
        this.addCouple(this.listOfEntities, this.enclosingEntity, p.getTargetActor(), this.compositionCouples);
    }

    public void visit(IConstructor p) {
    }

    public void visit(IContainerAggregation p) {
        this.addCouple(this.listOfEntities, this.enclosingEntity, p.getTargetActor(), this.containerAggregationCouples);
    }

    public void visit(IContainerComposition p) {
        this.addCouple(this.listOfEntities, this.enclosingEntity, p.getTargetActor(), this.compositionCouples);
        this.addCouple(this.listOfEntities, this.enclosingEntity, p.getTargetActor(), this.containerCompositionCouples);
    }

    public void visit(ICreation p) {
        this.addCouple(this.listOfEntities, this.enclosingEntity, p.getTargetActor(), this.creationCouples);
    }

    public void visit(IDelegatingMethod p) {
        this.visit((IMethod)p);
    }

    public void visit(IField p) {
        IEntity target = (IEntity)this.currentModel.getActorFromName(p.getType());
        if (target != null) {
            this.addCouple(this.listOfEntities, this.enclosingEntity, target, this.associationCouples);
        }
    }

    public void visit(IMethod p) {
        IEntity target = (IEntity)this.currentModel.getActorFromName(p.getReturnType());
        if (target != null) {
            this.addCouple(this.listOfEntities, this.enclosingEntity, target, this.associationCouples);
        }
    }

    public void visit(IParameter p) {
        IEntity target = (IEntity)this.currentModel.getActorFromName(p.getType());
        if (target != null) {
            this.addCouple(this.listOfEntities, this.enclosingEntity, target, this.associationCouples);
        }
    }

    public void visit(IUseRelationship p) {
        this.addCouple(this.listOfEntities, this.enclosingEntity, p.getTargetActor(), this.knowledgeCouples);
    }
}

