/*
 * Decompiled with CFR 0.152.
 */
package padl.visitor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import padl.kernel.IAbstractLevelModel;
import padl.kernel.IAbstractModel;
import padl.kernel.IAggregation;
import padl.kernel.IAssociation;
import padl.kernel.IClass;
import padl.kernel.IComposition;
import padl.kernel.IConstructor;
import padl.kernel.IContainerAggregation;
import padl.kernel.IContainerComposition;
import padl.kernel.ICreation;
import padl.kernel.IDelegatingMethod;
import padl.kernel.IEntity;
import padl.kernel.IField;
import padl.kernel.IGhost;
import padl.kernel.IInterface;
import padl.kernel.IMethod;
import padl.kernel.IParameter;
import padl.kernel.IPatternModel;
import padl.kernel.IUseRelationship;
import padl.kernel.IWalker;
import padl.visitor.PtidejSolverDomainGenerator;

public class PtidejSolver2CustomDomainGenerator
extends PtidejSolverDomainGenerator
implements IWalker {
    private StringBuffer buffer = new StringBuffer(0);
    private List listOfAggregations = new ArrayList(0);
    private List listOfAssociations = new ArrayList(0);
    private List listOfCompositions = new ArrayList(0);
    private List listOfContainerAggregations = new ArrayList(0);
    private List listOfContainerCompositions = new ArrayList(0);
    private List listOfCreations = new ArrayList(0);
    private List listOfKnowledges = new ArrayList(0);
    private IEntity[] pEntities;

    private boolean belongsToDomain(String name) {
        int i = 0;
        while (i < this.pEntities.length) {
            if (this.pEntities[i].getName().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void close(IAbstractLevelModel p) {
        this.close((IAbstractModel)p);
    }

    private void close(IAbstractModel p) {
        this.buffer.append("\nlistOfEntities: ");
        this.buffer.append(this.getListDeclaration());
        this.buffer.append(" := ");
        this.buffer.append(this.getListPrefix());
        Iterator iterator = p.listOfActors().iterator();
        while (iterator.hasNext()) {
            this.buffer.append(PtidejSolverDomainGenerator.convertToClaireIdentifier(((IEntity)iterator.next()).getName()));
            if (!iterator.hasNext()) continue;
            this.buffer.append(", ");
        }
        this.buffer.append(this.getListSuffix());
        this.buffer.append("");
    }

    public void close(IClass p) {
        ArrayList superEntities = new ArrayList(p.listOfInheritedActors());
        Iterator iterator = p.listOfImplementedEntities().iterator();
        while (iterator.hasNext()) {
            superEntities.add(iterator.next());
        }
        this.close(p.getName(), superEntities);
    }

    public void close(IGhost p) {
        this.close(p.getName(), p.listOfInheritedActors());
    }

    public void close(IInterface p) {
        this.close(p.getName(), p.listOfInheritedActors());
    }

    public void close(IPatternModel p) {
        this.close((IAbstractModel)p);
    }

    private void close(String name, List listInherits) {
        String entityName;
        String claireIdentifier = PtidejSolverDomainGenerator.convertToClaireIdentifier(name);
        this.buffer.insert(0, String.valueOf(claireIdentifier) + ":Entity := Entity(name = \"" + name + "\")\n");
        this.buffer.append('\n');
        this.buffer.append('(');
        this.buffer.append(claireIdentifier);
        this.buffer.append(".superEntities := ");
        this.buffer.append(this.getListPrefix());
        Iterator iterator = listInherits.iterator();
        while (iterator.hasNext()) {
            this.buffer.append(PtidejSolverDomainGenerator.convertToClaireIdentifier(((IEntity)iterator.next()).getName()));
            if (!iterator.hasNext()) continue;
            this.buffer.append(", ");
        }
        this.buffer.append(this.getListSuffix());
        this.buffer.append(",\n ");
        StringBuffer temporaryBuffer = new StringBuffer();
        iterator = this.listOfAggregations.iterator();
        while (iterator.hasNext()) {
            temporaryBuffer.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            temporaryBuffer.append(", ");
        }
        this.buffer.append(claireIdentifier);
        this.buffer.append(".aggregatedEntities := ");
        this.buffer.append(this.getListPrefix());
        this.buffer.append(temporaryBuffer.toString());
        this.buffer.append(this.getListSuffix());
        this.buffer.append(",\n ");
        temporaryBuffer.setLength(0);
        iterator = this.listOfAssociations.iterator();
        while (iterator.hasNext()) {
            temporaryBuffer.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            temporaryBuffer.append(", ");
        }
        this.buffer.append(claireIdentifier);
        this.buffer.append(".associatedEntities := ");
        this.buffer.append(this.getListPrefix());
        this.buffer.append(temporaryBuffer.toString());
        this.buffer.append(this.getListSuffix());
        this.buffer.append(",\n ");
        this.buffer.append(claireIdentifier);
        this.buffer.append(".componentsType := ");
        this.buffer.append(this.getListPrefix());
        temporaryBuffer.setLength(0);
        iterator = this.listOfCompositions.iterator();
        while (iterator.hasNext()) {
            String pEntityName = (String)iterator.next();
            this.buffer.append(pEntityName);
            temporaryBuffer.append(this.getListPrefix());
            temporaryBuffer.append(pEntityName);
            temporaryBuffer.append(this.getListSuffix());
            if (!iterator.hasNext()) continue;
            this.buffer.append(", ");
            temporaryBuffer.append(", ");
        }
        this.buffer.append(this.getListSuffix());
        this.buffer.append(",\n ");
        this.buffer.append(claireIdentifier);
        this.buffer.append(".composedEntities := ");
        this.buffer.append(this.getListOfListPrefix());
        this.buffer.append(temporaryBuffer.toString());
        this.buffer.append(this.getListOfListSuffix());
        this.buffer.append(",\n ");
        temporaryBuffer.setLength(0);
        iterator = this.listOfContainerAggregations.iterator();
        while (iterator.hasNext()) {
            temporaryBuffer.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            temporaryBuffer.append(", ");
        }
        this.buffer.append(claireIdentifier);
        this.buffer.append(".containerAggregatedEntities := ");
        this.buffer.append(this.getListPrefix());
        this.buffer.append(temporaryBuffer.toString());
        this.buffer.append(this.getListSuffix());
        this.buffer.append(",\n ");
        temporaryBuffer.setLength(0);
        iterator = this.listOfContainerCompositions.iterator();
        while (iterator.hasNext()) {
            temporaryBuffer.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            temporaryBuffer.append(", ");
        }
        this.buffer.append(claireIdentifier);
        this.buffer.append(".containerComposedEntities := ");
        this.buffer.append(this.getListPrefix());
        this.buffer.append(temporaryBuffer.toString());
        this.buffer.append(this.getListSuffix());
        this.buffer.append(",\n ");
        temporaryBuffer.setLength(0);
        iterator = this.listOfKnowledges.iterator();
        while (iterator.hasNext()) {
            temporaryBuffer.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            temporaryBuffer.append(", ");
        }
        this.buffer.append(claireIdentifier);
        this.buffer.append(".knownEntities := ");
        this.buffer.append(this.getListPrefix());
        this.buffer.append(temporaryBuffer.toString());
        this.buffer.append(this.getListSuffix());
        this.buffer.append(",\n ");
        temporaryBuffer.setLength(0);
        iterator = this.listOfCreations.iterator();
        while (iterator.hasNext()) {
            temporaryBuffer.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            temporaryBuffer.append(", ");
        }
        this.buffer.append(claireIdentifier);
        this.buffer.append(".createdEntities := ");
        this.buffer.append(this.getListPrefix());
        this.buffer.append(temporaryBuffer.toString());
        this.buffer.append(this.getListSuffix());
        this.buffer.append(",\n ");
        temporaryBuffer.setLength(0);
        boolean firstDone = false;
        int i = 0;
        while (i < this.pEntities.length && !firstDone) {
            entityName = PtidejSolverDomainGenerator.convertToClaireIdentifier(this.pEntities[i].getName());
            if (!(entityName.equals(claireIdentifier) || this.listOfAggregations.contains(entityName) || this.listOfAssociations.contains(entityName) || this.listOfCompositions.contains(entityName) || this.listOfContainerAggregations.contains(entityName) || this.listOfContainerCompositions.contains(entityName) || this.listOfCreations.contains(entityName) || this.listOfKnowledges.contains(entityName))) {
                temporaryBuffer.append(entityName);
                firstDone = true;
            }
            ++i;
        }
        while (i < this.pEntities.length) {
            entityName = PtidejSolverDomainGenerator.convertToClaireIdentifier(this.pEntities[i].getName());
            if (!(entityName.equals(claireIdentifier) || this.listOfAggregations.contains(entityName) || this.listOfAssociations.contains(entityName) || this.listOfCompositions.contains(entityName) || this.listOfContainerAggregations.contains(entityName) || this.listOfContainerCompositions.contains(entityName) || this.listOfCreations.contains(entityName) || this.listOfKnowledges.contains(entityName))) {
                temporaryBuffer.append(", ");
                temporaryBuffer.append(entityName);
            }
            ++i;
        }
        this.buffer.append(claireIdentifier);
        this.buffer.append(".unknownEntities := ");
        this.buffer.append(this.getListPrefix());
        this.buffer.append(temporaryBuffer.toString());
        this.buffer.append(this.getListSuffix());
        this.buffer.append(")\n");
        this.listOfAggregations.clear();
        this.listOfAssociations.clear();
        this.listOfCompositions.clear();
        this.listOfContainerAggregations.clear();
        this.listOfContainerCompositions.clear();
        this.listOfCreations.clear();
        this.listOfKnowledges.clear();
    }

    protected String getListDeclaration() {
        return "Entity[]";
    }

    protected String getListOfListPrefix() {
        return "array!(list(";
    }

    protected String getListOfListSuffix() {
        return "), Entity[])";
    }

    protected String getListPrefix() {
        return "array!(list(";
    }

    protected String getListSuffix() {
        return "), Entity)";
    }

    public String getName() {
        return "PtidejSolver 2 custom domain";
    }

    public Object getResult() {
        return this.buffer.toString();
    }

    public void open(IAbstractLevelModel p) {
        this.open((IAbstractModel)p);
    }

    private void open(IAbstractModel p) {
        this.reset();
        this.pEntities = new IEntity[p.listOfActors().size()];
        p.listOfActors().toArray(this.pEntities);
    }

    public void open(IClass p) {
    }

    public void open(IGhost p) {
    }

    public void open(IInterface p) {
    }

    public void open(IPatternModel p) {
        this.open((IAbstractModel)p);
    }

    public void reset() {
        this.buffer.setLength(0);
    }

    public void visit(IAggregation p) {
        String pEntityName = PtidejSolverDomainGenerator.convertToClaireIdentifier(p.getTargetActor().getName());
        if (!this.listOfAggregations.contains(pEntityName)) {
            this.listOfAggregations.add(pEntityName);
        }
    }

    public void visit(IAssociation p) {
        String pEntityName = PtidejSolverDomainGenerator.convertToClaireIdentifier(p.getTargetActor().getName());
        if (!this.listOfAssociations.contains(pEntityName)) {
            this.listOfAssociations.add(pEntityName);
        }
    }

    public void visit(IComposition p) {
        String pEntityName = PtidejSolverDomainGenerator.convertToClaireIdentifier(p.getTargetActor().getName());
        if (!this.listOfCompositions.contains(pEntityName)) {
            this.listOfCompositions.add(pEntityName);
        }
    }

    public void visit(IConstructor p) {
    }

    public void visit(IContainerAggregation p) {
        String pEntityName = PtidejSolverDomainGenerator.convertToClaireIdentifier(p.getTargetActor().getName());
        if (!this.listOfContainerAggregations.contains(pEntityName)) {
            this.listOfContainerAggregations.add(pEntityName);
        }
    }

    public void visit(IContainerComposition p) {
        String pEntityName = PtidejSolverDomainGenerator.convertToClaireIdentifier(p.getTargetActor().getName());
        if (!this.listOfContainerCompositions.contains(pEntityName)) {
            this.listOfContainerCompositions.add(pEntityName);
        }
    }

    public void visit(ICreation p) {
        String pEntityName = PtidejSolverDomainGenerator.convertToClaireIdentifier(p.getTargetActor().getName());
        if (!this.listOfCreations.contains(pEntityName)) {
            this.listOfCreations.add(pEntityName);
        }
    }

    public void visit(IDelegatingMethod p) {
        String pEntityName;
        if (this.belongsToDomain(p.getReturnType()) && !this.listOfAssociations.contains(pEntityName = PtidejSolverDomainGenerator.convertToClaireIdentifier(p.getReturnType()))) {
            this.listOfAssociations.add(pEntityName);
        }
    }

    public void visit(IField p) {
        String pEntityName;
        if (this.belongsToDomain(p.getType()) && !this.listOfAssociations.contains(pEntityName = PtidejSolverDomainGenerator.convertToClaireIdentifier(p.getType()))) {
            this.listOfAssociations.add(pEntityName);
        }
    }

    public void visit(IMethod p) {
        String pEntityName;
        if (this.belongsToDomain(p.getReturnType()) && !this.listOfAssociations.contains(pEntityName = PtidejSolverDomainGenerator.convertToClaireIdentifier(p.getReturnType()))) {
            this.listOfAssociations.add(pEntityName);
        }
    }

    public void visit(IParameter p) {
        String pEntityName;
        if (this.belongsToDomain(p.getType()) && !this.listOfAssociations.contains(pEntityName = PtidejSolverDomainGenerator.convertToClaireIdentifier(p.getType()))) {
            this.listOfAssociations.add(pEntityName);
        }
    }

    public void visit(IUseRelationship p) {
        String pEntityName = PtidejSolverDomainGenerator.convertToClaireIdentifier(p.getTargetActor().getName());
        if (!this.listOfKnowledges.contains(pEntityName)) {
            this.listOfKnowledges.add(pEntityName);
        }
    }
}

