/*
 * Decompiled with CFR 0.152.
 */
package padl.visitor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import padl.kernel.IAbstractLevelModel;
import padl.kernel.IAbstractModel;
import padl.kernel.IAggregation;
import padl.kernel.IAssociation;
import padl.kernel.IClass;
import padl.kernel.IComposition;
import padl.kernel.IConstructor;
import padl.kernel.IContainerAggregation;
import padl.kernel.IContainerComposition;
import padl.kernel.ICreation;
import padl.kernel.IDelegatingMethod;
import padl.kernel.IElement;
import padl.kernel.IEntity;
import padl.kernel.IField;
import padl.kernel.IGhost;
import padl.kernel.IInterface;
import padl.kernel.IMethod;
import padl.kernel.IMethodInvocation;
import padl.kernel.IParameter;
import padl.kernel.IPatternModel;
import padl.kernel.IRelationship;
import padl.kernel.IUseRelationship;
import padl.util.Misc;
import padl.visitor.PtidejSolverDomainGenerator;

public abstract class PtidejSolverConstraintGenerator {
    private List aggregationTargets = new ArrayList();
    private StringBuffer buffer = new StringBuffer();
    private IAbstractModel currentModel;
    private IEntity enclosingEntity;
    private Map knowledgeLinks = new HashMap();
    private int numberOfEntities;
    private IEntity[] pEntities;

    private String buildRuntimeExceptionXCommand(String logo, IEntity targetEntity) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("throw new RuntimeException(\\\"");
        buffer.append(this.enclosingEntity.getName());
        buffer.append(" should ");
        buffer.append(logo);
        buffer.append(' ');
        buffer.append(targetEntity.getName());
        buffer.append("\\\");");
        return buffer.toString();
    }

    public final void close(IAbstractLevelModel p) {
        this.close((IAbstractModel)p);
    }

    private final void close(IAbstractModel p) {
        this.inheritances();
        this.ignorances();
        this.inequalities();
        this.buffer.append("            pb\n");
        this.buffer.append("        )\n");
        this.buffer.append("]\n");
    }

    public final void close(IClass p) {
        ArrayList listOfSuperEntities = new ArrayList(p.listOfInheritedActors());
        listOfSuperEntities.addAll(p.listOfImplementedEntities());
        this.close((IEntity)p);
    }

    private void close(IEntity p) {
        this.enclosingEntity = null;
    }

    public final void close(IGhost p) {
        this.close((IEntity)p);
    }

    public final void close(IInterface p) {
        this.close((IEntity)p);
    }

    public final void close(IPatternModel p) {
        this.close((IAbstractModel)p);
    }

    private void createConstraint(IElement relation, IEntity target, String constraintName, String relationshipLogo, String xCommand, int weight) {
        StringBuffer constraint = new StringBuffer();
        constraint.append("            post(pb,\n");
        constraint.append("                 make");
        constraint.append(constraintName);
        constraint.append(this.getSuffix());
        constraint.append("Constraint(\n");
        constraint.append("                    \"");
        constraint.append(this.enclosingEntity.getActorID());
        constraint.append(' ');
        constraint.append(relationshipLogo);
        constraint.append(' ');
        constraint.append(target.getActorID());
        constraint.append("\",\n");
        constraint.append("                    \"");
        constraint.append(xCommand);
        constraint.append("\",\n");
        constraint.append("                    ");
        constraint.append(Misc.minimizeFirstLetter(this.enclosingEntity.getActorID()));
        constraint.append("Var,\n");
        constraint.append("                    ");
        constraint.append(Misc.minimizeFirstLetter(target.getActorID()));
        constraint.append("Var),\n");
        constraint.append("                 ");
        constraint.append(weight);
        constraint.append("),\n");
        String constraintString = constraint.toString();
        if (this.buffer.toString().indexOf(constraintString) == -1) {
            this.buffer.append(constraintString);
        }
        if (this.knowledgeLinks.containsKey(this.enclosingEntity.getActorID())) {
            ((List)this.knowledgeLinks.get(this.enclosingEntity.getActorID())).add(target.getActorID());
        } else {
            ArrayList<String> list = new ArrayList<String>();
            list.add(target.getActorID());
            this.knowledgeLinks.put(this.enclosingEntity.getActorID(), list);
        }
    }

    private void elementWithTarget(IRelationship relation, String constraintName, String relationshipLogo, String xCommand, int weight) {
        this.createConstraint(relation, relation.getTargetActor(), constraintName, relationshipLogo, xCommand, weight);
    }

    public final String getCode() {
        return this.buffer.toString();
    }

    protected abstract String getPrefix();

    protected abstract String getSuffix();

    private void ignorances() {
        ArrayList<String> unknownEntities = new ArrayList<String>();
        int i = 0;
        while (i < this.numberOfEntities) {
            int j;
            unknownEntities.clear();
            String keyEntity = this.pEntities[i].getActorID();
            if (this.knowledgeLinks.containsKey(keyEntity)) {
                List knownEntities = (List)this.knowledgeLinks.get(keyEntity);
                int j2 = 0;
                while (j2 < this.numberOfEntities) {
                    String pEntity = this.pEntities[j2].getActorID();
                    if (!knownEntities.contains(pEntity) && !keyEntity.equals(pEntity)) {
                        unknownEntities.add(pEntity);
                    }
                    ++j2;
                }
            } else {
                j = 0;
                while (j < this.numberOfEntities) {
                    String pEntity = this.pEntities[j].getActorID();
                    if (!keyEntity.equals(pEntity)) {
                        unknownEntities.add(this.pEntities[j].getActorID());
                    }
                    ++j;
                }
            }
            j = 0;
            while (j < unknownEntities.size()) {
                this.buffer.append("            post(pb,\n");
                this.buffer.append("                 makeIgnorance");
                this.buffer.append(this.getSuffix());
                this.buffer.append("Constraint(\n");
                this.buffer.append("                    \"");
                this.buffer.append(keyEntity);
                this.buffer.append(" -/--> ");
                this.buffer.append(unknownEntities.get(j));
                this.buffer.append("\",\n");
                this.buffer.append("                    \"throw new RuntimeException(\\\"");
                this.buffer.append(keyEntity);
                this.buffer.append(" -/--> ");
                this.buffer.append(unknownEntities.get(j));
                this.buffer.append("\\\");\",\n");
                this.buffer.append("                    ");
                this.buffer.append(Misc.minimizeFirstLetter(keyEntity));
                this.buffer.append("Var,\n");
                this.buffer.append("                    ");
                this.buffer.append(Misc.minimizeFirstLetter((String)unknownEntities.get(j)));
                this.buffer.append("Var),\n");
                this.buffer.append("                 ");
                this.buffer.append(75);
                this.buffer.append("),\n");
                ++j;
            }
            ++i;
        }
    }

    private void inequalities() {
        int i = 0;
        while (i < this.numberOfEntities) {
            int j = i;
            while (j < this.numberOfEntities) {
                if (i != j) {
                    this.buffer.append("            post(pb,\n");
                    this.buffer.append("                 makeNotEqual");
                    this.buffer.append("Constraint(\n");
                    this.buffer.append("                    \"");
                    this.buffer.append(this.pEntities[i].getActorID());
                    this.buffer.append(" <> ");
                    this.buffer.append(this.pEntities[j].getActorID());
                    this.buffer.append("\",\n");
                    this.buffer.append("                    \"throw new RuntimeException(\\\"");
                    this.buffer.append(this.pEntities[i].getActorID());
                    this.buffer.append(" <> ");
                    this.buffer.append(this.pEntities[j].getActorID());
                    this.buffer.append("\\\");\",\n");
                    this.buffer.append("                    ");
                    this.buffer.append(Misc.minimizeFirstLetter(this.pEntities[i].getActorID()));
                    this.buffer.append("Var,\n");
                    this.buffer.append("                    ");
                    this.buffer.append(Misc.minimizeFirstLetter(this.pEntities[j].getActorID()));
                    this.buffer.append("Var),\n");
                    this.buffer.append("                 ");
                    this.buffer.append(100);
                    this.buffer.append("),\n");
                }
                ++j;
            }
            ++i;
        }
    }

    private void inheritances() {
        int i = 0;
        while (i < this.numberOfEntities) {
            Iterator iterator;
            if (this.pEntities[i] instanceof IClass) {
                ArrayList listOfSuperEntities = new ArrayList(this.pEntities[i].listOfInheritedActors());
                listOfSuperEntities.addAll(((IClass)this.pEntities[i]).listOfImplementedEntities());
                iterator = listOfSuperEntities.iterator();
            } else {
                iterator = this.pEntities[i] instanceof IInterface ? this.pEntities[i].listOfInheritedActors().iterator() : PtidejSolverDomainGenerator.EMPTY_ITERATOR;
            }
            while (iterator.hasNext()) {
                String superEntity = ((IEntity)iterator.next()).getActorID();
                if (this.aggregationTargets.contains(superEntity)) {
                    this.buffer.append("            post(pb,\n");
                    this.buffer.append("                 makeInheritancePath");
                    this.buffer.append(this.getSuffix());
                    this.buffer.append("Constraint(\n");
                    this.buffer.append("                    \"");
                    this.buffer.append(this.pEntities[i].getActorID());
                    this.buffer.append(" -|>- ... -|>- ");
                    this.buffer.append(superEntity);
                    this.buffer.append("\",\n");
                    this.buffer.append("                    \"");
                    this.buffer.append(this.pEntities[i].getActorID());
                    this.buffer.append(", ");
                    this.buffer.append(superEntity);
                    this.buffer.append(" | javaXL.XClass c1, javaXL.XClass c2 | c1.setSuperclass(c2.getName());\",\n");
                    this.buffer.append("                    ");
                    this.buffer.append(Misc.minimizeFirstLetter(this.pEntities[i].getActorID()));
                    this.buffer.append("Var,\n");
                    this.buffer.append("                    ");
                    this.buffer.append(Misc.minimizeFirstLetter(superEntity));
                    this.buffer.append("Var),\n");
                    this.buffer.append("                 ");
                    this.buffer.append(50);
                    this.buffer.append("),\n");
                    continue;
                }
                this.buffer.append("            post(pb,\n");
                this.buffer.append("                 makeStrictInheritance");
                this.buffer.append(this.getSuffix());
                this.buffer.append("Constraint(\n");
                this.buffer.append("                    \"");
                this.buffer.append(this.pEntities[i].getActorID());
                this.buffer.append(" -|>- ");
                this.buffer.append(superEntity);
                this.buffer.append("\",\n");
                this.buffer.append("                    \"");
                this.buffer.append(this.pEntities[i].getActorID());
                this.buffer.append(", ");
                this.buffer.append(superEntity);
                this.buffer.append(" | javaXL.XClass c1, javaXL.XClass c2 | c1.setSuperclass(c2.getName());\",\n");
                this.buffer.append("                    ");
                this.buffer.append(Misc.minimizeFirstLetter(this.pEntities[i].getActorID()));
                this.buffer.append("Var,\n");
                this.buffer.append("                    ");
                this.buffer.append(Misc.minimizeFirstLetter(superEntity));
                this.buffer.append("Var),\n");
                this.buffer.append("                 ");
                this.buffer.append(50);
                this.buffer.append("),\n");
            }
            ++i;
        }
    }

    public final void open(IAbstractLevelModel p) {
        this.open(p, p.getName());
    }

    private final void open(IAbstractModel p, String name) {
        this.reset();
        this.currentModel = p;
        this.numberOfEntities = p.listOfActors().size();
        this.pEntities = new IEntity[this.numberOfEntities];
        p.listOfActors().toArray(this.pEntities);
        this.buffer.append('[');
        this.buffer.append(this.getPrefix());
        this.buffer.append("ProblemFor");
        this.buffer.append(name);
        this.buffer.append("Model() : PtidejProblem");
        this.buffer.append("\n    ->  verbose() := 0,");
        this.buffer.append("\n        let pb := makePtidejProblem(\"");
        this.buffer.append(name);
        this.buffer.append(" Model Problem\", length(listOfEntities), 90)");
        int i = 0;
        while (i < this.numberOfEntities) {
            this.buffer.append(",\n            ");
            this.buffer.append(Misc.minimizeFirstLetter(this.pEntities[i].getActorID()));
            this.buffer.append("Var");
            this.buffer.append(" := makePtidejVar(pb, \"");
            this.buffer.append(this.pEntities[i].getActorID());
            this.buffer.append("\", 1, length(listOfEntities))");
            ++i;
        }
        this.buffer.append(" in (\n\n");
        this.buffer.append("            setVarsToShow(pb.globalSearchSolver, pb.vars),\n\n");
    }

    public final void open(IClass p) {
        this.open((IEntity)p);
    }

    private void open(IEntity p) {
        this.enclosingEntity = p;
    }

    public final void open(IGhost p) {
        this.open((IEntity)p);
    }

    public final void open(IInterface p) {
        this.open((IEntity)p);
    }

    public final void open(IPatternModel p) {
        this.open(p, p.getName());
    }

    public final void reset() {
        this.buffer.setLength(0);
        this.knowledgeLinks.clear();
        this.aggregationTargets.clear();
    }

    public void visit(IAggregation p) {
        this.elementWithTarget(p, "Aggregation", "[#]->", this.buildRuntimeExceptionXCommand("[#]->", p.getTargetActor()), p.getWeight());
        this.aggregationTargets.add(p.getTargetActor().getActorID());
    }

    public void visit(IAssociation p) {
        this.elementWithTarget(p, "Association", "---->", this.buildRuntimeExceptionXCommand("---->", p.getTargetActor()), p.getWeight());
    }

    public void visit(IComposition p) {
        this.elementWithTarget(p, "Composition", "[#]->", this.buildRuntimeExceptionXCommand("[#]->", p.getTargetActor()), p.getWeight());
        this.aggregationTargets.add(p.getTargetActor().getActorID());
    }

    public final void visit(IConstructor p) {
    }

    public void visit(IContainerAggregation p) {
        this.elementWithTarget(p, "ContainerAggregation", "<>-->", this.buildRuntimeExceptionXCommand("<>-->", p.getTargetActor()), p.getWeight());
        this.aggregationTargets.add(p.getTargetActor().getActorID());
    }

    public void visit(IContainerComposition p) {
        this.elementWithTarget(p, "ContainerComposition", "<#>->", this.buildRuntimeExceptionXCommand("<#>->", p.getTargetActor()), p.getWeight());
        this.aggregationTargets.add(p.getTargetActor().getActorID());
    }

    public final void visit(ICreation p) {
        this.elementWithTarget(p, "Creation", "-*-->", this.buildRuntimeExceptionXCommand("-*-->", p.getTargetActor()), p.getWeight());
    }

    public final void visit(IDelegatingMethod p) {
    }

    public final void visit(IField p) {
    }

    public final void visit(IMethod p) {
        IEntity target = (IEntity)this.currentModel.getActorFromName(p.getReturnType());
        if (target != null) {
            this.createConstraint(p, target, "Association", "---->", this.buildRuntimeExceptionXCommand("---->", target), p.getWeight());
        }
    }

    public void visit(IMethodInvocation aMethodInvocation) {
    }

    public final void visit(IParameter p) {
        IEntity target = (IEntity)this.currentModel.getActorFromName(p.getType());
        if (target != null) {
            this.createConstraint(p, target, "Association", "---->", this.buildRuntimeExceptionXCommand("---->", target), 100);
        }
    }

    public final void visit(IUseRelationship p) {
        this.elementWithTarget(p, "Knowledge", "-k-->", this.buildRuntimeExceptionXCommand("-k-->", p.getTargetActor()), p.getWeight());
    }
}

