/*
 * Decompiled with CFR 0.152.
 */
package ptidej.solver;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import ptidej.solver.SolutionComponent;

public final class Solution {
    private final int solutioNumber;
    private final int percentage;
    private List components = new ArrayList();

    public Solution(int solutioNumber, int percentage) {
        this.solutioNumber = solutioNumber;
        this.percentage = percentage;
    }

    public void addComponent(SolutionComponent sc) {
        int index = 0;
        while (index < this.components.size() && ((SolutionComponent)this.components.get(index)).getName().compareToIgnoreCase(sc.getName()) < 0) {
            ++index;
        }
        this.components.add(index, sc);
    }

    public SolutionComponent getComponent(String name) {
        Iterator e = this.components.iterator();
        while (e.hasNext()) {
            SolutionComponent c = (SolutionComponent)e.next();
            if (!c.getName().equals(name)) continue;
            return c;
        }
        return null;
    }

    public List getComponents() {
        return this.components;
    }

    public String getName() {
        SolutionComponent solutionComponent = this.getComponent("Name");
        if (solutionComponent == null) {
            return "unknown pattern";
        }
        return solutionComponent.getValue();
    }

    public int getPercentage() {
        return this.percentage;
    }

    public int getNumber() {
        return this.solutioNumber;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Micro-architecture ");
        buffer.append(this.getNumber());
        buffer.append(" similar at ");
        buffer.append(this.getPercentage());
        buffer.append("% with ");
        buffer.append(this.getName());
        buffer.append('\n');
        Iterator allComponents = this.components.iterator();
        while (allComponents.hasNext()) {
            buffer.append('\t');
            buffer.append(((SolutionComponent)allComponents.next()).toString());
            buffer.append('\n');
        }
        return buffer.toString();
    }
}

