/*
 * Decompiled with CFR 0.152.
 */
package ptidej.solver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import padl.kernel.IAbstractModel;
import padl.kernel.IClass;
import padl.kernel.IEntity;
import padl.kernel.IGhost;
import padl.kernel.IInterface;
import padl.kernel.IPatternModel;
import padl.kernel.ModelDeclarationException;
import ptidej.solver.Solution;
import ptidej.solver.SolutionComponent;
import ptidej.solver.SolutionPatternModel;
import ptidej.util.ibm.collection.Arrays;
import ptidej.util.ibm.collection.Comparator;

public final class SolutionBuilder {
    private static SolutionBuilder uniqueInstance;

    public static Solution[] getCanonicalSolutions(Solution[] givenSolutions) {
        Solution[] solutions = givenSolutions;
        int i = solutions.length - 1;
        while (i > 0) {
            List currentSolutionComponents = solutions[i].getComponents();
            boolean toBeRemoved = true;
            int j = 0;
            while (j < i && toBeRemoved) {
                List otherSolutionComponents = solutions[j].getComponents();
                if (currentSolutionComponents.size() == otherSolutionComponents.size()) {
                    int k = 0;
                    while (k < currentSolutionComponents.size()) {
                        SolutionComponent currentSolutionComponent = (SolutionComponent)currentSolutionComponents.get(k);
                        SolutionComponent otherSolutionComponent = (SolutionComponent)otherSolutionComponents.get(k);
                        if (!(currentSolutionComponent.getName().equals("Name") || currentSolutionComponent.getName().equals("XCommand") || currentSolutionComponent.equals(otherSolutionComponent))) {
                            toBeRemoved = false;
                        }
                        ++k;
                    }
                } else {
                    toBeRemoved = false;
                }
                ++j;
            }
            if (toBeRemoved) {
                Solution[] temporarySolutions = new Solution[solutions.length - 1];
                System.arraycopy(solutions, 0, temporarySolutions, 0, i);
                System.arraycopy(solutions, i + 1, temporarySolutions, i, solutions.length - i - 1);
                solutions = temporarySolutions;
            }
            --i;
        }
        return solutions;
    }

    public static SolutionBuilder getCurrentSolutionBuilder() {
        if (uniqueInstance == null) {
            uniqueInstance = new SolutionBuilder();
        }
        return uniqueInstance;
    }

    private SolutionBuilder() {
    }

    private boolean belongsTo(IEntity pEntity, IPatternModel pattern) {
        Iterator iterator = pattern.listOfActors().iterator();
        while (iterator.hasNext()) {
            if (!((IEntity)iterator.next()).getName().equals(pEntity.getName())) continue;
            return true;
        }
        return false;
    }

    public SolutionPatternModel getSolutionPattern(Solution solution, IAbstractModel sourceCode) {
        IEntity entity;
        String componentValue;
        String componentName;
        SolutionComponent solutionComponent;
        SolutionPatternModel pattern = new SolutionPatternModel(solution.getNumber(), solution.getPercentage());
        Iterator iterator = solution.getComponents().iterator();
        while (iterator.hasNext()) {
            solutionComponent = (SolutionComponent)iterator.next();
            componentName = solutionComponent.getName();
            componentValue = solutionComponent.getValue();
            if (componentName.equals("Name") || componentName.equals("XCommand") || pattern.getActorFromName(componentValue) != null) continue;
            sourceCode.getActorFromName(componentValue).startCloneSession();
        }
        iterator = solution.getComponents().iterator();
        while (iterator.hasNext()) {
            solutionComponent = (SolutionComponent)iterator.next();
            componentName = solutionComponent.getName();
            componentValue = solutionComponent.getValue();
            if (componentName.equals("Name") || componentName.equals("XCommand") || pattern.getActorFromName(componentValue) != null) continue;
            entity = (IEntity)sourceCode.getActorFromName(componentValue);
            entity.performCloneSession();
            try {
                pattern.addActor((IEntity)entity.getClone());
            }
            catch (ModelDeclarationException pde) {
                pde.printStackTrace();
            }
        }
        iterator = solution.getComponents().iterator();
        while (iterator.hasNext()) {
            solutionComponent = (SolutionComponent)iterator.next();
            componentName = solutionComponent.getName();
            componentValue = solutionComponent.getValue();
            if (componentName.equals("Name") || componentName.equals("XCommand") || pattern.getActorFromName(componentValue) != null) continue;
            entity = (IEntity)sourceCode.getActorFromName(componentValue);
            entity.endCloneSession();
        }
        this.reConnectSuperEntities(pattern, sourceCode);
        return pattern;
    }

    public Solution[] getCanonicalSolutions(Properties properties, IAbstractModel abstractModel) {
        return SolutionBuilder.getCanonicalSolutions(this.getAllSolutions(properties, abstractModel));
    }

    public Solution[] getAllSolutions(Properties properties, IAbstractModel abstractModel) {
        try {
            HashMap<Integer, Solution> listOfSolutions = new HashMap<Integer, Solution>();
            Iterator<Object> iterator = ((Hashtable)properties).keySet().iterator();
            int i = 0;
            while (i < ((Hashtable)properties).size()) {
                String key = (String)iterator.next();
                int firstDotPos = key.indexOf(46);
                if (firstDotPos > 0) {
                    Solution solution;
                    int solutionNumber = Integer.parseInt(key.substring(0, firstDotPos));
                    int percentage = Integer.parseInt(key.substring(++firstDotPos, key.indexOf(46, firstDotPos)));
                    String name = key.substring(key.lastIndexOf(46) + 1);
                    String value = properties.getProperty(key);
                    Integer solutionKey = new Integer(solutionNumber);
                    if (listOfSolutions.containsKey(solutionKey)) {
                        solution = (Solution)listOfSolutions.get(solutionKey);
                    } else {
                        solution = new Solution(solutionNumber, percentage);
                        listOfSolutions.put(solutionKey, solution);
                    }
                    solution.addComponent(new SolutionComponent(name, value));
                }
                ++i;
            }
            Object[] solutions = new Solution[listOfSolutions.size()];
            iterator = listOfSolutions.values().iterator();
            int i2 = 0;
            while (i2 < solutions.length) {
                solutions[i2] = (Solution)iterator.next();
                ++i2;
            }
            Arrays.sort(solutions, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((Solution)o1).getNumber() - ((Solution)o2).getNumber();
                }
            });
            return solutions;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Solution[0];
        }
    }

    private IEntity reConnectSuperClass(IClass pClass, IPatternModel pattern, IAbstractModel sourceCode) {
        List listOfInheritedActors = ((IClass)sourceCode.getActorFromName(pClass.getActorID())).listOfInheritedActors();
        if (listOfInheritedActors.size() == 0) {
            return null;
        }
        IEntity superclass = (IEntity)listOfInheritedActors.get(0);
        if (superclass == null || this.belongsTo(superclass, pattern) || superclass instanceof IGhost) {
            return superclass;
        }
        ArrayList listOfsuperinterfaces = new ArrayList();
        this.reConnectSuperInterfaces((IClass)superclass, pattern, sourceCode, listOfsuperinterfaces);
        Iterator iterator = listOfsuperinterfaces.iterator();
        try {
            while (iterator.hasNext()) {
                pClass.addImplementedEntity((IEntity)iterator.next());
            }
        }
        catch (ModelDeclarationException modelDeclarationException) {
            // empty catch block
        }
        return this.reConnectSuperClass((IClass)superclass, pattern, sourceCode);
    }

    private void reConnectSuperEntities(IPatternModel pattern, IAbstractModel sourceCode) {
        Iterator iterator = pattern.listOfActors().iterator();
        while (iterator.hasNext()) {
            IEntity superEntity;
            Iterator iterator2;
            ArrayList listOfsuperinterfaces;
            IEntity pEntity = (IEntity)iterator.next();
            if (pEntity instanceof IClass) {
                listOfsuperinterfaces = new ArrayList();
                this.reConnectSuperInterfaces((IClass)pEntity, pattern, sourceCode, listOfsuperinterfaces);
                iterator2 = listOfsuperinterfaces.iterator();
                while (iterator2.hasNext()) {
                    superEntity = (IEntity)iterator2.next();
                    try {
                        ((IClass)pEntity).addImplementedEntity(superEntity);
                    }
                    catch (ModelDeclarationException modelDeclarationException) {
                        // empty catch block
                    }
                }
                IEntity superClass = this.reConnectSuperClass((IClass)pEntity, pattern, sourceCode);
                if (superClass == null) continue;
                try {
                    pEntity.addInheritedActor(superClass);
                }
                catch (ModelDeclarationException pde) {}
                continue;
            }
            if (!(pEntity instanceof IInterface)) continue;
            listOfsuperinterfaces = new ArrayList();
            this.reConnectSuperInterfaces((IInterface)pEntity, pattern, sourceCode, listOfsuperinterfaces);
            iterator2 = listOfsuperinterfaces.iterator();
            while (iterator2.hasNext()) {
                superEntity = (IEntity)iterator2.next();
                try {
                    ((IInterface)pEntity).addInheritedActor(superEntity);
                }
                catch (ModelDeclarationException modelDeclarationException) {
                    // empty catch block
                }
            }
        }
    }

    private void reConnectSuperInterfaces(IClass pClass, IPatternModel pattern, IAbstractModel sourceCode, List listOfSuperinterfaces) {
        Iterator iterator = ((IClass)sourceCode.getActorFromName(pClass.getActorID())).listOfImplementedEntities().iterator();
        while (iterator.hasNext()) {
            IEntity superinterface = (IEntity)iterator.next();
            if (this.belongsTo(superinterface, pattern) || superinterface instanceof IGhost) {
                listOfSuperinterfaces.add(superinterface);
                continue;
            }
            this.reConnectSuperInterfaces((IInterface)superinterface, pattern, sourceCode, listOfSuperinterfaces);
        }
    }

    private void reConnectSuperInterfaces(IInterface pInterface, IPatternModel pattern, IAbstractModel sourceCode, List listOfSuperinterfaces) {
        Iterator iterator = ((IInterface)sourceCode.getActorFromName(pInterface.getActorID())).listOfInheritedActors().iterator();
        while (iterator.hasNext()) {
            IEntity superinterface = (IEntity)iterator.next();
            if (this.belongsTo(superinterface, pattern) || superinterface instanceof IGhost) {
                listOfSuperinterfaces.add(superinterface);
                continue;
            }
            this.reConnectSuperInterfaces((IInterface)superinterface, pattern, sourceCode, listOfSuperinterfaces);
        }
    }
}

