/*
 * Decompiled with CFR 0.152.
 */
package ptidej.solver;

import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Properties;
import padl.kernel.IAbstractModel;
import padl.kernel.IGenerator;
import padl.kernel.IPatternModel;
import padl.kernel.IWalker;
import padl.kernel.impl.v2.PatternModel;
import padl.visitor.PtidejSolver2AC4DomainGenerator;
import padl.visitor.PtidejSolver2CustomDomainGenerator;
import padl.visitor.PtidejSolver3AC4DomainGenerator;
import padl.visitor.PtidejSolver3CustomDomainGenerator;
import padl.visitor.PtidejSolverAC4ConstraintGenerator;
import padl.visitor.PtidejSolverConstraintGenerator;
import padl.visitor.PtidejSolverCustomConstraintGenerator;
import padl.visitor.PtidejSolverDomainGenerator;
import util.PropertyManager;
import util.io.File;
import util.io.OutputMonitor;

public final class SolutionGenerator {
    public static final int AUTOMATIC_SOLVER = 0;
    public static final int COMBINATORIAL_AUTOMATIC_SOLVER = 1;
    public static final int SIMPLE_AUTOMATIC_SOLVER = 2;
    public static final int CUSTOM_PROBLEM = 0;
    public static final int AC4_PROBLEM = 1;
    public static final int PTIDEJSOLVER2_VERSION = 2;
    public static final int PTIDEJSOLVER3_VERSION = 3;
    private static SolutionGenerator uniqueInstance;
    static /* synthetic */ Class class$0;

    public static SolutionGenerator getCurrentSolutionGenerator() {
        if (uniqueInstance == null) {
            uniqueInstance = new SolutionGenerator();
        }
        return uniqueInstance;
    }

    private SolutionGenerator() {
    }

    public Properties callConstraintSolver() {
        Properties properties = new Properties();
        try {
            StringBuffer stringBuffer = new StringBuffer(String.valueOf('\"'));
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("ptidej.solver.SolutionGenerator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String commandLine = stringBuffer.append(File.getClassPath(clazz)).append(PropertyManager.getSolverDirectory()).append(PropertyManager.getSolverCommand()).append("\" ").append(PropertyManager.getSolverArguments()).append(" -f \"").append(PropertyManager.getSolverDomainDirectory()).append("Instructions.cl\"").toString().replace('/', '\\');
            Process process = Runtime.getRuntime().exec(commandLine);
            OutputMonitor errorStreamMonitor = new OutputMonitor("Ptidej Solver Error Stream Monitor", "", process.getErrorStream(), System.out);
            errorStreamMonitor.start();
            OutputMonitor inputStreamMonitor = new OutputMonitor("Ptidej Solver Input Stream Monitor", "", process.getInputStream(), System.out);
            inputStreamMonitor.start();
            try {
                process.waitFor();
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
            if (process.exitValue() != 0) {
                while (process.getErrorStream().available() > 0) {
                    System.out.print((char)process.getErrorStream().read());
                }
            }
            properties.load(new FileInputStream(String.valueOf(PropertyManager.getSolverResultDirectory()) + PropertyManager.getSolverResultFile()));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return properties;
    }

    private void createConstraints(IPatternModel pattern, IGenerator constraintGenerator) {
        if (pattern != null) {
            try {
                pattern.generate(constraintGenerator);
                FileWriter writer = new FileWriter(String.valueOf(PropertyManager.getSolverDomainDirectory()) + pattern.getName() + "Pattern.cl");
                writer.write(constraintGenerator.getCode());
                writer.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private void createDomain(IAbstractModel source, IWalker domainGenerator) {
        try {
            source.walk(domainGenerator);
            FileWriter writer = new FileWriter(String.valueOf(PropertyManager.getSolverDomainDirectory()) + PropertyManager.getSolverDomainFile());
            writer.write(domainGenerator.getResult().toString());
            writer.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void createInstructions(IPatternModel pattern, String solver, String problem) {
        block10: {
            OutputStreamWriter writer = null;
            try {
                try {
                    writer = new FileWriter(String.valueOf(PropertyManager.getSolverDomainDirectory()) + PropertyManager.getSolverInstructionFile());
                    StringBuffer instructions = new StringBuffer();
                    instructions.append("[solvePtidejProblem() : void\n");
                    instructions.append("\t->\tPtidejResultFile := \"");
                    instructions.append(PropertyManager.getSolverResultDirectory());
                    instructions.append(PropertyManager.getSolverResultFile());
                    instructions.append("\",\n\t\tprintHeader(),\n\t\tprintf(\"~A ");
                    instructions.append("Loading domain file\t\", char!(179)),\n");
                    if (pattern != null) {
                        instructions.append("\t\tload(\"");
                        instructions.append(PropertyManager.getSolverDomainDirectory());
                        instructions.append(pattern.getName());
                        instructions.append("Pattern.cl");
                        instructions.append("\"),\n");
                    }
                    instructions.append("\t\tload(\"");
                    instructions.append(PropertyManager.getSolverDomainDirectory());
                    instructions.append(PropertyManager.getSolverDomainFile());
                    instructions.append("\"),\n\t\tsearchConcretePatterns(\n\t\t\t");
                    instructions.append(solver);
                    instructions.append(" @ PtidejProblem,\n\t\t\t");
                    instructions.append(problem);
                    instructions.append("Pattern()),\n\t\texit(-1)\n]\n\n");
                    instructions.append("(solvePtidejProblem())");
                    writer.write(instructions.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            Object var6_9 = null;
            if (writer == null) break block10;
            try {
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void generateExecutionInformation(String patternName, IPatternModel pattern, IAbstractModel source, int solver, int problem) {
        PtidejSolverConstraintGenerator constraintGenerator;
        PtidejSolverDomainGenerator domainGenerator;
        String problemName;
        String solverName;
        switch (solver) {
            case 0: {
                solverName = "automaticSolve";
                break;
            }
            case 1: {
                solverName = "combinatorialAutomaticSolve";
                break;
            }
            case 2: {
                solverName = "simpleAutomaticSolve";
                break;
            }
            default: {
                throw new RuntimeException("SolutionGenerator: Unknown solver algorithm.");
            }
        }
        block5 : switch (PropertyManager.getSolverVersion()) {
            case 2: {
                switch (problem) {
                    case 0: {
                        problemName = "customProblemFor" + patternName;
                        domainGenerator = new PtidejSolver2CustomDomainGenerator();
                        constraintGenerator = new PtidejSolverCustomConstraintGenerator();
                        break block5;
                    }
                    case 1: {
                        problemName = "ac4ProblemFor" + patternName;
                        domainGenerator = new PtidejSolver2AC4DomainGenerator();
                        constraintGenerator = new PtidejSolverAC4ConstraintGenerator();
                        break block5;
                    }
                }
                throw new RuntimeException("SolutionGenerator: Unknown problem type.");
            }
            case 3: {
                switch (problem) {
                    case 0: {
                        problemName = "customProblemFor" + patternName;
                        domainGenerator = new PtidejSolver3CustomDomainGenerator();
                        constraintGenerator = new PtidejSolverCustomConstraintGenerator();
                        break block5;
                    }
                    case 1: {
                        problemName = "ac4ProblemFor" + patternName;
                        domainGenerator = new PtidejSolver3AC4DomainGenerator();
                        constraintGenerator = new PtidejSolverAC4ConstraintGenerator();
                        break block5;
                    }
                }
                throw new RuntimeException("SolutionGenerator: Unknown problem type.");
            }
            default: {
                throw new RuntimeException("SolutionGenerator: Unknown solver version.");
            }
        }
        this.createDomain(source, (IWalker)((Object)domainGenerator));
        this.createConstraints(pattern, (IGenerator)((Object)constraintGenerator));
        this.createInstructions(pattern, solverName, problemName);
    }

    public Properties getSolutions(PatternModel pattern, IAbstractModel source, int solver, int problem) {
        return this.getSolutions(pattern.getName(), pattern, source, solver, problem);
    }

    public Properties getSolutions(String patternName, IAbstractModel source, int solver, int problem) {
        return this.getSolutions(patternName, null, source, solver, problem);
    }

    private Properties getSolutions(String patternName, PatternModel pattern, IAbstractModel source, int solver, int problem) {
        this.generateExecutionInformation(patternName, pattern, source, solver, problem);
        return this.callConstraintSolver();
    }
}

