/*
 * Decompiled with CFR 0.152.
 */
package ptidej.solver.domain;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import padl.kernel.IAbstractLevelModel;
import padl.kernel.IAggregation;
import padl.kernel.IAssociation;
import padl.kernel.IClass;
import padl.kernel.IComposition;
import padl.kernel.IConstructor;
import padl.kernel.IContainerAggregation;
import padl.kernel.IContainerComposition;
import padl.kernel.ICreation;
import padl.kernel.IDelegatingMethod;
import padl.kernel.IEntity;
import padl.kernel.IField;
import padl.kernel.IGhost;
import padl.kernel.IInterface;
import padl.kernel.IMethod;
import padl.kernel.IMethodInvocation;
import padl.kernel.IParameter;
import padl.kernel.IPatternModel;
import padl.kernel.IUseRelationship;
import padl.kernel.IWalker;
import ptidej.solver.domain.Entity;

public class Generator
implements IWalker {
    private Entity currentEntity;
    private Map listOfEntities = new HashMap();
    private List listOfKnownEntityNames = new ArrayList();

    public void close(IAbstractLevelModel anAbstractLevelModel) {
    }

    public void close(IClass aClass) {
        this.close((IEntity)aClass);
    }

    private void close(IEntity aModelEntity) {
        Iterator itertor = this.listOfEntities.keySet().iterator();
        while (itertor.hasNext()) {
            String name = (String)itertor.next();
            if (this.listOfKnownEntityNames.contains(name)) continue;
            this.currentEntity.addUnknownEntity(this.findEntity(name));
        }
        this.listOfKnownEntityNames.clear();
    }

    public void close(IGhost aGhost) {
        this.close((IEntity)aGhost);
    }

    public void close(IInterface anInterface) {
        this.close((IEntity)anInterface);
    }

    public void close(IPatternModel aPatternModel) {
    }

    private Entity findEntity(IEntity aModelEntity) {
        return this.findEntity(aModelEntity.getName());
    }

    private Entity findEntity(String aName) {
        this.listOfKnownEntityNames.add(aName);
        return (Entity)this.listOfEntities.get(aName);
    }

    public String getName() {
        return "JPtidejSolver domain";
    }

    public Object getResult() {
        ArrayList listOfEntities = new ArrayList();
        Iterator iterator = this.listOfEntities.values().iterator();
        while (iterator.hasNext()) {
            listOfEntities.add(iterator.next());
        }
        return listOfEntities;
    }

    public void open(IAbstractLevelModel anAbstractLevelModel) {
        Iterator iterator = anAbstractLevelModel.listOfActors().iterator();
        while (iterator.hasNext()) {
            IEntity entity = (IEntity)iterator.next();
            this.listOfEntities.put(entity.getName(), new Entity(entity.getName()));
        }
    }

    public void open(IClass aClass) {
        this.open((IEntity)aClass);
    }

    private void open(IEntity aModelEntity) {
        this.currentEntity = this.findEntity(aModelEntity);
        Iterator iterator = aModelEntity.listOfInheritedActors().iterator();
        while (iterator.hasNext()) {
            this.currentEntity.addSuperEntity(this.findEntity((IEntity)iterator.next()));
        }
    }

    public void open(IGhost aGhost) {
        this.open((IEntity)aGhost);
    }

    public void open(IInterface anInterface) {
        this.open((IEntity)anInterface);
    }

    public void open(IPatternModel aPatternModel) {
    }

    public void reset() {
        this.listOfEntities.clear();
    }

    public void visit(IAggregation anAggregation) {
        this.currentEntity.addAggregatedEntity(this.findEntity(anAggregation.getTargetActor()));
    }

    public void visit(IAssociation anAssociation) {
        this.currentEntity.addAssociatedEntity(this.findEntity(anAssociation.getTargetActor()));
    }

    public void visit(IComposition aComposition) {
        this.currentEntity.addComposedEntity(this.findEntity(aComposition.getTargetActor()));
    }

    public void visit(IConstructor aConstructor) {
    }

    public void visit(IContainerAggregation aContainerAggregation) {
        this.currentEntity.addContainerAggregatedEntity(this.findEntity(aContainerAggregation.getTargetActor()));
    }

    public void visit(IContainerComposition aContainerComposition) {
        this.currentEntity.addContainerComposedEntity(this.findEntity(aContainerComposition.getTargetActor()));
    }

    public void visit(ICreation aCreation) {
        this.currentEntity.addCreatedEntity(this.findEntity(aCreation.getTargetActor()));
    }

    public void visit(IDelegatingMethod aDelegatingMethod) {
        Entity entity = this.findEntity(aDelegatingMethod.getReturnType());
        if (entity != null) {
            this.currentEntity.addKnownEntity(entity);
        }
    }

    public void visit(IField aField) {
        this.currentEntity.addKnownEntity(this.findEntity(aField.getType()));
    }

    public void visit(IMethod aMethod) {
        Entity entity = this.findEntity(aMethod.getReturnType());
        if (entity != null) {
            this.currentEntity.addKnownEntity(entity);
        }
    }

    public void visit(IMethodInvocation aMethodInvocation) {
        if (aMethodInvocation.getTargetEntity() != null) {
            this.currentEntity.addKnownEntity(this.findEntity(aMethodInvocation.getTargetEntity()));
        }
    }

    public void visit(IParameter aParameter) {
        Entity entity = this.findEntity(aParameter.getType());
        if (entity != null) {
            this.currentEntity.addKnownEntity(entity);
        }
    }

    public void visit(IUseRelationship aUse) {
        this.currentEntity.addKnownEntity(this.findEntity(aUse.getTargetActor()));
    }
}

