/*
 * Decompiled with CFR 0.152.
 */
package ptidej.ui;

import java.awt.Dimension;
import java.awt.Point;
import java.util.Vector;
import ptidej.ui.Constants;
import ptidej.ui.Drawable;
import ptidej.ui.event.MouseEvent;
import ptidej.ui.kernel.GraphicModel;
import ptidej.ui.primitive.PrimitiveFactory;

public final class Canvas
implements Drawable {
    private final PrimitiveFactory primitiveFactory;
    private final GraphicModel pattern;
    private Dimension dimension = new Dimension();
    private Vector backgroundComponents = new Vector();
    private Vector foregroundComponents = new Vector();

    public Canvas(PrimitiveFactory primitiveFactory, GraphicModel pattern) {
        this.primitiveFactory = primitiveFactory;
        this.pattern = pattern;
        this.reComputeDimension();
    }

    public void addToBackground(Drawable component) {
        this.backgroundComponents.addElement(component);
        this.setDimension(component.getPosition(), component.getDimension());
    }

    public void addToForeground(Drawable component) {
        this.foregroundComponents.addElement(component);
        this.setDimension(component.getPosition(), component.getDimension());
    }

    public void build() {
        Drawable[] drawables = this.getBackgroundElements();
        int i = 0;
        while (i < drawables.length) {
            drawables[i].build();
            ++i;
        }
        drawables = this.getForegroundElements();
        i = 0;
        while (i < drawables.length) {
            drawables[i].build();
            ++i;
        }
        this.reComputeDimension();
    }

    public Drawable[] getBackgroundElements() {
        Object[] elements = new Drawable[this.backgroundComponents.size()];
        this.backgroundComponents.copyInto(elements);
        return elements;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public Drawable[] getForegroundElements() {
        Object[] elements = new Drawable[this.foregroundComponents.size()];
        this.foregroundComponents.copyInto(elements);
        return elements;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public Point getPosition() {
        return Constants.NULL_POSITION;
    }

    public boolean isSelected() {
        return false;
    }

    public final void paint(int xOffset, int yOffset) {
        Drawable[] drawables = this.getBackgroundElements();
        int i = drawables.length - 1;
        while (i >= 0) {
            drawables[i].paint(xOffset, yOffset);
            --i;
        }
        this.pattern.paint(xOffset, yOffset);
        drawables = this.getForegroundElements();
        i = drawables.length - 1;
        while (i >= 0) {
            drawables[i].paint(xOffset, yOffset);
            --i;
        }
    }

    public boolean processMouseEvent(MouseEvent me) {
        boolean hasChanged = false;
        Drawable[] drawables = this.getForegroundElements();
        int i = 0;
        while (i < drawables.length && !hasChanged) {
            hasChanged = drawables[i].processMouseEvent(me);
            ++i;
        }
        if (!hasChanged && !(hasChanged = this.pattern.processMouseEvent(me))) {
            drawables = this.getBackgroundElements();
            i = 0;
            while (i < drawables.length && !hasChanged) {
                hasChanged = drawables[i].processMouseEvent(me);
                ++i;
            }
        }
        return hasChanged;
    }

    private void reComputeDimension() {
        this.dimension.setSize((int)Constants.NULL_DIMENSION.getWidth(), (int)Constants.NULL_DIMENSION.getHeight());
        Drawable[] drawables = this.getBackgroundElements();
        int i = 0;
        while (i < drawables.length) {
            this.setDimension(drawables[i].getPosition(), drawables[i].getDimension());
            ++i;
        }
        this.setDimension(this.pattern.getPosition(), this.pattern.getDimension());
        drawables = this.getForegroundElements();
        i = 0;
        while (i < drawables.length) {
            this.setDimension(drawables[i].getPosition(), drawables[i].getDimension());
            ++i;
        }
    }

    public void removeFromBackground(Drawable component) {
        this.backgroundComponents.removeElement(component);
        this.reComputeDimension();
    }

    public void removeFromForeground(Drawable component) {
        this.foregroundComponents.removeElement(component);
        this.reComputeDimension();
    }

    private void setDimension(Point entityOrElementPosition, Dimension entityOrElementDimension) {
        double tempWidth = entityOrElementPosition.x + entityOrElementDimension.width + Constants.CANVAS_INNER_GAP.width;
        tempWidth = this.getDimension().getWidth() < tempWidth ? tempWidth : this.getDimension().getWidth();
        double tempHeight = entityOrElementPosition.y + entityOrElementDimension.height + Constants.CANVAS_INNER_GAP.height;
        tempHeight = this.getDimension().getHeight() < tempHeight ? tempHeight : this.getDimension().getHeight();
        this.dimension.setSize((int)tempWidth, (int)tempHeight);
    }

    public void setSelected(boolean isSelected) {
    }
}

