/*
 * Decompiled with CFR 0.152.
 */
package ptidej.ui;

import ptidej.ui.Constants;

public class RGB {
    private final int red;
    private final int green;
    private final int blue;

    public static RGB computePercentagedColor(int percentage) {
        int red = Constants.BACKGROUND_COLOR.getRed();
        int green = (int)((double)Constants.BACKGROUND_COLOR.getGreen() - (double)Constants.BACKGROUND_COLOR.getGreen() * Math.max((double)percentage / 100.0, 0.15));
        int blue = (int)((double)Constants.BACKGROUND_COLOR.getBlue() - (double)Constants.BACKGROUND_COLOR.getBlue() * Math.max((double)percentage / 100.0, 0.15));
        return new RGB(red, green, blue);
    }

    public RGB(int red, int green, int blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public boolean equals(Object o) {
        if (o instanceof RGB) {
            RGB other = (RGB)o;
            return this.red == other.red && this.green == other.green && this.blue == other.blue;
        }
        return false;
    }

    public int getBlue() {
        return this.blue;
    }

    public int getGreen() {
        return this.green;
    }

    public int getRed() {
        return this.red;
    }

    public int hashCode() {
        return this.red + this.green + this.blue;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(18);
        buffer.append("RGB(");
        buffer.append(this.red);
        buffer.append(", ");
        buffer.append(this.green);
        buffer.append(", ");
        buffer.append(this.blue);
        buffer.append(')');
        return buffer.toString();
    }
}

