/*
 * Decompiled with CFR 0.152.
 */
package ptidej.ui.extension;

import com.ibm.toad.cfparse.ClassFile;
import java.security.AccessControlException;
import java.util.ArrayList;
import padl.IFileRepository;
import ptidej.ui.extension.Extension;
import util.PropertyManager;
import util.io.SubtypeLoader;

public class Repository {
    private static Repository UniqueInstance;
    private Extension[] extensions;

    public static Repository getCurrentExtensionManager(IFileRepository fileRepository) {
        if (UniqueInstance == null) {
            UniqueInstance = new Repository(fileRepository);
        }
        return UniqueInstance;
    }

    private Repository(IFileRepository fileRepository) {
        try {
            ClassFile[] classFiles = SubtypeLoader.loadSubtypesFromStream(PropertyManager.getExtensionSupertype(), fileRepository.getFiles(), PropertyManager.getExtensionPackage(), PropertyManager.getExtensionExtension());
            ArrayList<Extension> listOfExtensions = new ArrayList<Extension>(classFiles.length);
            int i = 0;
            while (i < classFiles.length) {
                try {
                    listOfExtensions.add((Extension)Class.forName(classFiles[i].getName()).newInstance());
                }
                catch (Throwable t) {
                    System.err.print("Cannot load extension ");
                    System.err.print(classFiles[i].getName());
                    System.err.println(':');
                    t.printStackTrace();
                }
                ++i;
            }
            this.extensions = new Extension[listOfExtensions.size()];
            listOfExtensions.toArray(this.extensions);
        }
        catch (AccessControlException ace) {
            this.extensions = new Extension[0];
        }
    }

    public Extension[] getExtensions() {
        return this.extensions;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Extension Repository:\n");
        int x = 0;
        while (x < this.getExtensions().length) {
            buffer.append('\t');
            buffer.append(this.getExtensions()[x].getName());
            buffer.append('\n');
            ++x;
        }
        return buffer.toString();
    }
}

