/*
 * Decompiled with CFR 0.152.
 */
package ptidej.ui.extension.repository;

import infovis.Column;
import infovis.Graph;
import infovis.Table;
import infovis.column.FloatColumn;
import infovis.column.StringColumn;
import infovis.graph.DefaultGraph;
import infovis.graph.io.GraphReaderFactory;
import infovis.io.AbstractReader;
import infovis.io.AbstractTableReader;
import infovis.io.WrongFormatException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.HashMap;
import java.util.Map;

public final class CSVGraphReader
extends AbstractTableReader {
    private StringColumn edgeIdColumn;
    private Graph graph;
    private Map nodeMap;
    private FloatColumn weightColumn;

    public static void main(String[] args) {
        DefaultGraph g = new DefaultGraph();
        AbstractReader reader = GraphReaderFactory.createReader((String)args[0], (Graph)g);
        reader.load();
        int j = 0;
        while (j < g.getRowCount()) {
            int i = 0;
            while (i < g.getColumnCount()) {
                Column c = g.getColumnAt(i);
                System.out.print(String.valueOf(c.getValueAt(j)) + "\t");
                ++i;
            }
            System.out.print("\n");
            ++j;
        }
    }

    public CSVGraphReader(BufferedReader in, String name, Table table) {
        super(in, name, table);
        this.graph = (Graph)table;
    }

    private void init() {
        this.nodeMap = new HashMap();
        this.edgeIdColumn = StringColumn.findColumn((Table)this.graph.getEdgeTable(), (String)"Name");
        this.weightColumn = FloatColumn.findColumn((Table)this.graph.getEdgeTable(), (String)"Weight");
    }

    public boolean load() throws WrongFormatException {
        this.init();
        StreamTokenizer st = new StreamTokenizer(((AbstractReader)this).in);
        st.eolIsSignificant(true);
        st.wordChars(36, 36);
        st.wordChars(95, 95);
        st.wordChars(63, 63);
        st.wordChars(61, 61);
        st.wordChars(35, 35);
        st.wordChars(58, 58);
        st.wordChars(47, 47);
        st.wordChars(38, 38);
        st.wordChars(43, 43);
        try {
            while (this.readLine(st)) {
            }
        }
        catch (Exception e) {
            System.err.println("Syntax error on line " + st.lineno());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean readLine(StreamTokenizer st) throws Exception {
        int ttype = st.nextToken();
        if (ttype == 10) {
            return true;
        }
        if (ttype == -1) {
            return false;
        }
        if (ttype != -3) {
            throw new IOException("Unexpected token " + st.toString() + " read from stream, a word was expected");
        }
        String name1 = st.sval.substring(st.sval.lastIndexOf(46) + 1);
        Integer id1 = (Integer)this.nodeMap.get(name1);
        if (id1 == null) {
            id1 = new Integer(this.graph.addVertex());
            this.nodeMap.put(name1, id1);
        }
        if ((ttype = st.nextToken()) != -3) {
            throw new IOException("Unexpected token " + st.toString() + " read from stream, a word was expected");
        }
        String name2 = st.sval.substring(st.sval.lastIndexOf(46) + 1);
        Integer id2 = (Integer)this.nodeMap.get(name2);
        if (id2 == null) {
            id2 = new Integer(this.graph.addVertex());
            this.nodeMap.put(name2, id2);
        }
        if ((ttype = st.nextToken()) != -2) {
            throw new IOException("Unexpected token " + st.toString() + " read from stream, a number was expected");
        }
        float w = (float)st.nval;
        int edgeId = this.graph.addEdge(id1.intValue(), id2.intValue());
        this.edgeIdColumn.setExtend(edgeId, String.valueOf(name1) + '-' + name2);
        this.weightColumn.setExtend(edgeId, w);
        return true;
    }
}

