/*
 * Decompiled with CFR 0.152.
 */
package ptidej.ui.extension.repository;

import java.awt.Component;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JFrame;
import ptidej.ui.Representation;
import ptidej.ui.event.SourceEvent;
import ptidej.ui.extension.Extension;
import ptidej.ui.extension.repository.DottyGenerator;
import util.io.OutputMonitor;

public final class Dotty
extends JFrame
implements Extension {
    private void callDotty(Representation representation) {
        ((Component)this).setVisible(false);
        this.getContentPane().removeAll();
        DottyGenerator builder = new DottyGenerator(representation.getSourceGraph().getVisibleElements());
        representation.getSourceModel().generate(builder);
        String path = String.valueOf(System.getProperty("user.dir")) + File.separatorChar + "Temp.dot";
        try {
            FileWriter writer = new FileWriter(path);
            writer.write(builder.getCode().toString());
            writer.close();
            StringBuffer commandLine = new StringBuffer();
            commandLine.append("Dotty ");
            commandLine.append(path);
            final Process process = Runtime.getRuntime().exec(commandLine.toString());
            OutputMonitor errorStreamMonitor = new OutputMonitor("Dotty Stream Monitor", "", process.getErrorStream(), System.out);
            errorStreamMonitor.start();
            OutputMonitor inputStreamMonitor = new OutputMonitor("Dotty Input Stream Monitor", "", process.getInputStream(), System.out);
            inputStreamMonitor.start();
            new Thread(new Runnable(){

                public void run() {
                    try {
                        process.waitFor();
                    }
                    catch (InterruptedException ie) {
                        ie.printStackTrace();
                    }
                    if (process.exitValue() != 0) {
                        try {
                            while (process.getErrorStream().available() > 0) {
                                System.out.print((char)process.getErrorStream().read());
                            }
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                }
            }).start();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public String getName() {
        return "Dotty";
    }

    public void invoke(Representation representation) {
        this.callDotty(representation);
    }

    public void sourceStateChanged(SourceEvent sourceEvent) {
        if (this.isVisible()) {
            this.callDotty(sourceEvent.getRepresentation());
        }
    }
}

