/*
 * Decompiled with CFR 0.152.
 */
package ptidej.ui.extension.repository;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import padl.kernel.IAbstractLevelModel;
import padl.kernel.IAbstractModel;
import padl.kernel.IAggregation;
import padl.kernel.IAssociation;
import padl.kernel.IClass;
import padl.kernel.IComposition;
import padl.kernel.IConstructor;
import padl.kernel.IContainerAggregation;
import padl.kernel.IContainerComposition;
import padl.kernel.ICreation;
import padl.kernel.IDelegatingMethod;
import padl.kernel.IEntity;
import padl.kernel.IField;
import padl.kernel.IGenerator;
import padl.kernel.IGhost;
import padl.kernel.IInterface;
import padl.kernel.IMethod;
import padl.kernel.IMethodInvocation;
import padl.kernel.IParameter;
import padl.kernel.IPatternModel;
import padl.kernel.IUseRelationship;

public final class DottyGenerator
implements IGenerator {
    private Map aggregations = new HashMap();
    private Map associations = new HashMap();
    private final StringBuffer buffer = new StringBuffer();
    private Map compositions = new HashMap();
    private Map creations = new HashMap();
    private String currentEntityName;
    private Map uses = new HashMap();
    private final int visibleElements;

    private static String convertName(String entityName) {
        return entityName.replace('.', '_');
    }

    public DottyGenerator(int visibleElements) {
        this.visibleElements = visibleElements;
    }

    private void addHierarchyRelationship(List listOfHierarchyRelationships, String label) {
        Iterator iterator = listOfHierarchyRelationships.iterator();
        while (iterator.hasNext()) {
            IEntity targetEntity = (IEntity)iterator.next();
            if (targetEntity instanceof IGhost && (this.visibleElements & 0x8000) != 32768) continue;
            this.buffer.append('\t');
            this.buffer.append(this.currentEntityName);
            this.buffer.append(" -> ");
            this.buffer.append(DottyGenerator.convertName(targetEntity.getName()));
            this.buffer.append(" [label=\"");
            this.buffer.append(label);
            this.buffer.append("\"];\n");
        }
    }

    private void addRelationship(Map relationships, String specialNodeAttributes) {
        Iterator targetNameIterator = relationships.keySet().iterator();
        while (targetNameIterator.hasNext()) {
            String targetName = (String)targetNameIterator.next();
            StringBuffer relationshipNames = (StringBuffer)relationships.get(targetName);
            this.buffer.append('\t');
            this.buffer.append(this.currentEntityName);
            this.buffer.append(" -> ");
            this.buffer.append(DottyGenerator.convertName(targetName));
            this.buffer.append(" [label=\"");
            this.buffer.append(relationshipNames);
            this.buffer.append("\"");
            this.buffer.append(specialNodeAttributes);
            this.buffer.append("];\n");
        }
    }

    private void addRelationshipName(IUseRelationship relationship, Map relationships) {
        IEntity targetEntity = relationship.getTargetActor();
        String targetEntityName = targetEntity.getName();
        if (!(targetEntity instanceof IGhost) || (this.visibleElements & 0x8000) == 32768) {
            StringBuffer relationshipNames;
            if (relationships.containsKey(targetEntityName)) {
                relationshipNames = (StringBuffer)relationships.get(targetEntityName);
            } else {
                relationshipNames = new StringBuffer();
                relationships.put(targetEntityName, relationshipNames);
                String relationshipName = relationship.getClass().getName();
                relationshipNames.append(relationshipName.substring(relationshipName.lastIndexOf(46) + 1));
                relationshipNames.append(" through:\\n");
            }
            relationshipNames.append(relationship.getName());
            relationshipNames.append("\\n");
        }
    }

    public void close(IAbstractLevelModel p) {
        this.close((IAbstractModel)p);
    }

    private void close(IAbstractModel p) {
        this.buffer.append("\n}");
    }

    public void close(IClass p) {
        this.close((IEntity)p);
    }

    private void close(IEntity entity) {
        this.addRelationship(this.associations, "");
        this.addRelationship(this.aggregations, "");
        this.addRelationship(this.compositions, ",style=bold");
        this.addRelationship(this.creations, ",style=dotted");
        this.addRelationship(this.uses, "");
        this.aggregations.clear();
        this.associations.clear();
        this.compositions.clear();
        this.creations.clear();
        this.uses.clear();
    }

    public void close(IGhost p) {
        this.close((IEntity)p);
    }

    public void close(IInterface p) {
        this.close((IEntity)p);
    }

    public void close(IPatternModel p) {
        this.close((IAbstractModel)p);
    }

    public String getCode() {
        return this.buffer.toString();
    }

    public String getName() {
        return "Dotty";
    }

    public void open(IAbstractLevelModel p) {
        this.open((IAbstractModel)p);
    }

    private void open(IAbstractModel p) {
        this.buffer.append("digraph G {\n");
    }

    public void open(IClass p) {
        this.open((IEntity)p);
        if ((this.visibleElements & 0x20000) == 131072) {
            this.addHierarchyRelationship(p.listOfImplementedEntities(), "Implements");
            this.addHierarchyRelationship(p.listOfInheritedActors(), "Inherits");
        }
    }

    private void open(IEntity anEntity) {
        this.currentEntityName = DottyGenerator.convertName(anEntity.getName());
        this.buffer.append('\t');
        this.buffer.append(this.currentEntityName);
        if (anEntity instanceof IGhost) {
            this.buffer.append(" [shape=box,label=\"");
            this.buffer.append(anEntity.getName());
            this.buffer.append("\",color=lightgray];\n");
        } else {
            this.buffer.append(" [shape=box,label=\"");
            this.buffer.append(anEntity.getName());
            this.buffer.append("\"];\n");
        }
    }

    public void open(IGhost p) {
        if ((this.visibleElements & 0x8000) == 32768) {
            this.open((IEntity)p);
        }
    }

    public void open(IInterface p) {
        this.open((IEntity)p);
        if ((this.visibleElements & 0x20000) == 131072) {
            this.addHierarchyRelationship(p.listOfInheritedActors(), "Inherits");
        }
    }

    public void open(IPatternModel p) {
        this.open((IAbstractModel)p);
    }

    public void reset() {
        this.buffer.setLength(0);
    }

    public void visit(IAggregation p) {
        if ((this.visibleElements & 2) == 2) {
            this.addRelationshipName(p, this.aggregations);
        }
    }

    public void visit(IAssociation p) {
        if ((this.visibleElements & 8) == 8) {
            this.addRelationshipName(p, this.associations);
        }
    }

    public void visit(IComposition p) {
        if ((this.visibleElements & 0x20) == 32) {
            this.addRelationshipName(p, this.compositions);
        }
    }

    public void visit(IConstructor p) {
    }

    public void visit(IContainerAggregation p) {
        if ((this.visibleElements & 0x80) == 128) {
            this.addRelationshipName(p, this.aggregations);
        }
    }

    public void visit(IContainerComposition p) {
        if ((this.visibleElements & 0x400) == 1024) {
            this.addRelationshipName(p, this.compositions);
        }
    }

    public void visit(ICreation p) {
        if ((this.visibleElements & 0x1000) == 4096) {
            this.addRelationshipName(p, this.creations);
        }
    }

    public void visit(IDelegatingMethod p) {
    }

    public void visit(IField p) {
    }

    public void visit(IMethod p) {
    }

    public void visit(IMethodInvocation aMethodInvocation) {
    }

    public void visit(IParameter p) {
    }

    public void visit(IUseRelationship p) {
        if ((this.visibleElements & 0x100000) == 0x100000) {
            this.addRelationshipName(p, this.uses);
        }
    }
}

