/*
 * Decompiled with CFR 0.152.
 */
package ptidej.ui.extension.repository;

import infovis.Column;
import infovis.Graph;
import infovis.Table;
import infovis.column.StringColumn;
import infovis.graph.DefaultGraph;
import infovis.graph.io.GraphReaderFactory;
import infovis.graph.visualization.MatrixVisualization;
import infovis.io.AbstractReader;
import infovis.io.AbstractReaderFactory;
import infovis.panel.ControlPanel;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JFrame;
import ptidej.ui.Representation;
import ptidej.ui.event.SourceEvent;
import ptidej.ui.extension.Extension;
import ptidej.ui.extension.repository.CSVGraphReader;
import ptidej.ui.extension.repository.InfoVisMatrixExampleGraphGenerator;

public final class InfoVisMatrixExample
extends JFrame
implements Extension {
    private static StringColumn getStringColumn(Table t, int index) {
        StringColumn ret = null;
        int i = 0;
        while (i < t.getColumnCount()) {
            ret = StringColumn.getColumn((Table)t, (int)i);
            if (ret != null && !ret.isInternal() && index-- == 0) {
                return ret;
            }
            ++i;
        }
        return null;
    }

    public InfoVisMatrixExample() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                ((Component)InfoVisMatrixExample.this).setVisible(false);
            }

            public void windowClosing(WindowEvent e) {
                this.windowClosed(e);
            }
        });
    }

    private void createFrame(Representation representation) {
        ((Component)this).setVisible(false);
        this.setTitle(this.getName());
        this.getContentPane().removeAll();
        InfoVisMatrixExampleGraphGenerator walker = new InfoVisMatrixExampleGraphGenerator(representation.getSourceGraph().getVisibleElements());
        representation.getSourceModel().walk(walker);
        String path = String.valueOf(System.getProperty("user.dir")) + File.separatorChar + "Temp.graph";
        try {
            FileWriter writer = new FileWriter(path);
            writer.write(walker.getResult().toString());
            writer.close();
            GraphReaderFactory.sharedInstance().add((AbstractReaderFactory.Creator)new AbstractReaderFactory.AbstractCreator(".graph"){

                public AbstractReader doCreate(String name, Table table, boolean decompress) throws IOException, FileNotFoundException {
                    return new CSVGraphReader(this.open(name, decompress), name, (Table)GraphReaderFactory.getGraph((Table)table));
                }
            });
            DefaultGraph g = new DefaultGraph();
            AbstractReader reader = GraphReaderFactory.createReader((String)path, (Graph)g);
            if (reader.load()) {
                MatrixVisualization visualization = new MatrixVisualization((Graph)g);
                visualization.setVertexLabelColumn((Column)InfoVisMatrixExample.getStringColumn(g.getEdgeTable(), 0));
                ControlPanel control = (ControlPanel)visualization.createDefaultControls();
                this.getContentPane().add((Component)control);
                this.pack();
                ((Component)this).setVisible(true);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public String getName() {
        return "Adjacency matrix (InfoVis)";
    }

    public void invoke(Representation representation) {
        this.createFrame(representation);
    }

    public void sourceStateChanged(SourceEvent sourceEvent) {
        if (this.isVisible()) {
            this.createFrame(sourceEvent.getRepresentation());
        }
    }
}

