/*
 * Decompiled with CFR 0.152.
 */
package ptidej.ui.extension.repository;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import padl.kernel.IAbstractLevelModel;
import padl.kernel.IAggregation;
import padl.kernel.IAssociation;
import padl.kernel.IClass;
import padl.kernel.IComposition;
import padl.kernel.IConstructor;
import padl.kernel.IContainerAggregation;
import padl.kernel.IContainerComposition;
import padl.kernel.ICreation;
import padl.kernel.IDelegatingMethod;
import padl.kernel.IEntity;
import padl.kernel.IField;
import padl.kernel.IGhost;
import padl.kernel.IInterface;
import padl.kernel.IMethod;
import padl.kernel.IMethodInvocation;
import padl.kernel.IParameter;
import padl.kernel.IPatternModel;
import padl.kernel.IRelationship;
import padl.kernel.IUseRelationship;
import padl.kernel.IWalker;

public final class InfoVisMatrixExampleGraphGenerator
implements IWalker {
    private static final int AGGREGATION_WEIGHT = 3;
    private static final int ASSOCIATION_WEIGHT = 2;
    private static final int COMPOSITION_WEIGHT = 4;
    private static final int KNOWLEDGE_WEIGHT = 1;
    private static final char SEPARATOR_CHAR = '#';
    private static final int ZERO_WEIGHT = 0;
    private IEntity enclosingPEntity;
    private Map interClassRelationships = new HashMap();
    private final int visibleElements;

    public InfoVisMatrixExampleGraphGenerator(int visibleElements) {
        this.visibleElements = visibleElements;
    }

    private void addKey(IRelationship relationship, int weight) {
        if (!(this.enclosingPEntity instanceof IGhost) && !(relationship.getTargetActor() instanceof IGhost)) {
            StringBuffer relationshipNameBuffer = new StringBuffer(this.enclosingPEntity.getName());
            relationshipNameBuffer.append('#');
            relationshipNameBuffer.append(relationship.getTargetActor().getName());
            String relationshipName = relationshipNameBuffer.toString();
            if (this.interClassRelationships.containsKey(relationshipName)) {
                int oldWeight = (Integer)this.interClassRelationships.get(relationshipName);
                this.interClassRelationships.put(relationshipName, new Integer(oldWeight + weight));
            } else {
                this.interClassRelationships.put(relationshipName, new Integer(weight));
            }
        }
    }

    public void close(IAbstractLevelModel p) {
    }

    public void close(IClass p) {
        this.enclosingPEntity = null;
    }

    public void close(IGhost p) {
        this.enclosingPEntity = null;
    }

    public void close(IInterface p) {
        this.enclosingPEntity = null;
    }

    public void close(IPatternModel p) {
    }

    public String getName() {
        return "Graph (InfoVis MatricExample)";
    }

    public Object getResult() {
        StringBuffer buffer = new StringBuffer();
        Iterator iterator = this.interClassRelationships.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            buffer.append(key.replace('#', ' '));
            buffer.append(' ');
            buffer.append(this.interClassRelationships.get(key));
            buffer.append('\n');
        }
        return buffer.toString();
    }

    public void open(IAbstractLevelModel p) {
        this.reset();
    }

    public void open(IClass p) {
        this.enclosingPEntity = p;
    }

    public void open(IGhost p) {
        this.enclosingPEntity = p;
    }

    public void open(IInterface p) {
        this.enclosingPEntity = p;
    }

    public void open(IPatternModel p) {
        this.reset();
    }

    public void reset() {
        this.interClassRelationships.clear();
    }

    public void visit(IAggregation p) {
        if ((this.visibleElements & 2) == 2) {
            this.addKey(p, 3);
        } else {
            this.addKey(p, 0);
        }
    }

    public void visit(IAssociation p) {
        if ((this.visibleElements & 8) == 8) {
            this.addKey(p, 2);
        } else {
            this.addKey(p, 0);
        }
    }

    public void visit(IComposition p) {
        if ((this.visibleElements & 0x20) == 32) {
            this.addKey(p, 4);
        } else {
            this.addKey(p, 0);
        }
    }

    public void visit(IConstructor p) {
    }

    public void visit(IContainerAggregation p) {
        if ((this.visibleElements & 0x80) == 128) {
            this.addKey(p, 3);
        } else {
            this.addKey(p, 0);
        }
    }

    public void visit(IContainerComposition p) {
        if ((this.visibleElements & 0x400) == 1024) {
            this.addKey(p, 4);
        } else {
            this.addKey(p, 0);
        }
    }

    public void visit(ICreation p) {
    }

    public void visit(IDelegatingMethod p) {
    }

    public void visit(IField p) {
    }

    public void visit(IMethod p) {
    }

    public void visit(IMethodInvocation aMethodInvocation) {
    }

    public void visit(IParameter p) {
    }

    public void visit(IUseRelationship p) {
        if ((this.visibleElements & 0x100000) == 0x100000) {
            this.addKey(p, 1);
        } else {
            this.addKey(p, 0);
        }
    }
}

