/*
 * Decompiled with CFR 0.152.
 */
package ptidej.ui.extension.repository;

import fr.emn.oadymppac.graph.AdjacencyMatrixRowColumn;
import fr.emn.oadymppac.graph.EdgeWeightGetter;
import fr.emn.oadymppac.graph.NamedGraphDelegator;
import fr.emn.oadymppac.graph.RandomGraphLoader;
import fr.emn.oadymppac.graph.WeightedEdgeWeight;
import fr.emn.oadymppac.widgets.AdjacencyMatrixControlPanel;
import fr.emn.oadymppac.widgets.GLAdjacencyMatrix;
import fr.emn.oadymppac.widgets.IcicleTreeBrowser;
import fr.emn.oadymppac.widgets.JClusterManipulator;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import ptidej.ui.Representation;
import ptidej.ui.event.SourceEvent;
import ptidej.ui.extension.Extension;
import ptidej.ui.extension.repository.OADymPPaCGraphGenerator;
import salvo.jesus.graph.DirectedGraphImpl;
import salvo.jesus.graph.Graph;

public final class OADymPPaC
extends JFrame
implements Extension {
    public OADymPPaC() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                ((Component)OADymPPaC.this).setVisible(false);
            }

            public void windowClosing(WindowEvent e) {
                this.windowClosed(e);
            }
        });
    }

    private void createFrame(Representation representation) {
        ((Component)this).setVisible(false);
        this.setTitle(this.getName());
        this.getContentPane().removeAll();
        NamedGraphDelegator graph = new NamedGraphDelegator((Graph)new DirectedGraphImpl());
        OADymPPaCGraphGenerator walker = new OADymPPaCGraphGenerator();
        representation.getSourceModel().walk(walker);
        String path = String.valueOf(System.getProperty("user.dir")) + File.separatorChar + "Temp.graph";
        try {
            FileWriter writer = new FileWriter(path);
            writer.write(walker.getResult().toString());
            writer.close();
            RandomGraphLoader gl = new RandomGraphLoader();
            gl.load(new URL("file:" + path), graph);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        AdjacencyMatrixRowColumn row = new AdjacencyMatrixRowColumn(graph);
        row.populateMatrix();
        AdjacencyMatrixRowColumn column = new AdjacencyMatrixRowColumn(graph);
        column.populateMatrix();
        GLAdjacencyMatrix glmatrix = new GLAdjacencyMatrix(row, column, 600, 800);
        glmatrix.setWeightGetter((EdgeWeightGetter)new WeightedEdgeWeight(20.0f));
        AdjacencyMatrixControlPanel control = new AdjacencyMatrixControlPanel(glmatrix, (IcicleTreeBrowser)new JClusterManipulator(), (IcicleTreeBrowser)new JClusterManipulator());
        glmatrix.setVisibleEdges(control.getVisibleEdgesModel());
        JSplitPane mainSplitPane = new JSplitPane(1);
        this.getContentPane().add(mainSplitPane);
        mainSplitPane.setLeftComponent((Component)glmatrix);
        mainSplitPane.setContinuousLayout(false);
        mainSplitPane.setResizeWeight(0.8);
        mainSplitPane.setRightComponent((Component)control);
        mainSplitPane.setDividerLocation(600);
        mainSplitPane.setResizeWeight(1.0);
        this.pack();
        ((Component)this).setVisible(true);
    }

    public String getName() {
        return "Adjacency matrix (OADymPPaC)";
    }

    public void invoke(Representation representation) {
        this.createFrame(representation);
    }

    public void sourceStateChanged(SourceEvent sourceEvent) {
        if (this.isVisible()) {
            this.createFrame(sourceEvent.getRepresentation());
        }
    }
}

