/*
 * Decompiled with CFR 0.152.
 */
package ptidej.ui.extension.repository;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.ScrollPane;
import java.awt.TextArea;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import padl.kernel.IAbstractModel;
import ptidej.ui.Representation;
import ptidej.ui.event.SourceEvent;
import ptidej.ui.extension.Extension;
import ptidej.ui.extension.repository.POMCalculator;

public final class POM
extends Frame
implements Extension {
    private static final POMCalculator pomCalculator = new POMCalculator();
    private TextArea textArea;

    public POM() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                ((Component)POM.this).setVisible(false);
            }

            public void windowClosing(WindowEvent e) {
                this.windowClosed(e);
            }
        });
    }

    private void computeMetrics(IAbstractModel model) {
        model.walk(pomCalculator);
        this.textArea.setText((String)pomCalculator.getResult());
    }

    public String getName() {
        return "POM-based metrics";
    }

    public void invoke(Representation representation) {
        ((Component)this).setSize(new Dimension(300, 500));
        ((Component)this).setLocation(this.getX() + 50, this.getY() + 50);
        this.setTitle(this.getName());
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setBackground(Color.lightGray);
        scrollPane.getHAdjustable().setUnitIncrement(20);
        scrollPane.getVAdjustable().setUnitIncrement(20);
        this.add(scrollPane);
        this.textArea = new TextArea();
        scrollPane.add(this.textArea);
        this.computeMetrics(representation.getSourceModel());
        ((Component)this).setVisible(true);
    }

    public void sourceStateChanged(SourceEvent sourceEvent) {
        if (this.isVisible()) {
            this.computeMetrics(sourceEvent.getRepresentation().getSourceModel());
            this.validate();
            this.repaint();
        }
    }
}

