/*
 * Decompiled with CFR 0.152.
 */
package ptidej.ui.extension.repository;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JFrame;
import ptidej.ui.Representation;
import ptidej.ui.event.SourceEvent;
import ptidej.ui.extension.Extension;
import ptidej.ui.extension.repository.UMLScriptGenerator;
import util.io.OutputMonitor;

public final class UMLScript
extends JFrame
implements Extension {
    public UMLScript() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                ((Component)UMLScript.this).setVisible(false);
            }

            public void windowClosing(WindowEvent e) {
                this.windowClosed(e);
            }
        });
    }

    private void createFrame(Representation representation) {
        ((Component)this).setVisible(false);
        this.getContentPane().removeAll();
        UMLScriptGenerator builder = new UMLScriptGenerator(representation.getSourceGraph().getVisibleElements());
        representation.getSourceModel().generate(builder);
        String path = String.valueOf(System.getProperty("user.dir")) + File.separatorChar + "Temp.uml";
        try {
            FileWriter writer = new FileWriter(path);
            writer.write(builder.getCode().toString());
            writer.close();
            StringBuffer commandLine = new StringBuffer();
            commandLine.append("SugiBib");
            commandLine.append(" \"");
            commandLine.append(path);
            commandLine.append('\"');
            final Process process = Runtime.getRuntime().exec(commandLine.toString());
            OutputMonitor errorStreamMonitor = new OutputMonitor("UMLScript Stream Monitor", "", process.getErrorStream(), System.out);
            errorStreamMonitor.start();
            OutputMonitor inputStreamMonitor = new OutputMonitor("UMLScript Input Stream Monitor", "", process.getInputStream(), System.out);
            inputStreamMonitor.start();
            new Thread(new Runnable(){

                public void run() {
                    try {
                        process.waitFor();
                    }
                    catch (InterruptedException ie) {
                        ie.printStackTrace();
                    }
                    if (process.exitValue() != 0) {
                        try {
                            while (process.getErrorStream().available() > 0) {
                                System.out.print((char)process.getErrorStream().read());
                            }
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                }
            }).start();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public String getName() {
        return "SugiBib";
    }

    public void invoke(Representation representation) {
        this.createFrame(representation);
    }

    public void sourceStateChanged(SourceEvent sourceEvent) {
        if (this.isVisible()) {
            this.createFrame(sourceEvent.getRepresentation());
        }
    }
}

