/*
 * Decompiled with CFR 0.152.
 */
package ptidej.ui.extension.repository;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import padl.kernel.IAbstractLevelModel;
import padl.kernel.IAbstractModel;
import padl.kernel.IAggregation;
import padl.kernel.IAssociation;
import padl.kernel.IClass;
import padl.kernel.IComposition;
import padl.kernel.IConstructor;
import padl.kernel.IContainerAggregation;
import padl.kernel.IContainerComposition;
import padl.kernel.ICreation;
import padl.kernel.IDelegatingMethod;
import padl.kernel.IElement;
import padl.kernel.IEntity;
import padl.kernel.IField;
import padl.kernel.IGenerator;
import padl.kernel.IGhost;
import padl.kernel.IInterface;
import padl.kernel.IMethod;
import padl.kernel.IMethodInvocation;
import padl.kernel.IParameter;
import padl.kernel.IPatternModel;
import padl.kernel.IRelationship;
import padl.kernel.IUseRelationship;

public final class UMLScriptGenerator
implements IGenerator {
    private final StringBuffer buffer = new StringBuffer();
    private IAbstractModel currentModel;
    private final int visibleElements;

    private static String computeMethodName(IEntity entity, IConstructor method) {
        if (method.getName().startsWith("<")) {
            return UMLScriptGenerator.convertName(entity.getName());
        }
        return UMLScriptGenerator.convertName(method.getName());
    }

    private static String computeMethodName(IEntity entity, IRelationship relationship) {
        String name = relationship.getName();
        if (name.startsWith("<")) {
            return String.valueOf(UMLScriptGenerator.convertName(entity.getName())) + name.substring(name.lastIndexOf(62) + 1);
        }
        return UMLScriptGenerator.convertName(name);
    }

    private static String computeVisibility(IElement anElement) {
        StringBuffer visibility = new StringBuffer(4);
        if ((anElement.getVisibility() & 1) == 1) {
            visibility.append("+ ");
        } else if ((anElement.getVisibility() & 4) == 4) {
            visibility.append("# ");
        } else if ((anElement.getVisibility() & 2) == 2) {
            visibility.append("- ");
        }
        if ((anElement.getVisibility() & 8) == 8) {
            visibility.append("$ ");
        }
        return visibility.toString();
    }

    private static String convertName(String entityName) {
        return entityName.replace('$', '.');
    }

    private static String convertType(String javaType) {
        StringBuffer buffer = new StringBuffer(javaType.length());
        int index = 0;
        while ((index = javaType.indexOf(91, index + 1)) != -1) {
            buffer.append("array [*] of ");
        }
        index = javaType.indexOf(91);
        if (index == -1) {
            index = javaType.length();
        }
        buffer.append(UMLScriptGenerator.convertName(javaType).substring(0, index));
        return buffer.toString();
    }

    private static List findAllDirectSubEntities(IAbstractModel model, IEntity superEntity) {
        Iterator iterator = model.listOfActors().iterator();
        ArrayList<IEntity> listOfSubEntities = new ArrayList<IEntity>(1);
        while (iterator.hasNext()) {
            IEntity entity = (IEntity)iterator.next();
            if (!entity.listOfInheritedActors().contains(superEntity) && (!(entity instanceof IClass) || !((IClass)entity).listOfImplementedEntities().contains(superEntity))) continue;
            listOfSubEntities.add(entity);
        }
        return listOfSubEntities;
    }

    public UMLScriptGenerator(int visibleElements) {
        this.visibleElements = visibleElements;
    }

    public void close(IAbstractLevelModel p) {
        this.buffer.append("\nEND DIAGRAM");
    }

    public void close(IClass p) {
        this.buffer.append("\n\tCLASS { *backgroundColor = 255255204 } ");
        this.buffer.append(UMLScriptGenerator.convertName(p.getName()));
        this.buffer.append('\n');
        this.generateRelations(p);
    }

    public void close(IGhost p) {
        if ((this.visibleElements & 0x8000) == 32768) {
            this.buffer.append("\n\tCLASS { *Color = gray } ");
            this.buffer.append(UMLScriptGenerator.convertName(p.getName()));
            this.buffer.append('\n');
            this.generateRelations(p);
        }
    }

    public void close(IInterface p) {
        this.buffer.append("\n\tCLASS << Interface >> { *backgroundColor = 255255204 } ");
        this.buffer.append(UMLScriptGenerator.convertName(p.getName()));
        this.buffer.append('\n');
        this.generateRelations(p);
    }

    public void close(IPatternModel p) {
        this.buffer.append("\nEND DIAGRAM");
    }

    private void generateRelations(IEntity entity) {
        StringBuffer attributes = new StringBuffer(0);
        StringBuffer operations = new StringBuffer(0);
        HashSet<String> relations = new HashSet<String>(0);
        StringBuffer uniqueRelations = new StringBuffer(0);
        Iterator iterator = entity.listOfActors().iterator();
        while (iterator.hasNext()) {
            IUseRelationship knowledge;
            IElement element = (IElement)iterator.next();
            if (element instanceof IField && (this.visibleElements & 0x2000) == 8192) {
                IField field = (IField)element;
                if (attributes.length() > 0) {
                    attributes.append(",\n");
                }
                attributes.append("\t\t\t");
                attributes.append(UMLScriptGenerator.computeVisibility(field));
                attributes.append(UMLScriptGenerator.convertName(field.getName()));
                attributes.append(" : ");
                attributes.append(UMLScriptGenerator.convertType(field.getType()));
                continue;
            }
            if (element instanceof IConstructor && (this.visibleElements & 0x40000) == 262144) {
                IConstructor method = (IConstructor)element;
                if (operations.length() > 0) {
                    operations.append(",\n");
                }
                operations.append("\t\t\t");
                operations.append(UMLScriptGenerator.computeVisibility(method));
                operations.append(UMLScriptGenerator.computeMethodName(entity, method));
                operations.append('(');
                Iterator elements = method.listOfActors().iterator();
                boolean hasPredecessor = false;
                while (elements.hasNext()) {
                    IElement e = (IElement)elements.next();
                    if (!(e instanceof IParameter)) continue;
                    if (hasPredecessor) {
                        operations.append(", ");
                    } else {
                        hasPredecessor = true;
                    }
                    operations.append(e.getName());
                    operations.append(" : ");
                    operations.append(UMLScriptGenerator.convertType(((IParameter)e).getType()));
                }
                operations.append(')');
                if (element instanceof IMethod) continue;
                operations.append(" : ");
                operations.append(UMLScriptGenerator.convertType(((IMethod)method).getReturnType()));
                continue;
            }
            if (element instanceof IContainerAggregation && (this.visibleElements & 0x80) == 128) {
                IContainerAggregation containerAggregation = (IContainerAggregation)element;
                if (this.isGhost(containerAggregation.getTargetActor()) || !relations.add("ContainerAggregation to " + containerAggregation.getTargetActor())) continue;
                uniqueRelations.append("\t\t\t");
                uniqueRelations.append("<< Container >> ASSOC TO ");
                if (containerAggregation.getCardinality() > 1) {
                    uniqueRelations.append("[*] ");
                }
                uniqueRelations.append("aggregate ROLE ");
                uniqueRelations.append(UMLScriptGenerator.computeMethodName(entity, containerAggregation));
                uniqueRelations.append(" '");
                uniqueRelations.append(UMLScriptGenerator.convertName(containerAggregation.getTargetActor().getName()));
                uniqueRelations.append("'\n");
                continue;
            }
            if (element instanceof IContainerComposition && (this.visibleElements & 0x400) == 1024) {
                IContainerComposition containerComposition = (IContainerComposition)element;
                if (this.isGhost(containerComposition.getTargetActor()) || !relations.add("ContainerComposition to " + containerComposition.getTargetActor())) continue;
                uniqueRelations.append("\t\t\t");
                uniqueRelations.append("<< Container >> ASSOC TO ");
                if (containerComposition.getCardinality() > 1) {
                    uniqueRelations.append("[*] ");
                }
                uniqueRelations.append("composite ROLE ");
                uniqueRelations.append(UMLScriptGenerator.computeMethodName(entity, containerComposition));
                uniqueRelations.append(" '");
                uniqueRelations.append(UMLScriptGenerator.convertName(containerComposition.getTargetActor().getName()));
                uniqueRelations.append("'\n");
                continue;
            }
            if (element instanceof IAggregation && (this.visibleElements & 2) == 2) {
                IAggregation aggregation = (IAggregation)element;
                if (this.isGhost(aggregation.getTargetActor()) || !relations.add("Aggregation to " + aggregation.getTargetActor())) continue;
                uniqueRelations.append("\t\t\t");
                uniqueRelations.append("ASSOC TO ");
                if (aggregation.getCardinality() > 1) {
                    uniqueRelations.append("[*] ");
                }
                uniqueRelations.append("aggregate ROLE ");
                uniqueRelations.append(UMLScriptGenerator.computeMethodName(entity, aggregation));
                uniqueRelations.append(" '");
                uniqueRelations.append(UMLScriptGenerator.convertName(aggregation.getTargetActor().getName()));
                uniqueRelations.append("'\n");
                continue;
            }
            if (element instanceof IComposition && (this.visibleElements & 0x20) == 32) {
                IComposition composition = (IComposition)element;
                if (this.isGhost(composition.getTargetActor()) || !relations.add("Composition to " + composition.getTargetActor())) continue;
                uniqueRelations.append("\t\t\t");
                uniqueRelations.append("ASSOC TO ");
                if (composition.getCardinality() > 1) {
                    uniqueRelations.append("[*] ");
                }
                uniqueRelations.append("composite ROLE ");
                uniqueRelations.append(UMLScriptGenerator.computeMethodName(entity, composition));
                uniqueRelations.append(" '");
                uniqueRelations.append(UMLScriptGenerator.convertName(composition.getTargetActor().getName()));
                uniqueRelations.append("'\n");
                continue;
            }
            if (element instanceof IAssociation && (this.visibleElements & 8) == 8) {
                IAssociation association = (IAssociation)element;
                if (this.isGhost(association.getTargetActor()) || !relations.add("Association to " + association.getTargetActor())) continue;
                uniqueRelations.append("\t\t\t");
                uniqueRelations.append("ASSOC TO ");
                if (association.getCardinality() > 1) {
                    uniqueRelations.append("[*] ");
                }
                uniqueRelations.append("ROLE ");
                uniqueRelations.append(UMLScriptGenerator.computeMethodName(entity, association));
                uniqueRelations.append(" '");
                uniqueRelations.append(UMLScriptGenerator.convertName(association.getTargetActor().getName()));
                uniqueRelations.append("'\n");
                continue;
            }
            if (element instanceof ICreation && (this.visibleElements & 0x1000) == 4096) {
                ICreation creation = (ICreation)element;
                if (this.isGhost(creation.getTargetActor()) || !relations.add("Creation of " + creation.getTargetActor())) continue;
                uniqueRelations.append("\t\t\t");
                uniqueRelations.append("<< Creation >> DEPENDS ");
                uniqueRelations.append(UMLScriptGenerator.computeMethodName(entity, creation));
                uniqueRelations.append(" ON '");
                uniqueRelations.append(UMLScriptGenerator.convertName(creation.getTargetActor().getName()));
                uniqueRelations.append("'\n");
                continue;
            }
            if (!(element instanceof IUseRelationship) || (this.visibleElements & 0x100000) != 0x100000 || this.isGhost((knowledge = (IUseRelationship)element).getTargetActor()) || !relations.add("Knowledge of " + knowledge.getTargetActor())) continue;
            uniqueRelations.append("\t\t\t");
            uniqueRelations.append("<< Knowledge >> DEPENDS ");
            uniqueRelations.append(UMLScriptGenerator.computeMethodName(entity, knowledge));
            uniqueRelations.append(" ON '");
            uniqueRelations.append(UMLScriptGenerator.convertName(knowledge.getTargetActor().getName()));
            uniqueRelations.append("'\n");
        }
        if ((this.visibleElements & 0x20000) == 131072) {
            iterator = UMLScriptGenerator.findAllDirectSubEntities(this.currentModel, entity).iterator();
            while (iterator.hasNext()) {
                uniqueRelations.append("\t\t\tGENERALIZE '");
                uniqueRelations.append(UMLScriptGenerator.convertName(((IEntity)iterator.next()).getName()));
                uniqueRelations.append("'\n");
            }
        }
        if (attributes.length() > 0) {
            this.buffer.append("\t\tATTRIBUTES\n");
            this.buffer.append(attributes);
            this.buffer.append('\n');
        }
        if (operations.length() > 0) {
            this.buffer.append("\t\tOPERATIONS\n");
            this.buffer.append(operations);
            this.buffer.append('\n');
        }
        if (uniqueRelations.length() > 0) {
            this.buffer.append("\t\tRELATIONS\n");
            this.buffer.append(uniqueRelations);
            this.buffer.append("\t\tEND\n");
        }
    }

    public String getCode() {
        return this.buffer.toString();
    }

    public String getName() {
        return "UMLScript";
    }

    private boolean isGhost(IEntity entity) {
        return entity instanceof IGhost;
    }

    public void open(IAbstractLevelModel p) {
        this.open((IAbstractModel)p);
    }

    private void open(IAbstractModel p) {
        this.buffer.append("UMLscript VERSION 1 MINOR 13\n{ *inheritancesize = 10,\n  *associationsize = 100,\n  *backgroundColor = 255255255,\n  *defaultNodeColor = 000000000,\n  *defaultEdgeColor = 000000000,\n  *diamondxsize = 50 }\nDIAGRAM ");
        this.currentModel = p;
    }

    public void open(IClass p) {
    }

    public void open(IGhost p) {
    }

    public void open(IInterface p) {
    }

    public void open(IPatternModel p) {
        this.open((IAbstractModel)p);
    }

    public void reset() {
        this.buffer.setLength(0);
    }

    public void visit(IAggregation p) {
    }

    public void visit(IAssociation p) {
    }

    public void visit(IComposition p) {
    }

    public void visit(IConstructor p) {
    }

    public void visit(IContainerAggregation p) {
    }

    public void visit(IContainerComposition p) {
    }

    public void visit(ICreation p) {
    }

    public void visit(IDelegatingMethod p) {
    }

    public void visit(IField p) {
    }

    public void visit(IMethod p) {
    }

    public void visit(IMethodInvocation aMethodInvocation) {
    }

    public void visit(IParameter p) {
    }

    public void visit(IUseRelationship p) {
    }
}

