/*
 * Decompiled with CFR 0.152.
 */
package ptidej.ui.kernel;

import java.awt.Point;
import ptidej.ui.Constants;
import ptidej.ui.RGB;
import ptidej.ui.kernel.Association;
import ptidej.ui.kernel.Entity;
import ptidej.ui.kernel.Ghost;
import ptidej.ui.primitive.PrimitiveFactory;

public abstract class AbstractAggregation
extends Association {
    public AbstractAggregation(PrimitiveFactory primitiveFactory, String name, int cardinality, Entity origin, Entity target) {
        super(primitiveFactory, name, cardinality, origin, target);
    }

    public final void build() {
        super.build();
        Point intersectionPoint = this.findIntersectionPointWithOrigin();
        if (intersectionPoint != null) {
            RGB color = this.getTargetDEntity() instanceof Ghost ? Constants.GHOST_ENTITY_DISPLAY_COLOR : Constants.FOREGROUND_COLOR;
            this.aacSymbol = this.getPrimitiveFactory().createAggregationSymbol(intersectionPoint, this.getDimension(), this.getDirection(), color);
        }
    }

    public final String getName() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getSymbol());
        buffer.append(this.getAssociationCardinality() > 1 ? "* " : " ");
        buffer.append(this.getTargetDEntity().getName());
        return buffer.toString();
    }

    public abstract String getSymbol();
}

