/*
 * Decompiled with CFR 0.152.
 */
package ptidej.ui.kernel;

import java.awt.Point;
import ptidej.ui.Constants;
import ptidej.ui.RGB;
import ptidej.ui.kernel.Entity;
import ptidej.ui.kernel.Ghost;
import ptidej.ui.kernel.GraphicElement;
import ptidej.ui.primitive.Line;
import ptidej.ui.primitive.PrimitiveFactory;
import ptidej.ui.primitive.Symbol;

public class Association
extends GraphicElement {
    private final String associationTypeName;
    private final String associationFieldName;
    private final int associationCardinality;
    private Line line;
    private Symbol arrowSymbol;
    protected Symbol aacSymbol;

    public Association(PrimitiveFactory primitiveFactory, String name, int cardinality, Entity origin, Entity target) {
        super(primitiveFactory, origin, target);
        this.associationFieldName = name;
        this.associationTypeName = target.getName();
        this.associationCardinality = cardinality;
    }

    public void build() {
        RGB color = this.getTargetDEntity() instanceof Ghost ? Constants.GHOST_ENTITY_DISPLAY_COLOR : Constants.FOREGROUND_COLOR;
        Point intersectionPoint = null;
        this.line = this.getPrimitiveFactory().createLine(this.getPosition(), this.getDimension(), color);
        intersectionPoint = this.findIntersectionPointWithTarget();
        if (intersectionPoint != null) {
            this.arrowSymbol = this.getPrimitiveFactory().createArrowSymbol(intersectionPoint, this.getDimension(), -this.getDirection(), color);
        }
        intersectionPoint = this.findIntersectionPointWithOrigin();
    }

    protected int getAssociationCardinality() {
        return this.associationCardinality;
    }

    protected String getAssociationFieldName() {
        return this.associationFieldName;
    }

    protected String getAssociationTypeName() {
        return this.associationTypeName;
    }

    protected int getDirection() {
        return this.getPosition().y > this.getDestination().y ? 1 : -1;
    }

    public String getName() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("---->");
        buffer.append(this.getAssociationCardinality() > 1 ? "* " : " ");
        buffer.append(this.getTargetDEntity().getName());
        return buffer.toString();
    }

    protected final StringBuffer getTypeAndFieldNames() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getAssociationTypeName());
        buffer.append(" (");
        buffer.append(this.getAssociationFieldName());
        buffer.append(")");
        return buffer;
    }

    protected int getVisibility() {
        return 8;
    }

    public void paint(int xOffset, int yOffset) {
        if ((this.getVisibleElements() & this.getVisibility()) == this.getVisibility()) {
            this.line.paint(xOffset, yOffset);
            if (this.arrowSymbol != null) {
                this.arrowSymbol.paint(xOffset, yOffset);
            }
            if (this.aacSymbol != null) {
                this.aacSymbol.paint(xOffset, yOffset);
            }
        }
    }
}

