/*
 * Decompiled with CFR 0.152.
 */
package ptidej.ui.kernel;

import java.awt.Dimension;
import java.awt.Point;
import ptidej.ui.Constants;
import ptidej.ui.Drawable;
import ptidej.ui.event.MouseEvent;
import ptidej.ui.primitive.PrimitiveFactory;

public abstract class Constituent
implements Drawable {
    private PrimitiveFactory primitiveFactory;
    private Point position = new Point(Constants.DEFAULT_POSITION);
    private Dimension dimension = new Dimension(Constants.DEFAULT_DIMENSION);
    private int whatIsVisible;

    public Constituent(PrimitiveFactory primitiveFactory) {
        this.primitiveFactory = primitiveFactory;
    }

    public abstract void build();

    public Dimension getDimension() {
        return this.dimension;
    }

    public String getName() {
        return "Constituent (" + this.getClass() + ")";
    }

    public Point getPosition() {
        return this.position;
    }

    public PrimitiveFactory getPrimitiveFactory() {
        return this.primitiveFactory;
    }

    public int getVisibleElements() {
        return this.whatIsVisible;
    }

    public boolean processMouseEvent(MouseEvent me) {
        return false;
    }

    public final void setDimension(Dimension dimension) {
        this.dimension = dimension;
    }

    public final void setPosition(Point position) {
        this.position = position;
    }

    public void setVisibleElements(int visibility) {
        this.whatIsVisible = visibility;
    }

    public abstract boolean isSelected();

    public abstract void paint(int var1, int var2);

    public abstract void setSelected(boolean var1);
}

