/*
 * Decompiled with CFR 0.152.
 */
package ptidej.ui.kernel;

import java.awt.Point;
import padl.kernel.IDelegatingMethod;
import ptidej.ui.Constants;
import ptidej.ui.kernel.Entity;
import ptidej.ui.kernel.GraphicElement;
import ptidej.ui.primitive.DottedLine;
import ptidej.ui.primitive.PrimitiveFactory;
import ptidej.ui.primitive.Symbol;

public final class Delegation
extends GraphicElement {
    private IDelegatingMethod pDelegation;
    private DottedLine line;
    private Symbol arrowSymbol;

    protected Delegation(PrimitiveFactory primitiveFactory, Entity origin, Entity target, IDelegatingMethod pDelegation) {
        super(primitiveFactory, origin, target);
        this.pDelegation = pDelegation;
    }

    public void build() {
        this.line = this.getPrimitiveFactory().createDottedLine(this.getPosition(), this.getDimension(), Constants.FOREGROUND_COLOR);
        Point intersectionPoint = this.findIntersectionPointWithTarget();
        if (intersectionPoint != null) {
            this.arrowSymbol = this.getPrimitiveFactory().createArrowSymbol(intersectionPoint, this.getDimension(), -this.getDirection(), Constants.FOREGROUND_COLOR);
        }
    }

    protected int getDirection() {
        return this.getPosition().y > this.getDestination().y ? 1 : -1;
    }

    public String getName() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Delegation: ");
        buffer.append(this.pDelegation.getName());
        buffer.append("() -> ");
        buffer.append(this.pDelegation.getTargetAssoc().getTargetActor().getName());
        buffer.append('.');
        buffer.append(this.pDelegation.getTargetMethod().getName());
        buffer.append("()");
        return buffer.toString();
    }

    public void paint(int xOffset, int yOffset) {
        this.line.paint(xOffset, yOffset);
        if (this.arrowSymbol != null) {
            this.arrowSymbol.paint(xOffset, yOffset);
        }
    }
}

