/*
 * Decompiled with CFR 0.152.
 */
package ptidej.ui.kernel;

import java.awt.Dimension;
import java.awt.Point;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import padl.kernel.IAggregation;
import padl.kernel.IAssociation;
import padl.kernel.IComposition;
import padl.kernel.IConstituent;
import padl.kernel.IContainerAggregation;
import padl.kernel.IContainerComposition;
import padl.kernel.ICreation;
import padl.kernel.IDelegatingMethod;
import padl.kernel.IElement;
import padl.kernel.IEntity;
import padl.kernel.IField;
import padl.kernel.IGhost;
import padl.kernel.IInterface;
import padl.kernel.IMethod;
import padl.kernel.IUseRelationship;
import padl.util.Misc;
import ptidej.ui.Constants;
import ptidej.ui.VisibilityElement;
import ptidej.ui.event.MouseEvent;
import ptidej.ui.kernel.Aggregation;
import ptidej.ui.kernel.Association;
import ptidej.ui.kernel.Class;
import ptidej.ui.kernel.Composition;
import ptidej.ui.kernel.Constituent;
import ptidej.ui.kernel.ContainerAggregation;
import ptidej.ui.kernel.ContainerComposition;
import ptidej.ui.kernel.Creation;
import ptidej.ui.kernel.Delegation;
import ptidej.ui.kernel.Element;
import ptidej.ui.kernel.Field;
import ptidej.ui.kernel.Ghost;
import ptidej.ui.kernel.GraphicModel;
import ptidej.ui.kernel.Hierarchy;
import ptidej.ui.kernel.Interface;
import ptidej.ui.kernel.Knowledge;
import ptidej.ui.kernel.Method;
import ptidej.ui.primitive.Button;
import ptidej.ui.primitive.PrimitiveFactory;

public abstract class Entity
extends Constituent
implements VisibilityElement {
    private GraphicModel pattern;
    protected IEntity entity;
    private List listOfElements = new ArrayList();
    private Vector listOfHierarchies = new Vector();
    private boolean isSuper;
    private StringBuffer[] buttonTexts = new StringBuffer[5];
    private Button[] buttons = new Button[5];

    protected Entity(PrimitiveFactory primitiveFactory, GraphicModel currentPattern, IEntity pEntity) {
        super(primitiveFactory);
        this.pattern = currentPattern;
        this.entity = pEntity;
        int i = 0;
        while (i < this.buttons.length) {
            this.buttonTexts[i] = new StringBuffer();
            ++i;
        }
    }

    protected void addDElement(IEntity anEntity, IConstituent anElement) {
        Element aGraphicalElement = null;
        IEntity aTargetEntity = null;
        Entity aTargetGraphicalEntity = null;
        if (anElement instanceof IDelegatingMethod) {
            aTargetEntity = ((IDelegatingMethod)anElement).getTargetAssoc().getTargetActor();
            try {
                aTargetGraphicalEntity = this.findCorrespondingDEntity(aTargetEntity);
            }
            catch (NullPointerException npe) {
                aTargetGraphicalEntity = null;
            }
            if (aTargetEntity != null && aTargetGraphicalEntity != null) {
                aGraphicalElement = new Delegation(this.getPrimitiveFactory(), this.findCorrespondingDEntity(anEntity), aTargetGraphicalEntity, (IDelegatingMethod)anElement);
            }
        } else if (anElement instanceof IAssociation) {
            IAssociation association = (IAssociation)anElement;
            Entity origin = this.findCorrespondingDEntity(anEntity);
            aTargetEntity = association.getTargetActor();
            try {
                aTargetGraphicalEntity = this.findCorrespondingDEntity(aTargetEntity);
            }
            catch (NullPointerException npe) {
                aTargetGraphicalEntity = null;
            }
            if (origin != aTargetGraphicalEntity && origin != null && aTargetEntity != null && aTargetGraphicalEntity != null) {
                if (anElement instanceof IComposition) {
                    aGraphicalElement = new Composition(this.getPrimitiveFactory(), ((IComposition)anElement).getDisplayName(), ((IComposition)anElement).getCardinality(), origin, aTargetGraphicalEntity);
                } else if (anElement instanceof IAggregation) {
                    aGraphicalElement = new Aggregation(this.getPrimitiveFactory(), ((IAggregation)anElement).getDisplayName(), ((IAggregation)anElement).getCardinality(), origin, aTargetGraphicalEntity);
                } else if (anElement instanceof IContainerComposition) {
                    aGraphicalElement = new ContainerComposition(this.getPrimitiveFactory(), ((IContainerComposition)anElement).getDisplayName(), ((IContainerComposition)anElement).getCardinality(), origin, aTargetGraphicalEntity);
                } else if (anElement instanceof IContainerAggregation) {
                    aGraphicalElement = new ContainerAggregation(this.getPrimitiveFactory(), ((IContainerAggregation)anElement).getDisplayName(), ((IContainerAggregation)anElement).getCardinality(), origin, aTargetGraphicalEntity);
                } else if (anElement instanceof IAssociation) {
                    aGraphicalElement = new Association(this.getPrimitiveFactory(), ((IAssociation)anElement).getDisplayName(), ((IAssociation)anElement).getCardinality(), origin, aTargetGraphicalEntity);
                }
            }
        } else if (anElement instanceof ICreation) {
            aTargetEntity = ((ICreation)anElement).getTargetActor();
            try {
                aTargetGraphicalEntity = this.findCorrespondingDEntity(aTargetEntity);
            }
            catch (NullPointerException npe) {
                aTargetGraphicalEntity = null;
            }
            if (aTargetEntity != null && aTargetGraphicalEntity != null) {
                aGraphicalElement = new Creation(this.getPrimitiveFactory(), this.findCorrespondingDEntity(anEntity), ((ICreation)anElement).getDisplayName(), aTargetGraphicalEntity);
            }
        } else if (anElement instanceof IUseRelationship) {
            aTargetEntity = ((IUseRelationship)anElement).getTargetActor();
            try {
                aTargetGraphicalEntity = this.findCorrespondingDEntity(aTargetEntity);
            }
            catch (NullPointerException npe) {
                aTargetGraphicalEntity = null;
            }
            if (aTargetEntity != null && aTargetGraphicalEntity != null) {
                aGraphicalElement = new Knowledge(this.getPrimitiveFactory(), this.findCorrespondingDEntity(anEntity), ((IUseRelationship)anElement).getDisplayName(), aTargetGraphicalEntity);
            }
        } else if (anElement instanceof IMethod) {
            aGraphicalElement = new Method(this.getPrimitiveFactory(), (IMethod)anElement);
        } else if (anElement instanceof IField) {
            aGraphicalElement = new Field(this.getPrimitiveFactory(), (IField)anElement);
        }
        if (aGraphicalElement != null) {
            this.listOfElements.add(aGraphicalElement);
        }
    }

    protected void addDHierarchy(Hierarchy dHierarchy) {
        ((Entity)dHierarchy.getTargetDEntity()).isSuper(true);
        this.listOfHierarchies.addElement(dHierarchy);
    }

    public void build() {
        int i = 0;
        while (i < this.buttons.length) {
            this.buttonTexts[i].setLength(0);
            ++i;
        }
        if (this.entity instanceof IInterface) {
            this.buttonTexts[0].append("<<interface>>\n");
        }
        if ((this.getVisibleElements() & 0x4000) == 16384) {
            this.buttonTexts[0].append(this.entity.getDisplayName());
        } else {
            this.buttonTexts[0].append(Misc.computeSimpleName(this.entity.getDisplayName()));
        }
        if ((this.getVisibleElements() & 0x10000) == 65536) {
            i = 0;
            while (i < this.listOfHierarchies.size()) {
                this.buttonTexts[1].append(((Hierarchy)this.listOfHierarchies.elementAt(i)).getName());
                this.buttonTexts[1].append('\n');
                ++i;
            }
        }
        i = 0;
        while (i < this.listOfElements.size()) {
            String elementName;
            Element element = (Element)this.listOfElements.get(i);
            if (element instanceof Field) {
                if ((this.getVisibleElements() & 0x2000) == 8192) {
                    this.buttonTexts[3].append(element.toString());
                    this.buttonTexts[3].append('\n');
                }
            } else if (element instanceof Method || element instanceof Delegation) {
                if ((this.getVisibleElements() & 0x40000) == 262144) {
                    this.buttonTexts[4].append(element.toString());
                    this.buttonTexts[4].append('\n');
                }
            } else if (element instanceof Creation) {
                if ((this.getVisibleElements() & 0x800) == 2048 && ((Creation)element).getTargetDEntity() != null) {
                    elementName = String.valueOf(element.getName()) + '\n';
                    if (this.buttonTexts[2].toString().indexOf(elementName) == -1) {
                        this.buttonTexts[2].append(elementName);
                    }
                }
            } else if (element instanceof Knowledge) {
                if ((this.getVisibleElements() & 0x80000) == 524288 && ((Knowledge)element).getTargetDEntity() != null) {
                    elementName = String.valueOf(element.getName()) + '\n';
                    if (this.buttonTexts[2].toString().indexOf(elementName) == -1) {
                        this.buttonTexts[2].append(elementName);
                    }
                }
            } else if (element instanceof Composition) {
                if ((this.getVisibleElements() & 0x10) == 16 && ((Composition)element).getTargetDEntity() != null) {
                    elementName = String.valueOf(element.getName()) + '\n';
                    if (this.buttonTexts[2].toString().indexOf(elementName) == -1) {
                        this.buttonTexts[2].append(elementName);
                    }
                }
            } else if (element instanceof ContainerComposition) {
                if ((this.getVisibleElements() & 0x100) == 256 && ((ContainerComposition)element).getTargetDEntity() != null) {
                    elementName = String.valueOf(element.getName()) + '\n';
                    if (this.buttonTexts[2].toString().indexOf(elementName) == -1) {
                        this.buttonTexts[2].append(elementName);
                    }
                }
            } else if (element instanceof Aggregation) {
                if ((this.getVisibleElements() & 1) == 1 && ((Aggregation)element).getTargetDEntity() != null) {
                    elementName = String.valueOf(element.getName()) + '\n';
                    if (this.buttonTexts[2].toString().indexOf(elementName) == -1) {
                        this.buttonTexts[2].append(elementName);
                    }
                }
            } else if (element instanceof ContainerAggregation) {
                if ((this.getVisibleElements() & 0x40) == 64 && ((ContainerAggregation)element).getTargetDEntity() != null) {
                    elementName = String.valueOf(element.getName()) + '\n';
                    if (this.buttonTexts[2].toString().indexOf(elementName) == -1) {
                        this.buttonTexts[2].append(elementName);
                    }
                }
            } else if (element instanceof Association && (this.getVisibleElements() & 4) == 4 && ((Association)element).getTargetDEntity() != null) {
                elementName = String.valueOf(element.getName()) + '\n';
                if (this.buttonTexts[2].toString().indexOf(elementName) == -1) {
                    this.buttonTexts[2].append(elementName);
                }
            }
            ++i;
        }
        int xPos = this.getPosition().x;
        int yPos = this.getPosition().y;
        int maxWidth = 0;
        int i2 = 0;
        while (i2 < this.buttons.length) {
            this.buttons[i2] = null;
            if (this.buttonTexts[i2].length() > 0) {
                this.buttons[i2] = this.getPEntity() instanceof IGhost ? this.getPrimitiveFactory().createButton(this.buttonTexts[i2].toString(), new Point(xPos, yPos), i2 == 0, Constants.GHOST_ENTITY_DISPLAY_COLOR) : this.getPrimitiveFactory().createButton(this.buttonTexts[i2].toString(), new Point(xPos, yPos), i2 == 0, Constants.FOREGROUND_COLOR);
                maxWidth = Math.max(maxWidth, this.buttons[i2].getDimension().width);
                yPos += this.buttons[i2].getDimension().height;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.buttons.length) {
            if (this.buttons[i2] != null) {
                this.buttons[i2].setDimension(new Dimension(maxWidth, this.buttons[i2].getDimension().height));
            }
            ++i2;
        }
        this.setDimension(new Dimension(maxWidth, yPos - this.getPosition().y));
    }

    protected void computeDElements() {
        this.listOfElements.clear();
        Iterator iterator = this.entity.listOfActors().iterator();
        while (iterator.hasNext()) {
            IElement pElement = (IElement)iterator.next();
            this.addDElement(this.entity, pElement);
        }
    }

    protected void computeDHierarchies() {
        this.listOfHierarchies.removeAllElements();
    }

    public Entity findCorrespondingDEntity(IEntity pEntity) {
        return this.pattern.findCorrespondingDEntity(pEntity);
    }

    public Element[] getDElements() {
        Element[] dElements = new Element[this.listOfElements.size()];
        this.listOfElements.toArray(dElements);
        return dElements;
    }

    public Hierarchy[] getDHierarchies() {
        Object[] dHierarchies = new Hierarchy[this.listOfHierarchies.size()];
        this.listOfHierarchies.copyInto(dHierarchies);
        return dHierarchies;
    }

    public String getName() {
        return this.entity.getDisplayName();
    }

    public IEntity getPEntity() {
        return this.entity;
    }

    public boolean isSelected() {
        return this.buttons[0].isSelected();
    }

    public boolean isSuper() {
        return this.isSuper;
    }

    public void isSuper(boolean isSuper) {
        this.isSuper = isSuper;
    }

    public void paint(int xOffset, int yOffset) {
        int i = 0;
        while (i < this.buttons.length) {
            if (this.buttons[i] != null) {
                this.buttons[i].paint(xOffset, yOffset);
            }
            ++i;
        }
    }

    public boolean processMouseEvent(MouseEvent me) {
        boolean hasChanged = false;
        int i = 0;
        while (i < this.buttons.length) {
            if (this.buttons[i] != null) {
                hasChanged |= this.buttons[i].processMouseEvent(me);
            }
            ++i;
        }
        return hasChanged;
    }

    public void setSelected(boolean isSelected) {
        this.buttons[0].setSelected(isSelected);
    }

    public void setVisibleElements(int visibility) {
        super.setVisibleElements(visibility);
        Iterator enumeration = this.listOfElements.iterator();
        while (enumeration.hasNext()) {
            ((Element)enumeration.next()).setVisibleElements(visibility);
        }
        enumeration = ((AbstractList)this.listOfHierarchies).iterator();
        while (enumeration.hasNext()) {
            ((Hierarchy)enumeration.next()).setVisibleElements(visibility);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this instanceof Class) {
            buffer.append("Class ");
        } else if (this instanceof Ghost) {
            buffer.append("Ghost ");
        } else if (this instanceof Interface) {
            buffer.append("Interface ");
        }
        buffer.append(this.entity.getDisplayName());
        buffer.append("\t// {");
        buffer.append(this.getPosition().x);
        buffer.append(", ");
        buffer.append(this.getPosition().y);
        buffer.append("} [");
        buffer.append(this.getDimension().width);
        buffer.append(", ");
        buffer.append(this.getDimension().height);
        buffer.append(']');
        return buffer.toString();
    }
}

