/*
 * Decompiled with CFR 0.152.
 */
package ptidej.ui.kernel;

import java.awt.Dimension;
import java.awt.Point;
import java.util.Vector;
import ptidej.ui.kernel.Constituent;
import ptidej.ui.kernel.Element;
import ptidej.ui.kernel.Entity;
import ptidej.ui.primitive.PrimitiveFactory;

public abstract class GraphicElement
extends Element {
    private Constituent originDEntity;
    private Constituent targetDEntity;

    public GraphicElement(PrimitiveFactory primitiveFactory, Entity origin, Entity target) {
        super(primitiveFactory);
        this.setOriginDEntity(origin);
        this.setTargetDEntity(target);
    }

    private Point centralPoint(Point position, Dimension dimension) {
        return new Point(position.x + dimension.width / 2, position.y + dimension.height / 2);
    }

    private Point[] findIntersectionPoints(Point origin, Dimension dimension) {
        Vector<Point> intersections = new Vector<Point>(2);
        Point topLeftCorner = new Point(origin.x, origin.y);
        Point bottomLeftCorner = new Point(origin.x, origin.y + dimension.height);
        Point topRightCorner = new Point(origin.x + dimension.width, origin.y);
        Point bottomRightCorner = new Point(origin.x + dimension.width, origin.y + dimension.height);
        Point intersection = null;
        intersection = GraphicElement.intersectionPoint(topLeftCorner, topRightCorner, this.getPosition(), this.getDestination());
        if (GraphicElement.pointOnLine(intersection, topLeftCorner, topRightCorner)) {
            intersections.addElement(intersection);
        }
        if (GraphicElement.pointOnLine(intersection = GraphicElement.intersectionPoint(topRightCorner, bottomRightCorner, this.getPosition(), this.getDestination()), topRightCorner, bottomRightCorner)) {
            intersections.addElement(intersection);
        }
        if (GraphicElement.pointOnLine(intersection = GraphicElement.intersectionPoint(bottomLeftCorner, bottomRightCorner, this.getPosition(), this.getDestination()), bottomLeftCorner, bottomRightCorner)) {
            intersections.addElement(intersection);
        }
        if (GraphicElement.pointOnLine(intersection = GraphicElement.intersectionPoint(topLeftCorner, bottomLeftCorner, this.getPosition(), this.getDestination()), topLeftCorner, bottomLeftCorner)) {
            intersections.addElement(intersection);
        }
        Object[] intersectionPoints = new Point[intersections.size()];
        intersections.copyInto(intersectionPoints);
        return intersectionPoints;
    }

    protected Point findIntersectionPointWithOrigin() {
        Point[] intersectionPoints = this.findIntersectionPoints(this.getOriginDEntity().getPosition(), this.getOriginDEntity().getDimension());
        Point originCentralPoint = this.centralPoint(this.getOriginDEntity().getPosition(), this.getOriginDEntity().getDimension());
        Point targetCentralPoint = this.centralPoint(this.getTargetDEntity().getPosition(), this.getTargetDEntity().getDimension());
        int i = 0;
        while (i < intersectionPoints.length) {
            if (this.inBetween(intersectionPoints[i], originCentralPoint, targetCentralPoint)) {
                return intersectionPoints[i];
            }
            ++i;
        }
        return null;
    }

    protected Point findIntersectionPointWithTarget() {
        Point[] intersectionPoints = this.findIntersectionPoints(this.getTargetDEntity().getPosition(), this.getTargetDEntity().getDimension());
        Point originCentralPoint = this.centralPoint(this.getOriginDEntity().getPosition(), this.getOriginDEntity().getDimension());
        Point targetCentralPoint = this.centralPoint(this.getTargetDEntity().getPosition(), this.getTargetDEntity().getDimension());
        int i = 0;
        while (i < intersectionPoints.length) {
            if (this.inBetween(intersectionPoints[i], originCentralPoint, targetCentralPoint)) {
                return intersectionPoints[i];
            }
            ++i;
        }
        return null;
    }

    public Point getDestination() {
        return new Point(this.getTargetDEntity().getPosition().x + this.getTargetDEntity().getDimension().width / 2, this.getTargetDEntity().getPosition().y + this.getTargetDEntity().getDimension().height / 2);
    }

    public Dimension getDimension() {
        return new Dimension(this.getDestination().x - this.getPosition().x, this.getDestination().y - this.getPosition().y);
    }

    public Constituent getOriginDEntity() {
        return this.originDEntity;
    }

    public Point getPosition() {
        return new Point(this.getOriginDEntity().getPosition().x + this.getOriginDEntity().getDimension().width / 2, this.getOriginDEntity().getPosition().y + this.getOriginDEntity().getDimension().height / 2);
    }

    public Constituent getTargetDEntity() {
        return this.targetDEntity;
    }

    private boolean inBetween(Point centralPoint, Point originCentralPoint, Point targetCentralPoint) {
        boolean result = true;
        if (originCentralPoint.x <= targetCentralPoint.x) {
            result = originCentralPoint.x <= centralPoint.x && centralPoint.x <= targetCentralPoint.x ? (result &= true) : (result &= false);
        }
        if (targetCentralPoint.x <= originCentralPoint.x) {
            result = targetCentralPoint.x <= centralPoint.x && centralPoint.x <= originCentralPoint.x ? (result &= true) : (result &= false);
        }
        if (originCentralPoint.y <= targetCentralPoint.y) {
            result = originCentralPoint.y <= centralPoint.y && centralPoint.y <= targetCentralPoint.y ? (result &= true) : (result &= false);
        }
        if (targetCentralPoint.y <= originCentralPoint.y) {
            result = targetCentralPoint.y <= centralPoint.y && centralPoint.y <= originCentralPoint.y ? (result &= true) : (result &= false);
        }
        return result;
    }

    private static Point intersectionPoint(int x1l1, int y1l1, int x2l1, int y2l1, int x1l2, int y1l2, int x2l2, int y2l2) {
        int xi = 0;
        int yi = 0;
        if (x2l1 - x1l1 != 0 && x2l2 - x1l2 != 0) {
            if (y2l1 - y1l1 != 0 && y2l2 - y1l2 != 0) {
                int a1 = (y2l1 - y1l1) * 100000 / (x2l1 - x1l1);
                int a2 = (y2l2 - y1l2) * 100000 / (x2l2 - x1l2);
                int b1 = y1l1 * 100000 - a1 * x1l1;
                int b2 = y1l2 * 100000 - a2 * x1l2;
                xi = (b2 - b1) / (a1 - a2);
                yi = (a1 * xi + b1) / 100000;
            } else if (y2l1 - y1l1 == 0) {
                yi = y1l1;
                if (y2l2 - y1l2 == 0) {
                    xi = 0;
                } else {
                    int a2 = (y2l2 - y1l2) * 100000 / (x2l2 - x1l2);
                    int b2 = y1l2 * 100000 - a2 * x1l2;
                    xi = (100000 * yi - b2) / a2;
                }
            } else if (y2l2 - y1l2 == 0) {
                yi = y1l2;
                if (y2l1 - y1l1 == 0) {
                    xi = 0;
                } else {
                    int a1 = (y2l1 - y1l1) * 100000 / (x2l1 - x1l1);
                    int b1 = y1l1 * 100000 - a1 * x1l1;
                    xi = (100000 * yi - b1) / a1;
                }
            }
        } else if (x1l1 - x2l1 == 0) {
            xi = x1l1;
            if (x1l2 - x2l2 == 0) {
                yi = 0;
            } else {
                int a2 = (y2l2 - y1l2) * 100000 / (x2l2 - x1l2);
                int b2 = y1l2 * 100000 - a2 * x1l2;
                yi = (a2 * xi + b2) / 100000;
            }
        } else if (x1l2 - x2l2 == 0) {
            xi = x1l2;
            if (x1l1 - x2l1 == 0) {
                yi = 0;
            } else {
                int a1 = (y2l1 - y1l1) * 100000 / (x2l1 - x1l1);
                int b1 = y1l1 * 100000 - a1 * x1l1;
                yi = (a1 * xi + b1) / 100000;
            }
        }
        return new Point(xi, yi);
    }

    private static Point intersectionPoint(Point p1, Point p2, Point p3, Point p4) {
        return GraphicElement.intersectionPoint(p1.x, p1.y, p2.x, p2.y, p3.x, p3.y, p4.x, p4.y);
    }

    private static boolean pointOnLine(Point p1, Point a1, Point a2) {
        return a1.x - 2 <= p1.x && p1.x <= a2.x + 2 && a1.y - 2 <= p1.y && p1.y <= a2.y + 2;
    }

    public void setOriginDEntity(Entity orgin) {
        this.originDEntity = orgin;
    }

    public void setTargetDEntity(Entity target) {
        this.targetDEntity = target;
    }

    public String toString() {
        return this.getName();
    }
}

