/*
 * Decompiled with CFR 0.152.
 */
package ptidej.ui.kernel;

import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import padl.kernel.IAbstractModel;
import padl.kernel.IClass;
import padl.kernel.IEntity;
import padl.kernel.IGhost;
import padl.kernel.IInterface;
import ptidej.ui.Constants;
import ptidej.ui.VisibilityElement;
import ptidej.ui.event.MouseEvent;
import ptidej.ui.kernel.Class;
import ptidej.ui.kernel.Constituent;
import ptidej.ui.kernel.Entity;
import ptidej.ui.kernel.Ghost;
import ptidej.ui.kernel.Interface;
import ptidej.ui.layout.ModelLayout;
import ptidej.ui.primitive.PrimitiveFactory;

public final class GraphicModel
extends Constituent
implements VisibilityElement {
    private final IAbstractModel model;
    private final String modelName;
    private ModelLayout modelLayout;
    private Constituent[] modelConstituents;
    private int whatIsVisible;
    private Map backwardLinkPtoD;

    public GraphicModel(PrimitiveFactory primitiveFactory, IAbstractModel model, ModelLayout modelLayout) {
        super(primitiveFactory);
        this.model = model;
        this.modelName = model.getName();
        this.modelLayout = modelLayout;
        this.createPattern(model);
    }

    private void addBackwardLinkPtoD(IEntity pEntity, Entity dEntity) {
        this.backwardLinkPtoD.put(pEntity, dEntity);
    }

    public void build() {
        ArrayList<Constituent> dEntities = new ArrayList<Constituent>();
        int i = 0;
        while (i < this.modelConstituents.length) {
            this.modelConstituents[i].setPosition(Constants.DEFAULT_POSITION);
            if (this.modelConstituents[i] instanceof Entity) {
                dEntities.add(this.modelConstituents[i]);
            }
            ++i;
        }
        Entity[] allDEntities = new Entity[dEntities.size()];
        dEntities.toArray(allDEntities);
        this.modelConstituents = this.modelLayout.doLayout(allDEntities);
        this.setDimension(new Dimension());
        int i2 = 0;
        while (i2 < allDEntities.length) {
            this.setSize(allDEntities[i2].getPosition(), allDEntities[i2].getDimension());
            ++i2;
        }
    }

    private Entity createEntity(IEntity pEntity) {
        Entity dEntity = null;
        if (pEntity instanceof IClass) {
            dEntity = new Class(this.getPrimitiveFactory(), this, (IClass)pEntity);
        } else if (pEntity instanceof IInterface) {
            dEntity = new Interface(this.getPrimitiveFactory(), this, (IInterface)pEntity);
        } else if (pEntity instanceof IGhost && (this.getVisibleElements() & 0x8000) == 32768) {
            dEntity = new Ghost(this.getPrimitiveFactory(), this, (IGhost)pEntity);
        }
        return dEntity;
    }

    private void createPattern(IAbstractModel model) {
        if (this.backwardLinkPtoD == null) {
            this.backwardLinkPtoD = new HashMap(model.listOfActors().size());
        } else {
            this.backwardLinkPtoD.clear();
        }
        ArrayList<Entity> modelConstituentsList = new ArrayList<Entity>(model.listOfActors().size());
        Iterator iterator = model.listOfActors().iterator();
        while (iterator.hasNext()) {
            IEntity pEntity = (IEntity)iterator.next();
            Entity entity = this.createEntity(pEntity);
            if (entity == null) continue;
            modelConstituentsList.add(entity);
            this.addBackwardLinkPtoD(pEntity, entity);
        }
        this.modelConstituents = new Entity[modelConstituentsList.size()];
        modelConstituentsList.toArray(this.modelConstituents);
        int i = 0;
        while (i < this.modelConstituents.length) {
            ((Entity)this.modelConstituents[i]).computeDElements();
            ((Entity)this.modelConstituents[i]).computeDHierarchies();
            ++i;
        }
    }

    public Entity findCorrespondingDEntity(IEntity pEntity) {
        return (Entity)this.backwardLinkPtoD.get(pEntity);
    }

    public Constituent getActor(String name) {
        int i = 0;
        while (i < this.modelConstituents.length) {
            if (this.modelConstituents[i].getName().equals(name)) {
                return this.modelConstituents[i];
            }
            ++i;
        }
        return null;
    }

    public Constituent[] getConstituents() {
        return this.modelConstituents;
    }

    public String getName() {
        return this.modelName;
    }

    public IAbstractModel getModel() {
        return this.model;
    }

    public int getVisibleElements() {
        return this.whatIsVisible;
    }

    public boolean isSelected() {
        boolean isSelected = true;
        int i = 0;
        while (i < this.modelConstituents.length && isSelected) {
            isSelected |= this.modelConstituents[i].isSelected();
            ++i;
        }
        return isSelected;
    }

    public void paint(int xOffset, int yOffset) {
        int i = 0;
        while (i < this.modelConstituents.length) {
            this.modelConstituents[i].paint(xOffset, yOffset);
            ++i;
        }
    }

    public boolean processMouseEvent(MouseEvent me) {
        boolean hasChanged = false;
        int i = this.modelConstituents.length - 1;
        while (i > 0 && !hasChanged) {
            hasChanged = this.modelConstituents[i].processMouseEvent(me);
            --i;
        }
        return hasChanged;
    }

    public void setSelected(boolean isSelected) {
        int i = 0;
        while (i < this.modelConstituents.length) {
            this.modelConstituents[i].setSelected(isSelected);
            ++i;
        }
    }

    private void setSize(Point entityOrElementPosition, Dimension entityOrElementDimension) {
        int tempWidth = entityOrElementPosition.x + entityOrElementDimension.width + Constants.CANVAS_INNER_GAP.width;
        tempWidth = this.getDimension().width < tempWidth ? tempWidth : this.getDimension().width;
        int tempHeight = entityOrElementPosition.y + entityOrElementDimension.height + Constants.CANVAS_INNER_GAP.height;
        tempHeight = this.getDimension().height < tempHeight ? tempHeight : this.getDimension().height;
        this.getDimension().setSize(tempWidth, tempHeight);
    }

    public void setVisibleElements(int visibility) {
        if ((this.whatIsVisible & 0x8000) != (visibility & 0x8000)) {
            this.whatIsVisible = visibility;
            this.createPattern(this.model);
        }
        this.whatIsVisible = visibility;
        int i = 0;
        while (i < this.modelConstituents.length) {
            this.modelConstituents[i].setVisibleElements(visibility);
            ++i;
        }
    }
}

