/*
 * Decompiled with CFR 0.152.
 */
package ptidej.ui.kernel;

import java.awt.Point;
import ptidej.ui.Constants;
import ptidej.ui.RGB;
import ptidej.ui.kernel.Entity;
import ptidej.ui.kernel.Ghost;
import ptidej.ui.kernel.GraphicElement;
import ptidej.ui.primitive.DottedLine;
import ptidej.ui.primitive.PrimitiveFactory;
import ptidej.ui.primitive.Symbol;

public class Knowledge
extends GraphicElement {
    private final String methodName;
    private DottedLine line;
    private Symbol arrowSymbol;

    protected Knowledge(PrimitiveFactory primitiveFactory, Entity origin, String methodName, Entity target) {
        super(primitiveFactory, origin, target);
        this.methodName = methodName;
    }

    public void build() {
        if (this.getTargetDEntity() != null) {
            Point intersectionPoint;
            RGB color = this.getTargetDEntity() instanceof Ghost ? Constants.GHOST_ENTITY_DISPLAY_COLOR : Constants.FOREGROUND_COLOR;
            this.line = this.getPrimitiveFactory().createDottedLine(this.getPosition(), this.getDimension(), color);
            if (this.getTargetDEntity() != this.getOriginDEntity() && (intersectionPoint = this.findIntersectionPointWithTarget()) != null) {
                this.arrowSymbol = this.getPrimitiveFactory().createArrowSymbol(intersectionPoint, this.getDimension(), -this.getDirection(), color);
            }
        }
    }

    protected int getDirection() {
        return this.getPosition().y > this.getDestination().y ? 1 : -1;
    }

    public String getName() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("-u--> ");
        buffer.append(this.getTargetDEntity().getName());
        return buffer.toString();
    }

    protected int getVisibility() {
        return 0x100000;
    }

    public void paint(int xOffset, int yOffset) {
        if ((this.getVisibleElements() & this.getVisibility()) == this.getVisibility() && this.line != null) {
            this.line.paint(xOffset, yOffset);
            if (this.arrowSymbol != null) {
                this.arrowSymbol.paint(xOffset, yOffset);
            }
        }
    }
}

