/*
 * Decompiled with CFR 0.152.
 */
package ptidej.ui.layout;

import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import padl.kernel.IInterface;
import ptidej.ui.Constants;
import ptidej.ui.kernel.Constituent;
import ptidej.ui.kernel.Element;
import ptidej.ui.kernel.Entity;
import ptidej.ui.kernel.Hierarchy;
import ptidej.ui.layout.ModelLayout;
import ptidej.util.ibm.collection.Arrays;
import ptidej.util.ibm.collection.Comparator;

public final class InheritanceClusterLayout
implements ModelLayout {
    private Point checkUnderneath(Entity[] allEntities, Entity dEntity) {
        int xThis1 = allEntities[0].getPosition().x;
        int yThis1 = this.checkUnrelatedY(allEntities, dEntity, dEntity.getPosition().y);
        if (dEntity.getDHierarchies().length > 0) {
            int levelOfHierarchy = 0;
            while (levelOfHierarchy < dEntity.getDHierarchies().length) {
                Entity hierarchyTarget = (Entity)dEntity.getDHierarchies()[levelOfHierarchy].getTargetDEntity();
                int i = 0;
                while (i < allEntities.length && allEntities[i] != hierarchyTarget) {
                    ++i;
                }
                if (i != allEntities.length) {
                    xThis1 = Math.max(xThis1, allEntities[i].getPosition().x + allEntities[i].getDimension().width / 2 + Constants.GAP_BETWEEN_ENTITIES.width);
                }
                ++levelOfHierarchy;
            }
        }
        return new Point(xThis1, yThis1);
    }

    private int checkUnrelatedY(Entity[] allEntities, Entity dEntity, int yThis1) {
        int xThis1 = dEntity.getPosition().x;
        int i = 0;
        while (i < allEntities.length && !allEntities[i].equals(dEntity)) {
            int x1 = allEntities[i].getPosition().x;
            int y1 = allEntities[i].getPosition().y;
            if (allEntities[i] instanceof Entity) {
                int xInt1 = Math.max(xThis1, x1);
                int yInt1 = Math.max(yThis1, y1);
                int xThis2 = xThis1 + dEntity.getDimension().width;
                int yThis2 = yThis1 + dEntity.getDimension().height;
                int x2 = x1 + allEntities[i].getDimension().width;
                int y2 = y1 + allEntities[i].getDimension().height;
                int xInt2 = Math.min(xThis2, x2);
                int yInt2 = Math.min(yThis2, y2);
                if (xInt1 <= xInt2 || yInt1 <= yInt2) {
                    yThis1 = Math.max(yThis1, y2 + Constants.GAP_BETWEEN_ENTITIES.height);
                }
            }
            ++i;
        }
        return yThis1;
    }

    public Constituent[] doLayout(Entity[] allEntities) {
        int i;
        int numberOfEntities = allEntities.length;
        HashMap<String, DepthAwareEntity> depthAwareDEntities = new HashMap<String, DepthAwareEntity>(numberOfEntities);
        int maxDepth = 0;
        int i2 = 0;
        while (i2 < numberOfEntities) {
            depthAwareDEntities.put(allEntities[i2].getName(), new DepthAwareEntity(allEntities[i2]));
            ++i2;
        }
        i2 = 0;
        while (i2 < numberOfEntities) {
            maxDepth = Math.max(maxDepth, ((DepthAwareEntity)depthAwareDEntities.get(allEntities[i2].getName())).computeDepth(depthAwareDEntities));
            ++i2;
        }
        Arrays.sort(allEntities, new DepthAwareEntitiesComparator(depthAwareDEntities));
        if (numberOfEntities > 0) {
            int lastGhostPos = 0;
            while (lastGhostPos < numberOfEntities && ((DepthAwareEntity)depthAwareDEntities.get(allEntities[lastGhostPos].getName())).getDepth() == 0) {
                ++lastGhostPos;
            }
            i = 0;
            while (i < numberOfEntities) {
                if (allEntities[i].getPEntity() instanceof IInterface) {
                    Entity interfaceEntity = allEntities[i];
                    if (i - lastGhostPos < 0) {
                        lastGhostPos = i;
                    }
                    System.arraycopy(allEntities, lastGhostPos, allEntities, lastGhostPos + 1, i - lastGhostPos);
                    allEntities[lastGhostPos] = interfaceEntity;
                    ++lastGhostPos;
                }
                ++i;
            }
        }
        InheritanceTreeNode root = new InheritanceTreeNode();
        i = 0;
        while (i < numberOfEntities) {
            root.addChild(new InheritanceTreeNode(allEntities[i]));
            ++i;
        }
        root.copyInto(allEntities);
        i = 0;
        while (i < numberOfEntities) {
            allEntities[i].setPosition(this.checkUnderneath(allEntities, allEntities[i]));
            allEntities[i].build();
            ++i;
        }
        ArrayList<Element> allElements = new ArrayList<Element>();
        int i3 = 0;
        while (i3 < numberOfEntities) {
            Element[] dElements = allEntities[i3].getDElements();
            int j = 0;
            while (j < dElements.length) {
                allElements.add(dElements[j]);
                dElements[j].build();
                ++j;
            }
            Hierarchy[] dHierarchies = allEntities[i3].getDHierarchies();
            int j2 = 0;
            while (j2 < dHierarchies.length) {
                allElements.add(dHierarchies[j2]);
                dHierarchies[j2].build();
                ++j2;
            }
            ++i3;
        }
        Constituent[] temp = new Constituent[numberOfEntities + allElements.size()];
        allElements.toArray(temp);
        System.arraycopy(allEntities, 0, temp, allElements.size(), numberOfEntities);
        return temp;
    }

    private static final class DepthAwareEntitiesComparator
    implements Comparator {
        private Map depthAwareDEntities;

        public DepthAwareEntitiesComparator(Map depthAwareDEntities) {
            this.depthAwareDEntities = depthAwareDEntities;
        }

        public int compare(Object o1, Object o2) {
            DepthAwareEntity dEntity1 = (DepthAwareEntity)this.depthAwareDEntities.get(((Entity)o1).getName());
            DepthAwareEntity dEntity2 = (DepthAwareEntity)this.depthAwareDEntities.get(((Entity)o2).getName());
            if (dEntity1.getDepth() < dEntity2.getDepth()) {
                return -1;
            }
            if (dEntity1.getDepth() > dEntity2.getDepth()) {
                return 1;
            }
            return dEntity1.getName().compareTo(dEntity2.getName());
        }
    }

    private static final class DepthAwareEntity {
        private final Entity dEntity;
        private int depth = -1;

        public DepthAwareEntity(Entity dEntity) {
            this.dEntity = dEntity;
        }

        public int computeDepth(Map listOfDepthAwareDEntities) {
            if (this.depth == -1) {
                this.depth = 0;
                Hierarchy[] dHierarchies = this.dEntity.getDHierarchies();
                int i = 0;
                while (i < dHierarchies.length) {
                    Entity temporaryDEntity = (Entity)dHierarchies[i].getTargetDEntity();
                    String superName = temporaryDEntity.getName();
                    DepthAwareEntity superDepthAwareDEntity = (DepthAwareEntity)listOfDepthAwareDEntities.get(superName);
                    if (superDepthAwareDEntity != null) {
                        this.depth = Math.max(this.depth, superDepthAwareDEntity.computeDepth(listOfDepthAwareDEntities) + 1);
                    }
                    ++i;
                }
            }
            return this.depth;
        }

        public int getDepth() {
            if (this.depth == -1) {
                throw new RuntimeException("The depth of the DepthAwareEntity must be computed (computeDepth(Map)) prior to a call to getDepth().");
            }
            return this.depth;
        }

        public String getName() {
            return this.dEntity.getName();
        }

        public String toString() {
            return String.valueOf(this.dEntity.getName()) + " " + this.depth;
        }
    }

    private static final class InheritanceTreeNode {
        public static int NumberOfChildren;
        private final Entity entity;
        private InheritanceTreeNode[] children;
        private int numberOfChildren;

        public InheritanceTreeNode(Entity entity) {
            this.entity = entity;
            this.children = new InheritanceTreeNode[4];
            this.numberOfChildren = 0;
        }

        public InheritanceTreeNode() {
            this(null);
            NumberOfChildren = 0;
        }

        public void addChild0(InheritanceTreeNode child) {
            if (this.numberOfChildren == this.children.length) {
                InheritanceTreeNode[] temp = new InheritanceTreeNode[this.numberOfChildren + 4];
                System.arraycopy(this.children, 0, temp, 0, this.numberOfChildren);
                this.children = temp;
            }
            this.children[this.numberOfChildren] = child;
            ++this.numberOfChildren;
            ++NumberOfChildren;
        }

        public void addChild(InheritanceTreeNode child) {
            if (child.entity.getDHierarchies().length == 0 || this.entity == child.entity.getDHierarchies()[0].getTargetDEntity()) {
                this.addChild0(child);
            } else {
                int i = 0;
                while (i < this.numberOfChildren) {
                    if (this.children[i].entity == child.entity.getDHierarchies()[0].getTargetDEntity()) {
                        this.children[i].addChild(child);
                    } else {
                        this.children[i].addChild(child);
                    }
                    ++i;
                }
            }
        }

        public void copyInto(Entity[] dEntities) {
            int pos = 0;
            int i = 0;
            while (i < this.numberOfChildren) {
                pos = this.children[i].copyInto(dEntities, pos);
                ++i;
            }
        }

        private int copyInto(Entity[] dEntities, int pos) {
            dEntities[pos] = this.entity;
            ++pos;
            int i = 0;
            while (i < this.numberOfChildren) {
                pos = this.children[i].copyInto(dEntities, pos);
                ++i;
            }
            return pos;
        }
    }
}

