/*
 * Decompiled with CFR 0.152.
 */
package ptidej.ui.layout;

import java.awt.Point;
import java.util.Hashtable;
import java.util.Vector;
import ptidej.ui.Constants;
import ptidej.ui.kernel.Constituent;
import ptidej.ui.kernel.Element;
import ptidej.ui.kernel.Entity;
import ptidej.ui.kernel.Hierarchy;
import ptidej.ui.layout.ModelLayout;
import ptidej.util.ibm.collection.Arrays;
import ptidej.util.ibm.collection.Comparator;

public final class InheritanceDepthLayout
implements ModelLayout {
    private Point checkUnderneath(Entity[] allDEntities, Entity dEntity) {
        int xThis1 = allDEntities[0].getPosition().x;
        int yThis1 = this.checkUnrelatedY(allDEntities, dEntity, dEntity.getPosition().y);
        if (dEntity.getDHierarchies().length > 0) {
            int levelOfHierarchy = 0;
            while (levelOfHierarchy < dEntity.getDHierarchies().length) {
                int i = 0;
                while (allDEntities[i] != dEntity.getDHierarchies()[levelOfHierarchy].getTargetDEntity()) {
                    ++i;
                }
                xThis1 = allDEntities[i].getPosition().x + allDEntities[i].getDimension().width;
                ++levelOfHierarchy;
            }
        }
        return new Point(xThis1, yThis1);
    }

    private int checkUnrelatedY(Entity[] allDEntities, Entity dEntity, int yThis1) {
        int xThis1 = dEntity.getPosition().x;
        int i = 0;
        while (i < allDEntities.length && !allDEntities[i].equals(dEntity)) {
            int x1 = allDEntities[i].getPosition().x;
            int y1 = allDEntities[i].getPosition().y;
            if (allDEntities[i] instanceof Entity) {
                int xInt1 = Math.max(xThis1, x1);
                int yInt1 = Math.max(yThis1, y1);
                int xThis2 = xThis1 + dEntity.getDimension().width;
                int yThis2 = yThis1 + dEntity.getDimension().height;
                int x2 = x1 + allDEntities[i].getDimension().width;
                int y2 = y1 + allDEntities[i].getDimension().height;
                int xInt2 = Math.min(xThis2, x2);
                int yInt2 = Math.min(yThis2, y2);
                if (xInt1 <= xInt2 || yInt1 <= yInt2) {
                    yThis1 = Math.max(yThis1, y2 + Constants.GAP_BETWEEN_ENTITIES.height);
                }
            }
            ++i;
        }
        return yThis1;
    }

    public Constituent[] doLayout(Entity[] allDEntities) {
        Hashtable<String, DepthAwareDEntity> depthAwareDEntities = new Hashtable<String, DepthAwareDEntity>();
        int numberOfDEntities = allDEntities.length;
        int maxDepth = 0;
        int i = 0;
        while (i < numberOfDEntities) {
            depthAwareDEntities.put(allDEntities[i].getName(), new DepthAwareDEntity(allDEntities[i]));
            ++i;
        }
        i = 0;
        while (i < numberOfDEntities) {
            maxDepth = Math.max(maxDepth, ((DepthAwareDEntity)depthAwareDEntities.get(allDEntities[i].getName())).computeDepth(depthAwareDEntities));
            ++i;
        }
        Arrays.sort(allDEntities, new DepthAwareDEntitiesComparator(depthAwareDEntities));
        Vector<Entity> temp = new Vector<Entity>();
        Entity dEntity = null;
        Entity dSuperclass = null;
        boolean changed = true;
        int changes = 0;
        int i2 = 0;
        while (i2 < numberOfDEntities) {
            temp.addElement(allDEntities[i2]);
            ++i2;
        }
        int depth = 1;
        while (depth <= maxDepth) {
            changed = true;
            changes = 0;
            while (changed && changes < numberOfDEntities) {
                changed = false;
                int entityPos = numberOfDEntities - 1;
                while (entityPos >= 0) {
                    dEntity = (Entity)temp.elementAt(entityPos);
                    if (((DepthAwareDEntity)depthAwareDEntities.get(dEntity.getName())).getDepth() == depth) {
                        int superclassPos = 0;
                        int i3 = 0;
                        while (i3 < dEntity.getDHierarchies().length) {
                            dSuperclass = (Entity)dEntity.getDHierarchies()[i3].getTargetDEntity();
                            int j = 0;
                            while ((Entity)temp.elementAt(j) != dSuperclass) {
                                ++j;
                            }
                            superclassPos = Math.max(superclassPos, j);
                            ++i3;
                        }
                        if (++superclassPos != entityPos) {
                            temp.removeElementAt(entityPos);
                            temp.insertElementAt(dEntity, superclassPos);
                            changed = true;
                            ++changes;
                        }
                    }
                    --entityPos;
                }
            }
            ++depth;
        }
        temp.copyInto(allDEntities);
        i = 0;
        while (i < numberOfDEntities) {
            allDEntities[i].setPosition(this.checkUnderneath(allDEntities, allDEntities[i]));
            allDEntities[i].build();
            ++i;
        }
        Vector<Element> allDElements = new Vector<Element>();
        int i4 = 0;
        while (i4 < numberOfDEntities) {
            Element[] dElements = allDEntities[i4].getDElements();
            int j = 0;
            while (j < dElements.length) {
                allDElements.addElement(dElements[j]);
                dElements[j].build();
                ++j;
            }
            Hierarchy[] dHierarchies = allDEntities[i4].getDHierarchies();
            int j2 = 0;
            while (j2 < dHierarchies.length) {
                allDElements.addElement(dHierarchies[j2]);
                dHierarchies[j2].build();
                ++j2;
            }
            ++i4;
        }
        Object[] temp2 = new Constituent[numberOfDEntities + allDElements.size()];
        allDElements.copyInto(temp2);
        System.arraycopy(allDEntities, 0, temp2, allDElements.size(), numberOfDEntities);
        return temp2;
    }

    private static class DepthAwareDEntity {
        private final Entity dEntity;
        private int depth = -1;

        public DepthAwareDEntity(Entity dEntity) {
            this.dEntity = dEntity;
        }

        public int computeDepth(Hashtable listOfDepthAwareDEntities) {
            if (this.depth == -1) {
                Hierarchy[] dHierarchies = this.dEntity.getDHierarchies();
                this.depth = 0;
                int i = 0;
                while (i < dHierarchies.length) {
                    String superName = dHierarchies[i].getTargetDEntity().getName();
                    DepthAwareDEntity superDepthAwareDEntity = (DepthAwareDEntity)listOfDepthAwareDEntities.get(superName);
                    this.depth = Math.max(this.depth, superDepthAwareDEntity.computeDepth(listOfDepthAwareDEntities) + 1);
                    ++i;
                }
            }
            return this.depth;
        }

        public int getDepth() {
            if (this.depth == -1) {
                throw new RuntimeException("The depth of the DepthAwareDEntity must be computed (computeDepth(Hashtable)) prior to a call to getDepth().");
            }
            return this.depth;
        }

        public String getName() {
            return this.dEntity.getName();
        }

        public String toString() {
            return String.valueOf(this.dEntity.getName()) + " " + this.depth;
        }
    }

    public static final class DepthAwareDEntitiesComparator
    implements Comparator {
        private Hashtable depthAwareDEntities;

        public DepthAwareDEntitiesComparator(Hashtable depthAwareDEntities) {
            this.depthAwareDEntities = depthAwareDEntities;
        }

        public int compare(Object o1, Object o2) {
            DepthAwareDEntity dEntity1 = (DepthAwareDEntity)this.depthAwareDEntities.get(((Entity)o1).getName());
            DepthAwareDEntity dEntity2 = (DepthAwareDEntity)this.depthAwareDEntities.get(((Entity)o2).getName());
            if (dEntity1.getDepth() < dEntity2.getDepth()) {
                return -1;
            }
            if (dEntity1.getDepth() > dEntity2.getDepth()) {
                return 1;
            }
            return dEntity1.getName().compareTo(dEntity2.getName());
        }
    }
}

