/*
 * Decompiled with CFR 0.152.
 */
package ptidej.ui.primitive.awt;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import ptidej.ui.Constants;
import ptidej.ui.RGB;
import ptidej.ui.event.MouseEvent;
import ptidej.ui.primitive.awt.Primitive;
import ptidej.ui.primitive.awt.PrimitiveFactory;

public class Button
extends Primitive
implements ptidej.ui.primitive.Button {
    private static final Font FONT = new Font("Courrier", 0, 9);
    private Font font = FONT;
    private String label;
    private boolean isSelected;
    private boolean centerText;
    private int cacheNumberOfLines = 0;
    private String cacheLongestLine = "";

    protected Button(PrimitiveFactory primitiveFactory, String s, Point position, Dimension dimension, boolean centerText, RGB color) {
        super(primitiveFactory, position, dimension, color);
        this.setLabel(s);
        this.centerText = centerText;
    }

    protected Button(PrimitiveFactory primitiveFactory, String s, Point position, boolean centerText, RGB color) {
        this(primitiveFactory, s, position, new Dimension(0, 0), centerText, color);
        this.reSizeToTextDimension();
    }

    public String getLabel() {
        return this.label;
    }

    private String getLongestLines() {
        if (!this.cacheLongestLine.equals(this.label)) {
            int prevIndex = 0;
            int index = 0;
            while ((index = this.label.indexOf(10, prevIndex + 1)) > 0) {
                String tempString = this.label.substring(prevIndex, index);
                if (this.cacheLongestLine.length() < tempString.length()) {
                    this.cacheLongestLine = tempString;
                }
                prevIndex = index;
            }
        }
        return this.cacheLongestLine;
    }

    private int getNumberOfLines() {
        if (this.cacheNumberOfLines == 0) {
            int index = 0;
            while ((index = this.label.indexOf(10, index + 1)) > 0) {
                ++this.cacheNumberOfLines;
            }
        }
        return this.cacheNumberOfLines;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void paint(int xOffset, int yOffset) {
        int x = this.getPosition().x + xOffset;
        int y = this.getPosition().y + yOffset;
        int h = this.getDimension().height;
        int w = this.getDimension().width;
        if (this.isSelected()) {
            this.getGraphics().setColor(this.getAWTColor());
            this.getGraphics().fillRect(x, y, w + 1, h);
            this.getGraphics().setColor(Primitive.convertColor(Constants.BACKGROUND_COLOR));
        } else {
            this.getGraphics().setColor(Primitive.convertColor(Constants.BACKGROUND_COLOR));
            this.getGraphics().fillRect(x, y, w, h);
            this.getGraphics().setColor(this.getAWTColor());
            this.getGraphics().drawRect(x, y, w, h);
        }
        Font previousFont = this.getGraphics().getFont();
        this.getGraphics().setFont(this.font);
        int height = 9;
        if (this.centerText) {
            int index = 0;
            int i = 1;
            while (i <= this.getNumberOfLines()) {
                int n = index;
                index = this.label.indexOf(10, index + 1);
                String tempLabel = this.label.substring(n, index);
                ++index;
                this.getGraphics().drawString(tempLabel, x + (w - tempLabel.length() * 5) / 2, y + (i - 1) * height + height);
                ++i;
            }
        } else {
            int index = 0;
            int i = 1;
            while (i <= this.getNumberOfLines()) {
                int n = index;
                index = this.label.indexOf(10, index + 1);
                String tempLabel = this.label.substring(n, index);
                ++index;
                this.getGraphics().drawString(tempLabel, x + 5, y + (i - 1) * height + height);
                ++i;
            }
        }
        this.getGraphics().setFont(previousFont);
    }

    public boolean processMouseEvent(MouseEvent me) {
        if (me.getID() == 1) {
            boolean isInRange;
            boolean bl = isInRange = this.getPosition().x < me.getX() && this.getPosition().y < me.getY() && me.getX() < this.getPosition().x + this.getDimension().width && me.getY() < this.getPosition().y + this.getDimension().height;
            if (isInRange) {
                this.setSelected(!this.isSelected());
                return true;
            }
        }
        return false;
    }

    private void reSizeToTextDimension() {
        this.setDimension(new Dimension(5 + this.getLongestLines().length() * 5 + 5, 4 + 9 * this.getNumberOfLines()));
    }

    public void setLabel(String label) {
        this.label = label;
        if (!this.label.endsWith("\n")) {
            this.label = String.valueOf(this.label) + '\n';
        }
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    public String toString() {
        return "Button: " + this.label;
    }
}

