/*
 * Decompiled with CFR 0.152.
 */
package ptidej.ui.primitive.awt;

import java.awt.Dimension;
import java.awt.Point;
import ptidej.ui.RGB;
import ptidej.ui.primitive.awt.Primitive;
import ptidej.ui.primitive.awt.PrimitiveFactory;

public final class DottedLine
extends Primitive
implements ptidej.ui.primitive.DottedLine {
    DottedLine(PrimitiveFactory primitiveFactory, Point origin, Dimension dimension, RGB color) {
        super(primitiveFactory, origin, dimension, color);
    }

    public DottedLine(PrimitiveFactory primitiveFactory, Point origin, Point destination, RGB color) {
        this(primitiveFactory, origin, new Dimension(destination.x - origin.x, destination.y - origin.y), color);
    }

    public void paint(int xOffset, int yOffset) {
        this.getGraphics().setColor(this.getAWTColor());
        int x1 = this.getPosition().x + xOffset;
        int y1 = this.getPosition().y + yOffset;
        int x2 = this.getDestination().x + xOffset;
        int y2 = this.getDestination().y + yOffset;
        int dx = x2 - x1;
        int dy = y2 - y1;
        int dxdx = dx * dx;
        int dydy = dy * dy;
        int length = (int)Math.sqrt(dxdx + dydy);
        int i = 0;
        while (i < length) {
            int segEndY;
            int segEndX;
            int segStartX = x1 + dx * i / length;
            int segStartY = y1 + dy * i / length;
            if ((i += 3) >= length) {
                segEndX = x2;
                segEndY = y2;
            } else {
                segEndX = x1 + dx * i / length;
                segEndY = y1 + dy * i / length;
            }
            this.getGraphics().drawLine(segStartX, segStartY, segEndX, segEndY);
            i += 3;
        }
    }
}

