/*
 * Decompiled with CFR 0.152.
 */
package ptidej.ui.primitive.awt;

import java.awt.Dimension;
import java.awt.Point;
import ptidej.ui.RGB;
import ptidej.ui.primitive.awt.PrimitiveFactory;
import ptidej.ui.primitive.awt.SquareLine;

public final class DottedSquareLine
extends SquareLine
implements ptidej.ui.primitive.DottedSquareLine {
    DottedSquareLine(PrimitiveFactory primitiveFactory, Point origin, Dimension dimension, RGB color) {
        super(primitiveFactory, origin, dimension, color);
    }

    public void paint(int xOffset, int yOffset) {
        int movingX;
        int movingY;
        Point origin = this.getPosition();
        Point destination = this.getDestination();
        this.getGraphics().setColor(this.getAWTColor());
        if (origin.y < destination.y) {
            movingY = origin.y;
            while (movingY < destination.y) {
                this.getGraphics().drawLine(origin.x + xOffset, movingY + yOffset, origin.x + xOffset, Math.min(movingY + 3, destination.y) + yOffset);
                movingY += 6;
            }
        } else {
            movingY = destination.y;
            while (movingY < origin.y) {
                this.getGraphics().drawLine(origin.x + xOffset, movingY + yOffset, origin.x + xOffset, Math.min(movingY + 3, origin.y) + yOffset);
                movingY += 6;
            }
        }
        if (origin.x < destination.x) {
            movingX = origin.x;
            while (movingX < destination.x) {
                this.getGraphics().drawLine(movingX + xOffset, destination.y + yOffset, Math.min(movingX + 3, destination.x) + xOffset, destination.y + yOffset);
                movingX += 6;
            }
        } else {
            movingX = destination.x;
            while (movingX < origin.x) {
                this.getGraphics().drawLine(movingX + xOffset, destination.y + yOffset, Math.min(movingX + 3, origin.x) + xOffset, destination.y + yOffset);
                movingX += 6;
            }
        }
    }
}

