/*
 * Decompiled with CFR 0.152.
 */
package ptidej.ui.primitive.awt;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.util.HashMap;
import java.util.Map;
import ptidej.ui.RGB;
import ptidej.ui.event.MouseEvent;
import ptidej.ui.primitive.awt.PrimitiveFactory;

public abstract class Primitive
implements ptidej.ui.primitive.Primitive {
    private Point origin;
    private Dimension dimension;
    private RGB color;
    private Point destination;
    private PrimitiveFactory primitiveFactory;
    private boolean isSelected;
    private static final Map colors = new HashMap();

    protected static Color convertColor(RGB rgbColor) {
        if (colors.containsKey(rgbColor)) {
            return (Color)colors.get(rgbColor);
        }
        Color newColor = new Color(rgbColor.getRed(), rgbColor.getGreen(), rgbColor.getBlue());
        colors.put(rgbColor, newColor);
        return newColor;
    }

    protected Primitive(PrimitiveFactory primitiveFactory, Point origin, Dimension dimension, RGB color) {
        this.primitiveFactory = primitiveFactory;
        this.origin = origin;
        this.dimension = dimension;
        this.color = color;
        this.computeDestination();
    }

    public final void build() {
    }

    private void computeDestination() {
        this.destination = new Point(this.origin.x + this.dimension.width, this.origin.y + this.dimension.height);
    }

    public Color getAWTColor() {
        return Primitive.convertColor(this.color);
    }

    public RGB getRGBColor() {
        return this.color;
    }

    public final Point getDestination() {
        return this.destination;
    }

    public final Dimension getDimension() {
        return this.dimension;
    }

    public final Graphics getGraphics() {
        return this.primitiveFactory.getGraphics();
    }

    public final PrimitiveFactory getPrimitiveFactory() {
        return this.primitiveFactory;
    }

    public String getName() {
        return "ptidej.ui.primitive.awt.Primitive (" + this.getClass() + ')';
    }

    public final Point getPosition() {
        return this.origin;
    }

    public boolean isNameShowable() {
        return false;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public boolean processMouseEvent(MouseEvent me) {
        return false;
    }

    public void setDimension(Dimension dimension) {
        this.dimension = dimension;
        this.computeDestination();
    }

    public void setPosition(Point position) {
        this.origin = position;
        this.computeDestination();
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    public abstract void paint(int var1, int var2);
}

