/*
 * Decompiled with CFR 0.152.
 */
package ptidej.ui.primitive.awt;

import java.awt.Dimension;
import java.awt.Point;
import ptidej.ui.RGB;
import ptidej.ui.primitive.awt.Primitive;
import ptidej.ui.primitive.awt.PrimitiveFactory;

public abstract class Symbol
extends Primitive
implements ptidej.ui.primitive.Symbol {
    private int symbolDirection;

    Symbol(PrimitiveFactory primitiveFactory, Point origin, Dimension dimension, int symbolDirection, RGB color) {
        super(primitiveFactory, origin, dimension, color);
        this.symbolDirection = symbolDirection;
    }

    protected static int[][] computeCoordinates(Point origin, Dimension dimension, int direction, int symbolWidth, int symbolHeight) {
        int theDirection = direction;
        if (dimension.height > 0 && dimension.width >= 0 || dimension.height <= 0 && dimension.width < 0) {
            theDirection = -theDirection;
        }
        int xOrg = origin.x;
        int yOrg = origin.y;
        int xDest = 0;
        int yDest = 0;
        int xMid1 = 0;
        int yMid1 = 0;
        int xMid2 = 0;
        int yMid2 = 0;
        double slope = (double)dimension.height / (double)dimension.width;
        if (slope != Double.POSITIVE_INFINITY && slope != Double.NEGATIVE_INFINITY) {
            double alpha = Math.atan(slope);
            xDest = (int)Math.round((double)xOrg + (double)(theDirection * symbolHeight) * Math.cos(alpha));
            yDest = (int)Math.round((double)yOrg + (double)(theDirection * symbolHeight) * Math.sin(alpha));
            double xMid = (xOrg + xDest) / 2;
            double yMid = (yOrg + yDest) / 2;
            xMid1 = (int)Math.round(xMid - (double)symbolWidth * Math.sin(alpha) / 2.0);
            yMid1 = (int)Math.round(yMid + (double)symbolWidth * Math.cos(alpha) / 2.0);
            xMid2 = (int)Math.round(xMid + (double)symbolWidth * Math.sin(alpha) / 2.0);
            yMid2 = (int)Math.round(yMid - (double)symbolWidth * Math.cos(alpha) / 2.0);
        } else {
            xDest = xOrg;
            yDest = yOrg + theDirection * symbolHeight;
            int xMid = (xOrg + xDest) / 2;
            int yMid = (yOrg + yDest) / 2;
            xMid1 = xMid - symbolWidth / 2;
            yMid1 = yMid;
            xMid2 = xMid + symbolWidth / 2;
            yMid2 = yMid;
        }
        return new int[][]{{xOrg, xMid1, xDest, xMid2}, {yOrg, yMid1, yDest, yMid2}};
    }

    public int getDirection() {
        return this.symbolDirection;
    }
}

