/*
 * Decompiled with CFR 0.152.
 */
package ptidej.ui.solution;

import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import ptidej.solver.Solution;
import ptidej.solver.SolutionBuilder;
import ptidej.solver.SolutionComponent;
import ptidej.ui.Canvas;
import ptidej.ui.Constants;
import ptidej.ui.event.MouseEvent;
import ptidej.ui.kernel.Constituent;
import ptidej.ui.kernel.GraphicModel;
import ptidej.ui.layout.InheritanceClusterLayout;
import ptidej.ui.solution.GroupRectangleButton;
import ptidej.ui.solution.GroupSolutionPattern;
import ptidej.ui.solution.PrimitiveFactory;

public final class GroupSolution
extends Constituent {
    private final Canvas canvas;
    private final Solution solution;
    private final SolutionBuilder solutionBuilder;
    private final GraphicModel currentModel;
    private List groupRectangleButtons = new ArrayList();
    private boolean isSelected;
    private GroupSolutionPattern groupSolutionPattern;

    public GroupSolution(Canvas canvas, PrimitiveFactory primitiveFactory, Solution solution, SolutionBuilder solutionBuilder, GraphicModel currentPattern) {
        super(primitiveFactory);
        this.canvas = canvas;
        this.solution = solution;
        this.solutionBuilder = solutionBuilder;
        this.currentModel = currentPattern;
    }

    public void build() {
        this.groupRectangleButtons.clear();
        List components = this.solution.getComponents();
        int i = 0;
        while (i < components.size()) {
            SolutionComponent component = (SolutionComponent)components.get(i);
            String componentName = component.getName();
            String componentValue = component.getValue();
            if (!componentName.equals("Name") && !componentName.equals("XCommand") && this.currentModel.getActor(componentValue) != null) {
                GroupRectangleButton button = ((PrimitiveFactory)this.getPrimitiveFactory()).createGroupRectangleButton(this.solution.getPercentage(), this.computeComponentPosition(componentValue), this.computeComponentDimension(componentValue), Constants.FOREGROUND_COLOR);
                button.setSelected(this.isSelected);
                this.groupRectangleButtons.add(button);
            }
            ++i;
        }
    }

    private Dimension computeComponentDimension(String entityName) {
        Constituent constituent = this.currentModel.getActor(entityName);
        if (constituent == null) {
            return Constants.MAX_DIMENSION;
        }
        Dimension dimension = constituent.getDimension();
        dimension = new Dimension(dimension.width + Constants.SOLUTION_FRAME_GAP.width * 2, dimension.height + Constants.SOLUTION_FRAME_GAP.height * 2);
        return dimension;
    }

    private Point computeComponentPosition(String entityName) {
        Constituent constituent = this.currentModel.getActor(entityName);
        Point point = new Point(constituent.getPosition());
        point.translate(-Constants.SOLUTION_FRAME_GAP.width, -Constants.SOLUTION_FRAME_GAP.height);
        return point;
    }

    public int getPercentage() {
        return this.solution.getPercentage();
    }

    public Point getPosition() {
        return ((GroupRectangleButton)this.groupRectangleButtons.get(0)).getPosition();
    }

    public Solution getSolution() {
        return this.solution;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public boolean isShowable() {
        return this.groupRectangleButtons.size() > 0;
    }

    public void paint(int xOffset, int yOffset) {
        Iterator allButtons = this.groupRectangleButtons.iterator();
        while (allButtons.hasNext()) {
            GroupRectangleButton button = (GroupRectangleButton)allButtons.next();
            button.paint(xOffset, yOffset);
        }
    }

    public boolean processMouseEvent(MouseEvent me) {
        int nbOfButtons = this.groupRectangleButtons.size();
        GroupRectangleButton button = null;
        boolean hasBeenPressed = false;
        int buttonNumber = 0;
        while (buttonNumber < nbOfButtons && !hasBeenPressed) {
            button = (GroupRectangleButton)this.groupRectangleButtons.get(buttonNumber);
            hasBeenPressed = button.processMouseEvent(me);
            ++buttonNumber;
        }
        if (hasBeenPressed) {
            this.setSelected(!this.isSelected());
            this.groupSolutionPattern.setPosition(button.getDestination());
        }
        return hasBeenPressed;
    }

    public void setSelected(boolean isSelected) {
        if (isSelected) {
            Point tipPosition = ((GroupRectangleButton)this.groupRectangleButtons.get(this.groupRectangleButtons.size() - 1)).getDestination();
            if (this.groupSolutionPattern == null) {
                GraphicModel dPattern = new GraphicModel((PrimitiveFactory)this.getPrimitiveFactory(), this.solutionBuilder.getSolutionPattern(this.solution, this.currentModel.getModel()), new InheritanceClusterLayout());
                dPattern.setVisibleElements(this.currentModel.getVisibleElements());
                dPattern.build();
                this.groupSolutionPattern = ((PrimitiveFactory)this.getPrimitiveFactory()).createGroupSolutionPattern(tipPosition, dPattern, this.toString(), Constants.FOREGROUND_COLOR);
            } else {
                this.groupSolutionPattern.setPosition(tipPosition);
                this.groupSolutionPattern.setVisibleElements(this.currentModel.getVisibleElements());
            }
            this.canvas.addToForeground(this.groupSolutionPattern);
            this.groupSolutionPattern.setSelected(true);
        } else {
            this.canvas.removeFromForeground(this.groupSolutionPattern);
            this.groupSolutionPattern.setSelected(false);
        }
        Iterator allButtons = this.groupRectangleButtons.iterator();
        while (allButtons.hasNext()) {
            GroupRectangleButton button = (GroupRectangleButton)allButtons.next();
            button.setSelected(isSelected);
        }
        this.isSelected = isSelected;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Micro-architecture ");
        buffer.append(this.solution.getNumber());
        buffer.append(" similar at ");
        buffer.append(this.solution.getPercentage());
        buffer.append("% with ");
        buffer.append(this.solution.getName());
        buffer.append('\n');
        Iterator allComponents = this.solution.getComponents().iterator();
        while (allComponents.hasNext()) {
            buffer.append('\t');
            buffer.append(((SolutionComponent)allComponents.next()).toString());
            buffer.append('\n');
        }
        return buffer.toString();
    }
}

