/*
 * Decompiled with CFR 0.152.
 */
package ptidej.ui.solution.awt;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import ptidej.ui.Constants;
import ptidej.ui.RGB;
import ptidej.ui.primitive.awt.Button;
import ptidej.ui.primitive.awt.Primitive;
import ptidej.ui.primitive.awt.PrimitiveFactory;

public final class GroupRectangleButton
extends Button
implements ptidej.ui.solution.GroupRectangleButton {
    private int percentage;
    private int[][] handlesPositions;

    GroupRectangleButton(PrimitiveFactory primitiveFactory, int percentage, Point position, Dimension dimension, RGB color) {
        super(primitiveFactory, Integer.toString(percentage), position, dimension, true, color);
        this.percentage = percentage;
        this.setPositionAndDimension();
    }

    public void paint(int xOffset, int yOffset) {
        this.getGraphics().setColor(Primitive.convertColor(RGB.computePercentagedColor(this.percentage)));
        this.getGraphics().drawRect(this.getPosition().x + xOffset, this.getPosition().y + yOffset, this.getDimension().width, this.getDimension().height);
        this.getGraphics().drawRect(this.getPosition().x + xOffset - 1, this.getPosition().y + yOffset - 1, this.getDimension().width + 2, this.getDimension().height + 2);
        if (this.isSelected()) {
            int i = 0;
            while (i < this.handlesPositions.length) {
                this.getGraphics().fillRect(this.handlesPositions[i][0], this.handlesPositions[i][1], Constants.SOLUTION_HANDLE_DIMENSION.width, Constants.SOLUTION_HANDLE_DIMENSION.height);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.handlesPositions.length) {
                this.getGraphics().drawRect(this.handlesPositions[i][0], this.handlesPositions[i][1], Constants.SOLUTION_HANDLE_DIMENSION.width, Constants.SOLUTION_HANDLE_DIMENSION.height);
                ++i;
            }
        }
    }

    public boolean processMouseEvent(MouseEvent me) {
        if (me.getID() == 500) {
            boolean isInRange = false;
            int i = 0;
            while (i < this.handlesPositions.length) {
                isInRange |= this.handlesPositions[i][0] <= me.getX() && this.handlesPositions[i][1] <= me.getY() && me.getX() <= this.handlesPositions[i][0] + Constants.SOLUTION_HANDLE_DIMENSION.width && me.getY() <= this.handlesPositions[i][1] + Constants.SOLUTION_HANDLE_DIMENSION.height;
                ++i;
            }
            if (isInRange && me.getID() == 500) {
                this.setSelected(!this.isSelected());
                return true;
            }
        }
        return false;
    }

    public void setDimension(Dimension dimension) {
        super.setDimension(dimension);
        this.setPositionAndDimension();
    }

    public void setPosition(Point position) {
        super.setPosition(position);
        this.setPositionAndDimension();
    }

    private void setPositionAndDimension() {
        int x = this.getPosition().x;
        int y = this.getPosition().y;
        int w = this.getDimension().width;
        int h = this.getDimension().height;
        this.handlesPositions = new int[4][];
        this.handlesPositions[0] = new int[]{x, y};
        this.handlesPositions[1] = new int[]{x, y + h - Constants.SOLUTION_HANDLE_DIMENSION.height};
        this.handlesPositions[2] = new int[]{x + w - Constants.SOLUTION_HANDLE_DIMENSION.width, y};
        this.handlesPositions[3] = new int[]{x + w - Constants.SOLUTION_HANDLE_DIMENSION.width, y + h - Constants.SOLUTION_HANDLE_DIMENSION.height};
    }
}

