/*
 * Decompiled with CFR 0.152.
 */
package ptidej.ui.solution.awt;

import java.awt.Dimension;
import java.awt.Point;
import ptidej.ui.RGB;
import ptidej.ui.VisibilityElement;
import ptidej.ui.kernel.GraphicModel;
import ptidej.ui.solution.awt.GroupSolutionTip;
import ptidej.ui.solution.awt.PrimitiveFactory;

public final class GroupSolutionPattern
extends GroupSolutionTip
implements VisibilityElement,
ptidej.ui.solution.GroupSolutionPattern {
    private final GraphicModel pattern;
    private final int offsetY;
    private final int baseHeight;

    protected GroupSolutionPattern(PrimitiveFactory primitiveFactory, Point position, GraphicModel pattern, String tip, RGB color) {
        super((ptidej.ui.primitive.awt.PrimitiveFactory)primitiveFactory, position, tip, color);
        this.pattern = pattern;
        this.offsetY = this.getDimension().height;
        this.baseHeight = this.getDimension().height;
        this.setDimension();
    }

    public int getVisibleElements() {
        return this.pattern.getVisibleElements();
    }

    public void paint(int xOffset, int yOffset) {
        super.paint(xOffset, yOffset);
        this.pattern.paint(this.getPosition().x, this.getPosition().y + this.offsetY);
    }

    public String toString() {
        return super.toString();
    }

    private void setDimension() {
        this.setDimension(new Dimension(Math.max(this.getDimension().width, this.pattern.getDimension().width), this.baseHeight + this.pattern.getDimension().height));
    }

    public void setVisibleElements(int visibility) {
        this.pattern.setVisibleElements(visibility);
        this.pattern.build();
        this.setDimension();
    }
}

