/*
 * Decompiled with CFR 0.152.
 */
package ptidej.ui.solution.awt;

import java.awt.Dimension;
import java.awt.Point;
import java.util.StringTokenizer;
import ptidej.ui.Constants;
import ptidej.ui.RGB;
import ptidej.ui.primitive.awt.Primitive;
import ptidej.ui.primitive.awt.PrimitiveFactory;

public class GroupSolutionTip
extends Primitive
implements ptidej.ui.solution.GroupSolutionTip {
    private final String tip;
    private final int lineHeight;

    GroupSolutionTip(PrimitiveFactory primitiveFactory, Point position, String tip, RGB color) {
        super(primitiveFactory, position, Constants.NULL_DIMENSION, color);
        this.setPosition(new Point(position.x + Constants.TIP_GAP.width, position.y + Constants.TIP_GAP.height));
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < tip.length()) {
            char c = tip.charAt(i);
            if (c != '\t') {
                buffer.append(c);
            } else {
                int j = 0;
                while (j < 4) {
                    buffer.append(' ');
                    ++j;
                }
            }
            ++i;
        }
        this.tip = buffer.toString();
        this.lineHeight = this.getGraphics().getFontMetrics().getHeight();
        StringTokenizer tokenizer = new StringTokenizer(this.tip, "\n");
        int numberOfLines = tokenizer.countTokens();
        int longestLineWidth = 0;
        while (tokenizer.hasMoreTokens()) {
            longestLineWidth = Math.max(longestLineWidth, this.getGraphics().getFontMetrics().stringWidth(tokenizer.nextToken()));
        }
        this.setDimension(new Dimension(longestLineWidth += Constants.TIP_GAP.width, numberOfLines * this.lineHeight + Constants.TIP_GAP.height));
    }

    public void paint(int xOffset, int yOffset) {
        this.getGraphics().setColor(Primitive.convertColor(Constants.TIP_BACKGROUND_COLOR));
        this.getGraphics().fillRect(this.getPosition().x + xOffset, this.getPosition().y + yOffset, this.getDimension().width, this.getDimension().height);
        this.getGraphics().setColor(Primitive.convertColor(Constants.FOREGROUND_COLOR));
        this.getGraphics().drawRect(this.getPosition().x + xOffset, this.getPosition().y + yOffset, this.getDimension().width, this.getDimension().height);
        StringTokenizer tokenizer = new StringTokenizer(this.tip, "\n");
        int yPos = this.lineHeight;
        while (tokenizer.hasMoreTokens()) {
            this.getGraphics().drawString(tokenizer.nextToken(), this.getPosition().x + xOffset + Constants.TIP_GAP.width / 2, this.getPosition().y + yOffset + yPos);
            yPos += this.lineHeight;
        }
    }

    public String toString() {
        return this.tip;
    }
}

