/*
 * Decompiled with CFR 0.152.
 */
package ptidej.util.combination;

public final class BitString {
    private int numberOfBits;
    private int value;

    public BitString(int numberOfBits) {
        this.numberOfBits = numberOfBits;
    }

    private int compose(boolean[] bits) {
        int value = 0;
        int i = 0;
        while (i < this.numberOfBits) {
            value = (int)((double)value + (bits[i] ? Math.pow(2.0, this.numberOfBits - 1 - i) : 0.0));
            ++i;
        }
        return value;
    }

    public void dec() {
        --this.value;
    }

    private boolean[] decompose(int value) {
        boolean[] bits = new boolean[this.numberOfBits];
        int i = this.numberOfBits;
        while (value > 0 && i >= 0) {
            bits[--i] = value % 2 > 0;
            value /= 2;
        }
        return bits;
    }

    public int getInteger() {
        return this.value;
    }

    public String getString() {
        boolean[] bits = this.decompose(this.value);
        StringBuffer buffer = new StringBuffer(this.numberOfBits);
        int i = 0;
        while (i < this.numberOfBits) {
            buffer.append(bits[i] ? (char)'1' : '0');
            ++i;
        }
        return buffer.toString();
    }

    public void inc() {
        ++this.value;
    }

    public void set(boolean[] bits) {
        if (bits.length != this.numberOfBits) {
            throw new RuntimeException("The number of bits must be " + this.numberOfBits);
        }
        this.value = this.compose(bits);
    }

    public void set(int value) {
        this.value = value;
    }

    public void set(String value) {
        if (value.length() != this.numberOfBits) {
            throw new RuntimeException("The number of bits must be " + this.numberOfBits);
        }
        boolean[] bits = new boolean[this.numberOfBits];
        int i = 0;
        while (i < this.numberOfBits) {
            bits[i] = value.charAt(i) == '1';
            ++i;
        }
        this.value = this.compose(bits);
    }

    public String toString() {
        return this.getString();
    }
}

