/*
 * Decompiled with CFR 0.152.
 */
package ptidej.util.ibm.collection;

import ptidej.util.ibm.collection.AbstractCollection;
import ptidej.util.ibm.collection.Collection;
import ptidej.util.ibm.collection.ConcurrentModificationException;
import ptidej.util.ibm.collection.Iterator;
import ptidej.util.ibm.collection.List;
import ptidej.util.ibm.collection.ListIterator;
import ptidej.util.ibm.collection.NoSuchElementException;
import ptidej.util.ibm.collection.SubList;

public abstract class AbstractList
extends AbstractCollection
implements List {
    protected transient int modCount = 0;

    protected AbstractList() {
    }

    public void add(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    public boolean add(Object o) {
        this.add(this.size(), o);
        return true;
    }

    public boolean addAll(int index, Collection c) {
        boolean modified = false;
        Iterator e = c.iterator();
        while (e.hasNext()) {
            this.add(index++, e.next());
            modified = true;
        }
        return modified;
    }

    public void clear() {
        this.removeRange(0, this.size());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        ListIterator e1 = this.listIterator();
        ListIterator e2 = ((List)o).listIterator();
        while (e1.hasNext() && e2.hasNext()) {
            Object o1 = e1.next();
            Object o2 = e2.next();
            if (!(o1 == null ? o2 != null : !o1.equals(o2))) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    public abstract Object get(int var1);

    public int hashCode() {
        int hashCode = 1;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        return hashCode;
    }

    /*
     * Unable to fully structure code
     */
    public int indexOf(Object o) {
        block2: {
            e = this.listIterator();
            if (o != null) ** GOTO lbl9
            while (e.hasNext()) {
                if (e.next() != null) continue;
                return e.previousIndex();
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                if (!o.equals(e.next())) continue;
                return e.previousIndex();
lbl9:
                // 2 sources

                ** while (e.hasNext())
            }
        }
        return -1;
    }

    public Iterator iterator() {
        return new Itr();
    }

    /*
     * Unable to fully structure code
     */
    public int lastIndexOf(Object o) {
        block2: {
            e = this.listIterator(this.size());
            if (o != null) ** GOTO lbl9
            while (e.hasPrevious()) {
                if (e.previous() != null) continue;
                return e.nextIndex();
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                if (!o.equals(e.previous())) continue;
                return e.nextIndex();
lbl9:
                // 2 sources

                ** while (e.hasPrevious())
            }
        }
        return -1;
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new ListItr(index);
    }

    public Object remove(int index) {
        throw new UnsupportedOperationException();
    }

    protected void removeRange(int fromIndex, int toIndex) {
        ListIterator it = this.listIterator(fromIndex);
        int i = 0;
        int n = toIndex - fromIndex;
        while (i < n) {
            it.next();
            it.remove();
            ++i;
        }
    }

    public Object set(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    public List subList(int fromIndex, int toIndex) {
        return new SubList(this, fromIndex, toIndex);
    }

    private class Itr
    implements Iterator {
        int cursor = 0;
        int lastRet = -1;
        int expectedModCount;

        Itr() {
            this.expectedModCount = AbstractList.this.modCount;
        }

        public boolean hasNext() {
            return this.cursor != AbstractList.this.size();
        }

        public Object next() {
            try {
                Object next = AbstractList.this.get(this.cursor);
                this.checkForComodification();
                this.lastRet = this.cursor++;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        public void remove() {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            try {
                AbstractList.this.remove(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
                int newModCount = AbstractList.this.modCount;
                if (newModCount - this.expectedModCount > 1) {
                    throw new ConcurrentModificationException();
                }
                this.expectedModCount = newModCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        final void checkForComodification() {
            if (AbstractList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator {
        ListItr(int index) {
            this.cursor = index;
        }

        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        public Object previous() {
            try {
                Object previous = AbstractList.this.get(--this.cursor);
                this.checkForComodification();
                this.lastRet = this.cursor;
                return previous;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        public int nextIndex() {
            return this.cursor;
        }

        public int previousIndex() {
            return this.cursor - 1;
        }

        public void set(Object o) {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            try {
                AbstractList.this.set(this.lastRet, o);
                int newModCount = AbstractList.this.modCount;
                if (newModCount - this.expectedModCount > 1) {
                    throw new ConcurrentModificationException();
                }
                this.expectedModCount = newModCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(Object o) {
            try {
                AbstractList.this.add(this.cursor++, o);
                this.lastRet = -1;
                int newModCount = AbstractList.this.modCount;
                if (newModCount - this.expectedModCount > 1) {
                    throw new ConcurrentModificationException();
                }
                this.expectedModCount = newModCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

