/*
 * Decompiled with CFR 0.152.
 */
package ptidej.viewer.applet;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;
import padl.kernel.ModelDeclarationException;
import ptidej.ui.event.SourceEvent;
import ptidej.ui.event.SourceListener;
import ptidej.viewer.applet.example.DynamicSimpleDocument;
import ptidej.viewer.applet.example.ModifiedDynamicSimpleDocument;
import ptidej.viewer.applet.example.ModifiedSimpleDocument;
import ptidej.viewer.applet.example.SimpleDocument;
import ptidej.viewer.core.ViewerPanel;
import util.io.ReaderInputStream;

public final class ConstraintViewerPanel
extends ptidej.viewer.core.ConstraintViewerPanel {
    private boolean isExtraInformationLoaded = false;
    private static final String[] ForbiddenButtons = new String[]{"Generate program model", "Generate solver execution data", "Find similar micro-architectures", "Create Ptidej project", "Add AOL file (.aol)", "Add C++ file (.cpp)", "Add JAR file (.jar)", "Add Java file (.class)", "Add Java package (.class)", "Save Ptidej project", "Print", "Exit"};

    private static void disableForbiddenButtons(Container root) {
        Component[] components = root.getComponents();
        int i = 0;
        while (i < components.length) {
            int j = 0;
            while (j < ForbiddenButtons.length) {
                if (components[i].getName() != null && components[i].getName().equals(ForbiddenButtons[j])) {
                    components[i].setEnabled(false);
                }
                ++j;
            }
            if (components[i] instanceof Container) {
                ConstraintViewerPanel.disableForbiddenButtons((Container)components[i]);
            }
            ++i;
        }
    }

    public ConstraintViewerPanel() {
        ConstraintViewerPanel.disableForbiddenButtons(this);
        this.addSourceListener(new SourceListener(){

            public void sourceStateChanged(SourceEvent sourceEvent) {
                ConstraintViewerPanel.disableForbiddenButtons(ConstraintViewerPanel.this);
            }
        });
    }

    protected void displayAboutDialog() {
        new ViewerPanel.AboutDialog((ViewerPanel)this, new Frame("")).show();
    }

    protected void loadConstraintsInformation() {
        String results = "[Composite Model Problem]\n# More solution without constraint 5: Composites -|>- Components of weight 50\n1.50.Name = Composite design pattern\n1.50.XCommand = Composite, Component | javaXL.XClass c1, javaXL.XClass c2 | c1.setSuperclass(c2.getName());\n1.50.LeavesType = Element\n1.50.Leave = Paragraph\n1.50.Composite = Document\n1.50.Component = Element\n\n# More solution without constraint 5: Composites -|>- Components of weight 50\n2.50.Name = Composite design pattern\n2.50.XCommand = Composite, Component | javaXL.XClass c1, javaXL.XClass c2 | c1.setSuperclass(c2.getName());\n2.50.LeavesType = Element\n2.50.Leave = Title\n2.50.Composite = Document\n2.50.Component = Element\n\n# More solution without constraint 4: Leaves -|>- LeavesTypes of weight 75\n3.25.Name = Composite design pattern\n3.25.XCommand = Leave, LeavesType | javaXL.XClass l1, javaXL.XClass l2 | l1.setSuperclass(l2.getName());\n3.25.LeavesType = Element\n3.25.Leave = Paragraph\n3.25.Composite = Document\n3.25.Component = Element\n\n# More solution without constraint 4: Leaves -|>- LeavesTypes of weight 75\n4.25.Name = Composite design pattern\n4.25.XCommand = Leave, LeavesType | javaXL.XClass l1, javaXL.XClass l2 | l1.setSuperclass(l2.getName());\n4.25.LeavesType = Element\n4.25.Leave = IndentedParagraph\n4.25.Composite = Document\n4.25.Component = Element\n\n# More solution without constraint 4: Leaves -|>- LeavesTypes of weight 75\n5.25.Name = Composite design pattern\n5.25.XCommand = Leave, LeavesType | javaXL.XClass l1, javaXL.XClass l2 | l1.setSuperclass(l2.getName());\n5.25.LeavesType = Element\n5.25.Leave = Title\n5.25.Composite = Document\n5.25.Component = Element\n";
        Properties p = new Properties();
        try {
            p.load(new ReaderInputStream(new StringReader("[Composite Model Problem]\n# More solution without constraint 5: Composites -|>- Components of weight 50\n1.50.Name = Composite design pattern\n1.50.XCommand = Composite, Component | javaXL.XClass c1, javaXL.XClass c2 | c1.setSuperclass(c2.getName());\n1.50.LeavesType = Element\n1.50.Leave = Paragraph\n1.50.Composite = Document\n1.50.Component = Element\n\n# More solution without constraint 5: Composites -|>- Components of weight 50\n2.50.Name = Composite design pattern\n2.50.XCommand = Composite, Component | javaXL.XClass c1, javaXL.XClass c2 | c1.setSuperclass(c2.getName());\n2.50.LeavesType = Element\n2.50.Leave = Title\n2.50.Composite = Document\n2.50.Component = Element\n\n# More solution without constraint 4: Leaves -|>- LeavesTypes of weight 75\n3.25.Name = Composite design pattern\n3.25.XCommand = Leave, LeavesType | javaXL.XClass l1, javaXL.XClass l2 | l1.setSuperclass(l2.getName());\n3.25.LeavesType = Element\n3.25.Leave = Paragraph\n3.25.Composite = Document\n3.25.Component = Element\n\n# More solution without constraint 4: Leaves -|>- LeavesTypes of weight 75\n4.25.Name = Composite design pattern\n4.25.XCommand = Leave, LeavesType | javaXL.XClass l1, javaXL.XClass l2 | l1.setSuperclass(l2.getName());\n4.25.LeavesType = Element\n4.25.Leave = IndentedParagraph\n4.25.Composite = Document\n4.25.Component = Element\n\n# More solution without constraint 4: Leaves -|>- LeavesTypes of weight 75\n5.25.Name = Composite design pattern\n5.25.XCommand = Leave, LeavesType | javaXL.XClass l1, javaXL.XClass l2 | l1.setSuperclass(l2.getName());\n5.25.LeavesType = Element\n5.25.Leave = Title\n5.25.Composite = Document\n5.25.Component = Element\n")));
            this.loadConstraintsInformation(p);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    protected void loadExtraInformation() {
        try {
            this.isExtraInformationLoaded = true;
            DynamicSimpleDocument pattern = new DynamicSimpleDocument();
            this.addSource(pattern, String.valueOf(pattern.getName()) + " (after dynamic analysis)");
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace();
        }
        catch (ModelDeclarationException pde) {
            pde.printStackTrace();
        }
    }

    protected void loadProject() {
        try {
            SimpleDocument pattern = new SimpleDocument();
            this.addSource(pattern, pattern.getName());
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace();
        }
        catch (ModelDeclarationException pde) {
            pde.printStackTrace();
        }
    }

    protected void modifyStructure() {
        try {
            SimpleDocument pattern = this.isExtraInformationLoaded ? new ModifiedDynamicSimpleDocument() : new ModifiedSimpleDocument();
            this.addSource(pattern, String.valueOf(pattern.getName()) + " (corrected)");
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace();
        }
        catch (ModelDeclarationException pde) {
            pde.printStackTrace();
        }
    }
}

